use strict;

BEGIN { $| = 1;
	use Test ;
	plan tests => 14;
}

use Bio::EnsEMBL::Test::MultiTestDB;
use Bio::EnsEMBL::Test::TestUtils;

our $verbose = 0; #set to 1 to turn on debug printouts

my $multi = Bio::EnsEMBL::Test::MultiTestDB->new();
my $db = $multi->get_DBAdaptor( 'core' );

#
# 1 Test AssemblyMapperAdaptor constructor
#
my $asma = $db->get_AssemblyMapperAdaptor();


ok($asma && $asma->isa('Bio::EnsEMBL::DBSQL::AssemblyMapperAdaptor'));


#
# 2 Test fetch_by_CoordSystems
#

my $csa = $db->get_CoordSystemAdaptor();
my $chr_cs = $csa->fetch_by_name('chromosome');
my $cln_cs = $csa->fetch_by_name('clone');
my $sctg_cs = $csa->fetch_by_name('supercontig');

my $asm_mapper = $asma->fetch_by_CoordSystems($cln_cs, $chr_cs);

ok($asm_mapper && $asm_mapper->isa('Bio::EnsEMBL::ChainedAssemblyMapper'));

my $chr_sctg_mapper = $asma->fetch_by_CoordSystems($chr_cs, $sctg_cs);
ok($chr_sctg_mapper &&
   $chr_sctg_mapper->isa('Bio::EnsEMBL::ChainedAssemblyMapper'));




#
# test db has chr 20  (50KB -> 62MB)
#

#
# 3 Test map
#

my @coords = $asm_mapper->map('20', 500_001, 60_000_000, 1, $chr_cs);
ok(@coords);
debug("MAP 20->clone\n");
print_coords(@coords);

debug("MAP 'AL359765.6'->chromosome\n");
@coords = $asm_mapper->map('AL359765.6', 1, 13780, 1, $cln_cs);
ok(@coords);
print_coords(@coords);

debug("MAP 20->supercontig\n");
@coords = $chr_sctg_mapper->map('20', 500_001, 60_000_000, 1, $chr_cs);
ok(@coords);
print_coords(@coords);


#
# Test list_seq_regions
#

my @seq_regions =
  $asm_mapper->list_seq_regions('20', 500_001, 60_000_000, $chr_cs);
ok(@seq_regions);
my $str = join("\n", "----------", @seq_regions);
debug("$str\n");

@seq_regions =
  $asm_mapper->list_seq_regions('AL359765.6', 1, 13780, $cln_cs);
ok(@seq_regions);
$str = join("\n", "----------", @seq_regions);
debug("$str\n");

@seq_regions = 
  $chr_sctg_mapper->list_seq_regions('NT_028392',600_000, 1_000_000, $sctg_cs);
ok(@seq_regions);
$str = join("\n", "----------", @seq_regions);
debug("$str\n");


@seq_regions = 
  $chr_sctg_mapper->list_seq_regions('20', 30_000_000, 31_000_000, $chr_cs);
ok(@seq_regions);
$str = join("\n", "----------", @seq_regions);
debug("$str\n");


#
# Test list_seq_ids
#


my @seq_ids =
  $asm_mapper->list_ids('20', 500_001, 60_000_000, $chr_cs);
ok(@seq_ids);
$str = join("\n", "----------", @seq_ids);
debug("$str\n");

@seq_ids =
  $asm_mapper->list_ids('AL359765.6', 1, 13780, $cln_cs);
ok(@seq_ids);
$str = join("\n", "----------", @seq_ids);
debug("$str\n");

@seq_ids =
  $asm_mapper->list_ids('AL359765.6', 1, 13780, $cln_cs);
ok(@seq_ids);
$str = join("\n", "----------", @seq_ids);
debug("$str\n");

@seq_ids = 
  $chr_sctg_mapper->list_ids('20', 30_000_000, 31_000_000, $chr_cs);
ok(@seq_ids);
$str = join("\n", "----------", @seq_ids);
debug("$str\n");




sub print_coords {
  my @coord_list = @_;

  return if(!$verbose);

  foreach my $coord (@coord_list) {
    if($coord->isa('Bio::EnsEMBL::Mapper::Gap')) {
      debug("GAP");
      next;
    }
    debug($coord->id()."\t". $coord->start()."-".$coord->end().
          " (".$coord->strand.")");
  }
}

