# patch_52_53manual.sql
#
# title: Manual data patch
#
# description:
# Some manual data patches dependant on species


SELECT 'patch_53_54_manual.sql must be applied manually for each species where appropriate';
exit;

--These external_feature DBEntry patches are due to
--duplicates being generated by null values in a unique key
--Hence they are entirely dependant on whther there are any other 
--sets which have generates similar xref records, and may well 
--require a reload of the data.

--cisRED/xref patch mouse

update xref set info_text='GENE' where info_text='Gene';
--lowest mouse external_feature_id is 534119

--mysql> select distinct(x.info_text) from xref x, object_xref ox where ox.ensembl_object_type='ExternalFeature' AND x.xref_id=ox.xref_id and ox.ensembl_id >=534119;
--+-----------+
--| info_text |
--+-----------+
--| GENE      | 
--+-----------+

--mysql> select distinct(x.info_text) from xref x, object_xref ox where ox.ensembl_object_type='ExternalFeature' AND x.xref_id=ox.xref_id and ox.ensembl_id <534119;
--+-----------+
--| info_text |
--+-----------+
--| NULL      | 
--+-----------+

-- Let's get rid of these then?
delete x, ox from xref x, object_xref ox where ox.ensembl_object_type='ExternalFeature' AND x.xref_id=ox.xref_id and ox.ensembl_id <534119;
--Query OK, 594132 rows affected (36.82 sec)

-- We now have lots of orphaned xref records from previous imports which have not been rolled back properly!
--mysql> select count(*) from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
--+----------+
--| count(*) |
--+----------+
--|   237152 | 
--+----------+


--Delete these
delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
--Query OK, 237152 rows affected (20.48 sec)

--Now we still have all the duplicate transcript xrefs from the illumina mapping
--There are not other transcript mapped sets for mouse???
--Let's RollbackArrays first and see what's left

--Now left with some oxs without ensembl_object_types
--mysql> delete from object_xref where ensembl_object_type ='';
--Query OK, 399276 rows affected (10.99 sec)

--Now redo orhpaned xref count/delete

delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
--Query OK, 399276 rows affected (34.00 sec)


--Leaves us with just the non-duplicated cisred xrefs...yay!

--What about unmapped objects?

--we have some ProbeAlign without a type which have not been rolledback!
-- also have loads of old uos which may have not been deleted due to lack of edbid etc.
-- Deleted all and start mapping again
--is uo delete absent from Helper? for ProbeAlign?

-- stlil getting uo's without edb_id
-- rollback isn't deleting ProbeTranscriptAlign ProbeFeature oxs
-- or uo's!!
-- ou.type is enum'd to xref or probe2transcript so can't include this in the delete just yet.
-- bring up with core guys?

-- Found some old orhphaned Probe oxs with no xref records

delete ox from object_xref ox left join xref  x on ox.xref_id=x.xref_id where x.xref_id is NULL and ox.linkage_annotation='ProbeTranscriptAlign' and ox.ensembl_object_type='Probe';
--Query OK, 34 rows affected (0.28 sec)


-- Some other probe2transcript orphans
select count(ensembl_object_type) from object_xref ox left join xref  x on ox.xref_id=x.xref_id where x.xref_id is NULL and x.xref_id is NULL;
--+----------------------------+
--| count(ensembl_object_type) |
--+----------------------------+
--|                      80386 | 
--+----------------------------+

delete ox from object_xref ox left join xref  x on ox.xref_id=x.xref_id where x.xref_id is NULL and x.xref_id is NULL;
--Query OK, 80386 rows affected (4.06 sec)




-- Human



mysql> update xref set info_text='GENE' where info_text='Gene';
Query OK, 19299 rows affected (2.02 sec)
Rows matched: 19299  Changed: 19299  Warnings: 0


mysql> update xref set info_text='VARIATION' where info_text='Variation';
Query OK, 675 rows affected (1.22 sec)
Rows matched: 675  Changed: 675  Warnings: 0



-- Get rid of orphaned x's an dox's first
-- Probably need to test mouse using these

select * from object_xref ox left join xref  x on ox.xref_id=x.xref_id where x.xref_id is NULL limit 10;

--Empty set (7.09 sec)

select count(*) from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
--+----------+
--| count(*) |
--+----------+
--|   255035 | 
--+----------+

--Some cisRED some NULL description
-- NULLs are eQTLs? Do we still have these loaded?

--Only 29 eQTLs
delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL and x.description is NULL;
---Query OK, 29 rows affected (2.58 sec)

delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
--Query OK, 255006 rows affected (20.07 sec)


-- Now get rid of incorrect old probe2transcript ox's

delete from object_xref where ensembl_object_type ='';
--Query OK, 152727 rows affected (4.82 sec)


--Now redo orphaned xref delete

delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
--Query OK, 152727 rows affected (11.56 sec)


-- We still have incorrect xrefs from illumina mapping
-- Delete illumina mapping manually as rollback maybe not work

delete uo, ur from unmapped_reason ur, unmapped_object uo;
--Query OK, 17845 rows affected (1.46 sec)

delete ox from object_xref ox, probe p, array_chip ac where ox.ensembl_object_type='Probe' and ox.ensembl_id=p.probe_id and p.array_chip_id=ac.array_chip_id and ac.name in ('HumanWG_6_V2','HumanWG_6_V3');
--Query OK, 72758 rows affected (4.60 sec)

delete ox from object_xref ox, probe p, probe_feature pf, array_chip ac where ox.ensembl_object_type='ProbeFeature' and ox.ensembl_id=pf.probe_feature_id and pf.probe_id=p.probe_id and p.array_chip_id=ac.array_chip_id and ac.name in ('HumanWG_6_V2','HumanWG_6_V3');
--Query OK, 0 rows affected (0.00 sec)


-- Now redo orphaned xref delete
--Query OK, 72758 rows affected (5.85 sec)

--Now we have no NULL info_types!
mysql> select distinct(info_type) from xref;
+-----------+
| info_type |
+-----------+
| MISC      | 
| DIRECT    | 
| TARGET    | 
+-----------+

--So MISC are ?
mysql> select distinct(ox.linkage_annotation)  from xref x, object_xref ox where ox.xref_id=x.xref_id and x.info_type='MISC' limit 20;
+---------------------------+
| linkage_annotation        |
+---------------------------+
| cisRED motif gene         | 
| cisRED search region gene | 
+---------------------------+

--rest are
mysql> select distinct(ox.linkage_annotation)  from xref x, object_xref ox where ox.xref_id=x.xref_id and x.info_type!='MISC' limit 20;
+--------------------+
| linkage_annotation |
+--------------------+
| NULL               | 
| eQTL SNP xref      | 
| eQTL gene xref     | 
+--------------------+
3 rows in set (3.30 sec)

-- NULL ox.linkage_annotation are mirandas


-- test for DIRECT/TARGET info_types

-- Some TARGET are mirandas


--Let's fix the mirands first
update xref x, object_xref ox set description=NULL, info_type='MISC', info_text='TRANSCRIPT', linkage_annotation='miRanda target - negative influence' where description='miRanda miRNA transcript xref' and ox.xref_id=x.xref_id;
--Query OK, 913837 rows affected (37.29 sec)

--No more NULL linkage_annotations!

-- Remaning DIRECT/TARGET are eQTL SNP/TRANSCRIPT xrefs, but we are not using ENSVAR IDs here, we just have the rs IDs
-- Shall we just pull these eQTLs?

mysql> select distinct(ox.linkage_annotation) from object_xref ox, xref x where x.xref_id=ox.xref_id and x.info_type='TARGET';
+--------------------+
| linkage_annotation |
+--------------------+
| eQTL gene xref     | 
+--------------------+
1 row in set (0.06 sec)

mysql> select distinct(ox.linkage_annotation) from object_xref ox, xref x where x.xref_id=ox.xref_id and x.info_type='DIRECT';
+--------------------+
| linkage_annotation |
+--------------------+
| eQTL SNP xref      | 
+--------------------+

-- So they are not linked to anything else, but do we have duplicates between these gene IDs and cisRED xref gene ids?
mysql> select dbprimary_acc, count(dbprimary_acc) as cnt from xref group by dbprimary_acc order by cnt desc limit 10;
+-----------------+-----+
| dbprimary_acc   | cnt |
+-----------------+-----+
| ENSG00000176390 |   2 | 
| ENSG00000112218 |   2 | 
| ENSG00000104055 |   2 | 
| ENSG00000140829 |   2 | 
| ENSG00000083844 |   2 | 
| ENSG00000017797 |   2 | 
| ENSG00000105404 |   2 | 
| ENSG00000088888 |   2 | 
| ENSG00000167220 |   2 | 
| ENSG00000183617 |   2 | 
+-----------------+-----+
10 rows in set (0.10 sec)

-- Let's just delete the eQTL stuff until we know what we want to do with it?
-- Or should we update the ox's point at one?

-- Duplicates are from same edb, so let's get the TARGET info_type linked oxs pointing to the correct MISC xrefs
-- and change the linkage annotation to eQTL target instead of eQTL gene xref.  Then delete orphaned and see what we have left.
-- tricky!!

update object_xref ox, xref x, (select xref_id, dbprimary_acc from xref where info_type='MISC' and external_db_id=1) as t set ox.xref_id=t.xref_id, ox.linkage_annotation='eQTL Target' where ox.xref_id=x.xref_id and x.info_type='TARGET' and x.external_db_id=1 and x.dbprimary_acc=t.dbprimary_acc and ox.linkage_annotation='eQTL gene xref';
--Query OK, 12376 rows affected (1.11 sec)
--Rows matched: 12376  Changed: 12376  Warnings: 0

-- Now do orphaned xref delete
Query OK, 425 rows affected (1.09 sec)

-- No duplicates!!!

-- We still have a load of eQTL TARGET xrefs which were not duplicated
update object_xref ox, xref x set ox.linkage_annotation='eQTL Target', x.info_type='MISC', x.info_text='GENE' where x.xref_id=ox.xref_id and ox.linkage_annotation='eQTL gene xref';
--Query OK, 1923 rows affected (7.34 sec)
--Rows matched: 1923  Changed: 1923  Warnings: 0

--No more TARGET xrefs

-- Now deal with DIRECT xrefs
-- These are

update xref x, object_xref ox set x.info_type='MISC', ox.linkage_annotation='eQTL SNP' where x.xref_id=ox.xref_id and ox.linkage_annotation='eQTL SNP xref';


-- All finished for human


-- Now let's try drosophila


-- orphan delets first

--No orphans apparently but lot's of duplicates. Some with info_text some are NULL
-- suspect some are old and don't link to objects
-- Nope all seem linked and have different display labels.
-- Okay let's resolved these to one xref record
-- This is a little different we don't have a candidate xref record to set to
-- So let's just pick one arbitrarily by grouping?

-- Do it once for those that have candidate GENE xrefs
update object_xref ox, xref x, (select xref_id, dbprimary_acc from xref where info_type='TARGET' and external_db_id=1 and info_text='GENE' group by dbprimary_acc) as t set ox.linkage_annotation='REDfly CRM Target', x.info_type='MISC', x.info_text='GENE', ox.xref_id=t.xref_id, x.description=NULL where x.xref_id=ox.xref_id and x.dbprimary_acc=t.dbprimary_acc and x.description='REDfly CRM xref';


-- Now delete orphan xrefs

mysql> delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
Query OK, 446 rows affected (0.04 sec)

-- Now do for rest

update object_xref ox, xref x, (select xref_id, dbprimary_acc from xref where info_type='TARGET' and external_db_id=1 group by dbprimary_acc) as t set ox.linkage_annotation='REDfly CRM Target', x.info_type='MISC', x.info_text='GENE', ox.xref_id=t.xref_id, x.description=NULL where x.xref_id=ox.xref_id and x.dbprimary_acc=t.dbprimary_acc and x.description='REDfly CRM xref';

Query OK, 207 rows affected (0.04 sec)
Rows matched: 844  Changed: 207  Warnings: 0

mysql> delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
Query OK, 0 rows affected (0.01 sec)
 -- ? Odd I would have expected to get some orphans here


--We still have TARGET xrefs for TFBSs!

--Point to those MISC xrefs which we have already done first

update object_xref ox, xref x, (select xref_id, dbprimary_acc from xref where info_type='MISC') as t set ox.linkage_annotation='REDfly TFBS Target', ox.xref_id=t.xref_id where x.xref_id=ox.xref_id and x.dbprimary_acc=t.dbprimary_acc and x.description='REDfly TFBS xref';
Query OK, 680 rows affected (0.07 sec)
Rows matched: 680  Changed: 680  Warnings: 0


-- delete xref orphans
Query OK, 680 rows affected (0.04 sec)


-- Now deal with those that are left
-- We altered the wrong xref table before which is why we didn't get any orphans so we should have some left
-- Can we even do this in one go
-- No can't update the derived table so do in two gos
update object_xref ox, xref x, (select xref_id, dbprimary_acc, info_type, description, info_text from xref where info_type='TARGET' and external_db_id=1 group by dbprimary_acc) as t set ox.linkage_annotation='REDfly TFBS Target', ox.xref_id=t.xref_id where x.xref_id=ox.xref_id and x.dbprimary_acc=t.dbprimary_acc and x.description='REDfly TFBS xref';

Query OK, 459 rows affected (0.02 sec)
Rows matched: 459  Changed: 459  Warnings: 0


mysql> delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
Query OK, 417 rows affected (0.02 sec)


-- Now update the xrefs which we have just changed the oxs for
update xref x, object_xref ox set x.description=NULL, x.info_type='MISC', x.info_text='GENE' where x.xref_id=ox.xref_id and ox.linkage_annotation='REDfly TFBS Target';
Query OK, 42 rows affected (0.01 sec)
Rows matched: 81  Changed: 42  Warnings: 0

-- No targets left!!!
-- Now let's tackle the coding FeatureType xrefs
-- We still have some gene duplicates so we are going to have to redirect these
update object_xref ox, xref x, (select xref_id, dbprimary_acc from xref where info_type='MISC') as t set ox.linkage_annotation='REDfly Coding', ox.xref_id=t.xref_id where x.xref_id=ox.xref_id and x.dbprimary_acc=t.dbprimary_acc and x.info_type='CODING' and ox.ensembl_object_type='FeatureType';
Query OK, 81 rows affected (0.01 sec)
Rows matched: 81  Changed: 81  Warnings: 0

--
mysql> delete x from xref x left join object_xref ox on x.xref_id=ox.xref_id where ox.xref_id is NULL;
Query OK, 81 rows affected (0.03 sec)


--Now we just have MISC GENE xrefs!!

-- all done



-- Do we need to add schema_version support to the parser edb usage/generation?

