/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import jalview.Sequence;
import java.awt.Color;
import java.awt.Graphics;

public class SequenceFeature {
    int start;
    int end;
    String type;
    String description;
    Color color;
    Sequence sequence;
    public static int CHAIN = 0;
    public static int DOMAIN = 1;
    public static int TRANSMEM = 2;
    public static int SIGNAL = 3;
    public static int HELIX = 4;
    public static int TURN = 5;
    public static int SHEET = 6;
    public static int CARBOHYD = 7;
    public static int ACT_SITE = 8;
    public static int TRANSIT = 9;
    public static int VARIANT = 10;
    public static int BINDING = 11;

    public SequenceFeature(Sequence sequence, String string, int n, int n2, String string2) {
        this.sequence = sequence;
        this.type = string;
        this.start = n;
        this.end = n2;
        this.description = string2;
        this.setColor();
    }

    public void setColor() {
        this.color = this.type.equals("CHAIN") ? Color.white : (this.type.equals("DOMAIN") ? Color.white : (this.type.equals("TRANSMEM") ? Color.red.darker() : (this.type.equals("SIGNAL") ? Color.cyan : (this.type.equals("HELIX") ? Color.magenta : (this.type.equals("TURN") ? Color.cyan : (this.type.equals("SHEET") ? Color.yellow : (this.type.equals("STRAND") ? Color.yellow : (this.type.equals("CARBOHYD") ? Color.pink : (this.type.equals("ACT_SITE") ? Color.red : (this.type.equals("TRANSIT") ? Color.orange : (this.type.equals("VARIANT") ? Color.orange.darker() : (this.type.equals("BINDING") ? Color.blue : (this.type.equals("DISULFID") ? Color.yellow.darker() : (this.type.equals("NP_BIND") ? Color.red : (this.type.indexOf("BIND") > 0 ? Color.red : Color.lightGray)))))))))))))));
    }

    public String print() {
        String string = new Format("%15s").form(this.type);
        string = string + new Format("%6d").form(this.start);
        string = string + new Format("%6d").form(this.end);
        string = string + " " + this.description;
        return string;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
        int n7 = this.start;
        int n8 = this.end;
        long l = System.currentTimeMillis();
        if (n8 >= n || n7 <= n2) {
            if (n7 > n) {
                n3 += (n7 - n) * n5;
                n = n7;
            }
            if (n8 < n2) {
                n2 = n8;
            }
            int n9 = n;
            while (n9 <= n2) {
                String string = this.sequence.sequence.substring(n9, n9 + 1);
                if (!(string.equals(".") || string.equals("-") || string.equals(" "))) {
                    graphics.fillRect(n3 + (n9 - n) * n5, n4, n5, n6);
                } else {
                    graphics.drawString("-", n3 + (n9 - n) * n5, n4 + n6);
                }
                ++n9;
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Time = " + (l2 - l) + "ms");
    }
}

