/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.DrawableAlignment;
import jalview.DrawableSequence;
import jalview.ScoreSequence;
import jalview.SeqPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;

public class SeqCanvas
extends Canvas {
    DrawableAlignment da;
    Image img;
    Graphics gg;
    int imgWidth;
    int imgHeight;
    int fontStyle = 0;
    int fontSize = 10;
    String fontName = "Courier";
    public Font f = new Font(this.fontName, this.fontStyle, this.fontSize);
    int charWidth = 8;
    int charHeight = 8;
    boolean showScores = true;
    boolean wrap = false;
    int chunkheight;
    int chunkwidth;
    int pady = 2;
    int oldstartx;
    int oldstarty;
    int oldendx;
    int oldendy;
    boolean paintFlag = false;
    boolean boxFlag = true;
    boolean textFlag = true;
    boolean colourText = false;
    int startx;
    int starty;
    int endx;
    int endy;
    Color lightBlue = new Color(175, 175, 255);
    Color midBlue = new Color(110, 110, 255);
    String colourFlag = "PID";
    boolean badResidues = false;
    boolean colourSelected = false;
    protected SeqPanel seqPanel;

    public SeqCanvas(SeqPanel seqPanel) {
        this.seqPanel = seqPanel;
        this.da = seqPanel.align;
    }

    public void setFont(Font font) {
        this.f = font;
        if (this.gg != null) {
            FontMetrics fontMetrics = this.gg.getFontMetrics(font);
            if (this.seqPanel.fastDraw) {
                this.f = new Font("Courier", font.getStyle(), font.getSize());
                this.charWidth = fontMetrics.charWidth('W');
                this.charHeight = this.setCharHeight(fontMetrics, this.showScores);
            } else {
                this.charWidth = fontMetrics.charWidth('W') + 2;
                this.charHeight = this.setCharHeight(fontMetrics, this.showScores);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.img == null || this.imgWidth != this.size().width || this.imgHeight != this.size().height || this.paintFlag) {
            this.imgWidth = this.size().width;
            this.imgHeight = this.size().height;
            this.img = this.createImage(this.imgWidth, this.imgHeight);
            this.gg = this.img.getGraphics();
            this.gg.setFont(this.f);
            this.seqPanel.alignPanel.idPanel.idCanvas.f = this.f;
            this.seqPanel.alignPanel.scalePanel.scaleCanvas.f = this.f;
            FontMetrics fontMetrics = this.gg.getFontMetrics(this.f);
            this.charWidth = this.seqPanel.fastDraw ? fontMetrics.charWidth('W') : fontMetrics.charWidth('W') + 2;
            this.charHeight = this.setCharHeight(fontMetrics, this.showScores);
            this.seqPanel.setScrollValues(this.seqPanel.offx, this.seqPanel.offy);
            this.paintFlag = false;
            this.oldstartx = -1;
            this.oldendx = -1;
            this.oldstarty = -1;
            this.oldendy = -1;
        }
        this.chunkwidth = this.size().width / this.charWidth;
        this.chunkheight = (this.seqPanel.align.size() + 2) * this.charHeight;
        this.startx = this.seqPanel.offx;
        this.starty = this.seqPanel.offy;
        this.endx = this.getEndx();
        this.endy = this.getEndy();
        if (this.wrap) {
            this.startx = this.seqPanel.offy / this.chunkwidth * this.chunkwidth;
            this.endx = this.startx + this.chunkwidth;
        }
        if (this.endx > this.seqPanel.align.maxLength) {
            this.startx = this.startx - this.endx + this.seqPanel.align.maxLength;
            this.endx = this.seqPanel.align.maxLength;
        }
        if (this.starty < 0) {
            this.starty = 0;
        }
        if (this.startx < 0) {
            this.startx = 0;
        }
        long l = System.currentTimeMillis();
        if (this.oldendx == -1) {
            this.fillBackground(this.gg, Color.white, 0, 0, this.imgWidth, this.imgHeight);
            if (this.wrap) {
                String string;
                int n;
                Enumeration enumeration;
                int n2;
                int n3 = 0;
                int n4 = this.starty = this.seqPanel.offy % this.chunkheight;
                if (this.starty == 0) {
                    n3 = 2 * this.charHeight;
                } else if (this.starty == 1) {
                    this.starty = 0;
                    n3 = this.charHeight;
                }
                this.endy = this.starty + this.seqPanel.align.size();
                if (this.endy > this.seqPanel.align.size()) {
                    this.endy = this.seqPanel.align.size();
                }
                if (this.endx > this.seqPanel.align.maxLength) {
                    this.endx = this.seqPanel.align.maxLength;
                }
                if (n4 < 2) {
                    n2 = this.startx - this.startx % 10 + 10;
                    enumeration = this.seqPanel.alignPanel.selectedColumns.elements();
                    while (enumeration.hasMoreElements()) {
                        n = (Integer)enumeration.nextElement();
                        if (n < this.startx || n > this.endx) continue;
                        this.gg.setColor(Color.red);
                        this.gg.fillRect((n - this.startx) * this.charWidth, 17 - this.charHeight + n3 - 2 * this.charHeight, this.charWidth, this.charHeight);
                    }
                    this.gg.setColor(Color.black);
                    n = n2;
                    while (n < this.endx) {
                        string = String.valueOf(n);
                        this.gg.drawString(string, (n - this.startx - 1) * this.charWidth, n3 + 15 - this.charHeight * 2);
                        n += 10;
                    }
                }
                this.drawPanel(this.gg, this.startx, this.endx, this.starty, this.endy, n3);
                n3 = n4 == 0 ? (n3 += this.chunkheight) : (n4 == 1 ? (n3 += this.chunkheight) : n3 + this.chunkheight - n4 * this.charHeight);
                this.startx += this.chunkwidth;
                this.endx = this.startx + this.chunkwidth;
                this.starty = 0;
                while (n3 <= this.size().height) {
                    n2 = this.startx - this.startx % 10 + 10;
                    enumeration = this.seqPanel.alignPanel.selectedColumns.elements();
                    while (enumeration.hasMoreElements()) {
                        n = (Integer)enumeration.nextElement();
                        if (n < this.startx || n > this.endx) continue;
                        this.gg.setColor(Color.red);
                        this.gg.fillRect((n - this.startx) * this.charWidth, 17 - this.charHeight + n3 - this.charHeight, this.charWidth, this.charHeight);
                    }
                    this.gg.setColor(Color.black);
                    n = n2;
                    while (n < this.endx) {
                        string = String.valueOf(n);
                        this.gg.drawString(string, (n - this.startx - 1) * this.charWidth, n3 + 15 - this.charHeight * 2);
                        n += 10;
                    }
                    this.drawPanel(this.gg, this.startx, this.endx, 0, this.seqPanel.align.size(), n3);
                    n3 += this.chunkheight;
                    this.startx += this.chunkwidth;
                    this.endx = this.startx + this.chunkwidth;
                    if (this.endy > this.seqPanel.align.size()) {
                        this.endy = this.seqPanel.align.size();
                    }
                    if (this.endx <= this.seqPanel.align.maxLength) continue;
                    this.endx = this.seqPanel.align.maxLength;
                }
            } else {
                this.drawPanel(this.gg, this.startx, this.endx, this.starty, this.endy, 0);
            }
        } else if (this.oldstartx < this.startx) {
            int n = (this.startx - this.oldstartx) * this.charWidth;
            int n5 = (this.oldendx - this.startx) * this.charWidth;
            this.gg.copyArea(n, 0, n5, this.da.getHeight(this.starty, this.endy), -n, 0);
            this.drawPanel(this.gg, this.oldendx, this.endx, this.starty, this.endy, 0);
            this.oldstartx = this.startx;
            this.oldendx = this.endx;
        } else if (this.oldstartx > this.startx) {
            int n = (this.oldstartx - this.startx) * this.charWidth;
            int n6 = (this.endx - this.oldstartx) * this.charWidth;
            this.gg.copyArea(0, 0, n6, this.da.getHeight(this.starty, this.endy), n, 0);
            this.drawPanel(this.gg, this.startx, this.oldstartx, this.starty, this.endy, 0);
            this.oldstartx = this.startx;
            this.oldendx = this.endx;
        } else if (this.oldstarty < this.starty) {
            int n = this.da.getHeight(this.oldstarty, this.starty);
            int n7 = this.da.getHeight(this.starty, this.oldendy);
            this.gg.copyArea(0, n, (this.endx - this.startx) * this.charWidth, n7, 0, -n);
            this.drawPanel(this.gg, this.startx, this.endx, this.oldendy, this.endy, 0);
            this.oldstarty = this.starty;
            this.oldendy = this.endy;
        } else if (this.oldstarty > this.starty) {
            int n = this.da.getHeight(this.endy, this.oldendy);
            int n8 = this.da.getHeight(this.oldstarty, this.endy);
            this.gg.copyArea(0, 0, (this.endx - this.startx) * this.charWidth, n8, 0, n);
            this.drawPanel(this.gg, this.startx, this.endx, this.starty, this.oldstarty, 0);
            this.oldstarty = this.starty;
            this.oldendy = this.endy;
        }
        graphics.drawImage(this.img, 0, 0, this);
    }

    public void drawPanel(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setFont(this.f);
        this.fillBackground(graphics, Color.white, (n - this.startx) * this.charWidth, n5 + this.da.getHeight(this.starty, n3), (n2 - n) * this.charWidth, this.da.getHeight(n3, n4));
        int n6 = n3;
        while (n6 < n4) {
            ((DrawableSequence)this.seqPanel.align.sequences[n6]).drawSequence(graphics, n, n2, (n - this.startx) * this.charWidth, n5 + this.da.getHeight(this.starty, n6), this.charWidth, this.da.ds[n6].charHeight, this.showScores);
            ++n6;
        }
    }

    public boolean keyDown(Event event, int n) {
        return this.seqPanel.alignPanel.idPanel.keyDown(event, n);
    }

    public int getEndy() {
        int n = 0;
        int n2 = this.starty;
        int n3 = this.starty;
        while (n < this.size().height && n2 < this.da.ds.length && this.da.ds[n2] != null) {
            n += this.da.ds[n2].charHeight;
            ++n2;
        }
        int n4 = n2--;
        boolean bl = false;
        if (n < this.size().height) {
            n3 = this.da.size;
            n = this.size().height;
            while (n > 0 && n3 > 0) {
                n -= this.da.ds[n3 - 1].charHeight;
                --n3;
            }
            if (n <= 0) {
                ++n3;
            }
        }
        this.endy = this.starty + this.size().height / this.charHeight;
        if (this.endy >= this.seqPanel.align.size) {
            this.starty = this.starty - this.endy + this.seqPanel.align.size;
            this.endy = this.seqPanel.align.size;
        }
        if (this.starty < 0) {
            this.starty = 0;
        }
        this.starty = n3;
        if (this.starty < 0) {
            this.starty = 0;
        }
        return n2;
    }

    public int getEndx() {
        return this.startx + this.size().width / this.charWidth;
    }

    public int setCharHeight(FontMetrics fontMetrics, boolean bl) {
        int n = fontMetrics.getHeight();
        if (this.seqPanel.align instanceof DrawableAlignment) {
            DrawableAlignment drawableAlignment = this.seqPanel.align;
            int n2 = 0;
            while (n2 < drawableAlignment.ds.length && drawableAlignment.ds[n2] != null) {
                drawableAlignment.ds[n2].charHeight = drawableAlignment.ds[n2] instanceof ScoreSequence ? n * 3 : (bl ? n * 2 : n);
                ++n2;
            }
        }
        if (bl) {
            return fontMetrics.getHeight() * 2;
        }
        return fontMetrics.getHeight();
    }

    public void fillBackground(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension minimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void setFont(int n, int n2) {
        this.fontStyle = n;
        this.fontSize = n2;
        this.f = new Font(this.fontName, this.fontStyle, this.fontSize);
        this.setFont(this.f);
    }

    public int getIndex(int n) {
        int n2 = 0;
        int n3 = this.starty;
        while (n3 <= this.endy) {
            int n4;
            if (n3 < this.da.ds.length && this.da.ds[n3] != null) {
                n4 = n2 + this.da.ds[n3].charHeight;
                if (n >= n2 && n <= n4) {
                    return n3;
                }
            } else {
                return -1;
            }
            n2 = n4;
            ++n3;
        }
        return -1;
    }
}

