/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.CGI;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.PIDColourScheme;
import jalview.PfamFile;
import jalview.Sequence;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;

public class PostalCGI
extends CGI {
    Sequence[] sequence;

    public PostalCGI(String string, int n, String string2, Sequence[] sequenceArray, PrintStream printStream) {
        super(string, n, string2, printStream);
        this.sequence = sequenceArray;
        this.variables = this.makeVariables();
    }

    public Hashtable makeVariables() {
        String string = PfamFile.print(this.sequence);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("sequence", string);
        return hashtable;
    }

    public void readInput(DataInputStream dataInputStream) {
        String string = "";
        boolean bl = false;
        String string2 = "";
        try {
            while ((string = dataInputStream.readLine()) != null) {
                string2 = string2 + string + "\n";
                this.statout.println(string);
            }
            this.statout.print(string2);
            DrawableSequence[] drawableSequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read("POSTAL", string2));
            AlignFrame alignFrame = new AlignFrame((Object)"Null", drawableSequenceArray);
            alignFrame.scores.setState(true);
            alignFrame.ap.seqPanel.seqCanvas.showScores = true;
            alignFrame.ap.idPanel.idCanvas.showScores = true;
            alignFrame.ap.seqPanel.align.percentIdentity();
            alignFrame.cons = alignFrame.ap.seqPanel.align.cons;
            alignFrame.resize(700, 500);
            alignFrame.ap.setSequenceColor(new PIDColourScheme(alignFrame.cons));
            alignFrame.show();
            alignFrame.updateFont();
            alignFrame.updateFont();
        }
        catch (IOException iOException) {
            System.out.println("Exception " + iOException);
        }
    }

    public static void main(String[] stringArray) {
        Sequence[] sequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read(stringArray[0], "File", stringArray[1]));
        PostalCGI postalCGI = new PostalCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runpostal", sequenceArray, System.out);
        postalCGI.run();
    }
}

