/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.DrawableSequence;
import jalview.ResidueColourScheme;
import jalview.ResidueProperties;
import java.awt.Color;
import java.util.Hashtable;

public class PIDColourScheme
extends ResidueColourScheme {
    public Color[] pidColours;
    public float[] thresholds;

    public PIDColourScheme() {
        this(null);
    }

    public PIDColourScheme(Hashtable[] hashtableArray) {
        this.cons = hashtableArray;
        this.pidColours = ResidueProperties.pidColours;
        this.thresholds = ResidueProperties.pidThresholds;
    }

    public void setColours(DrawableSequence drawableSequence, int n) {
        Color color = Color.white;
        String string = drawableSequence.getSequence().substring(n, n + 1);
        if (this.cons != null && n < this.cons.length) {
            color = this.findColour(drawableSequence, string, n);
        }
        drawableSequence.setResidueBoxColour(n, color);
    }

    public Color findColour(DrawableSequence drawableSequence, String string, int n) {
        Color color = Color.white;
        String string2 = (String)this.cons[n].get("max");
        double d = 0.0;
        if (this.cons[n].contains(string)) {
            d = ((Double)this.cons[n].get(string)).floatValue();
            if (!(string.equals("-") || string.equals(".") || string.equals(" "))) {
                int n2 = 0;
                while (n2 < this.thresholds.length) {
                    if (d > (double)this.thresholds[n2]) {
                        color = this.pidColours[n2];
                        break;
                    }
                    ++n2;
                }
            } else {
                color = Color.white;
            }
        }
        return color;
    }
}

