/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.FormatProperties;
import jalview.Mail;
import jalview.OutputGenerator;
import jalview.Popup;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.net.InetAddress;

public class MailTextPopup
extends Popup {
    TextField tf;
    Label tfLabel;
    Mail mail;
    Label format;
    Choice f;
    OutputGenerator og;

    public MailTextPopup(Frame frame, String string, OutputGenerator outputGenerator) {
        super(frame, string);
        this.og = outputGenerator;
        this.tf = new TextField(40);
        this.tf.setText(outputGenerator.getMailProperties().address);
        this.tfLabel = new Label("Mail address : ");
        this.format = new Label("Alignment format");
        this.f = new Choice();
        int n = 0;
        while (n < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(n));
            ++n;
        }
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tfLabel, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 4, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 2, 1, 1);
        this.add(this.format, this.gb, this.gbc, 0, 1, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 1, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.apply && event.id == 1001) {
            String string = this.tf.getText();
            if (string.indexOf(64) == -1) {
                System.out.println("Invalid mail address (enter name@my.email.server )");
                this.hide();
                this.dispose();
            } else {
                System.out.println("Mail address " + string);
                this.og.getMailProperties().address = string;
                this.mail = new Mail();
                String string2 = this.og.getMailProperties().address;
                String string3 = "<michele@ebi.ac.uk>";
                String string4 = "Jalview alignment";
                String string5 = "";
                System.out.println("Mail Server = " + this.og.getMailProperties().server);
                if (this.og.getMailProperties().server != null && !this.og.getMailProperties().server.equals("")) {
                    this.mail.send(this.og.getMailProperties().server, string2, string3, string4, string5);
                    this.sendText();
                    this.mail.finish();
                    InetAddress inetAddress = null;
                    String string6 = "";
                    try {
                        inetAddress = InetAddress.getLocalHost();
                        string6 = inetAddress.getHostName();
                    }
                    catch (Exception exception) {
                        System.err.println(exception.toString());
                    }
                    string4 = "Jalview sent to " + this.og.getMailProperties().address + " (" + string6 + ")";
                    System.out.println("Mail server = " + this.og.getMailProperties().server);
                    this.mail.send(this.og.getMailProperties().server, "michele@ebi.ac.uk", string3, string4, string5);
                }
                this.mail.finish();
                this.hide();
                this.dispose();
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public void sendText() {
        String string = "";
        string = this.og.getText(this.f.getSelectedItem());
        this.mail.send(this.mail.out, string);
    }

    public static void main(String[] stringArray) {
        AlignFrame alignFrame = new AlignFrame(null, "lipase.msf", "File", "MSF");
        alignFrame.resize(700, 300);
        alignFrame.show();
        MailTextPopup mailTextPopup = new MailTextPopup((Frame)alignFrame, "Popup", alignFrame);
    }
}

