/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.BLCFile;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.Sequence;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class JnetFile
extends FileParse {
    int maxLength = 0;
    Vector seqs = new Vector();
    Vector headers = new Vector();
    Vector titles = new Vector();
    Vector conf;
    Vector hscores = new Vector();
    Vector escores = new Vector();
    Vector cscores = new Vector();

    public JnetFile(String string) {
        this.conf = new Vector();
        this.readLines(string);
        this.parse();
    }

    public JnetFile(String string, String string2) throws IOException {
        super(string, string2);
        this.conf = new Vector();
        System.out.print("Reading file....");
        this.readLines();
        System.out.println("done");
        System.out.println("Parsing file....");
        this.parse();
    }

    public void parse() {
        Object object;
        String string = "";
        String string2 = "";
        int n = 0;
        while (n < this.lineArray.size()) {
            object = (String)this.lineArray.elementAt(n);
            if (((String)object).indexOf("START PRED") >= 0) {
                ++n;
                while (n < this.lineArray.size() && ((String)object).indexOf("END PRED") < 0) {
                    object = (String)this.lineArray.elementAt(n);
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                    if (stringTokenizer.countTokens() != 6) {
                        System.out.println("Wrong number of columns " + stringTokenizer.countTokens());
                    } else {
                        string = string + stringTokenizer.nextToken();
                        string2 = string2 + stringTokenizer.nextToken();
                        this.conf.addElement(new Double(stringTokenizer.nextToken()));
                        this.hscores.addElement(new Double(stringTokenizer.nextToken()));
                        this.escores.addElement(new Double(stringTokenizer.nextToken()));
                        this.cscores.addElement(new Double(stringTokenizer.nextToken()));
                    }
                    ++n;
                }
            }
            ++n;
        }
        System.out.println(this.conf.size() + " " + this.hscores.size() + " " + this.escores.size() + " " + this.cscores.size());
        this.seqs.addElement(new Sequence("Query", string, 1, string.length()));
        object = new Sequence("Predicition", string2, 1, string2.length());
        ((Sequence)object).score[0] = this.conf;
        ((Sequence)object).score[1] = this.hscores;
        ((Sequence)object).score[2] = this.escores;
        ((Sequence)object).score[3] = this.cscores;
        this.seqs.addElement(object);
        System.out.println("Sequence is " + ((Sequence)this.seqs.elementAt((int)0)).sequence);
        System.out.println("size = " + this.seqs.size());
    }

    public static String print(Sequence[] sequenceArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("START PRED\n");
        int n = 0;
        while (n < sequenceArray[0].sequence.length()) {
            stringBuffer.append(sequenceArray[0].sequence.substring(n, n + 1) + " ");
            stringBuffer.append(sequenceArray[1].sequence.substring(n, n + 1) + " ");
            stringBuffer.append(sequenceArray[1].score[0].elementAt(n) + " ");
            stringBuffer.append(sequenceArray[1].score[1].elementAt(n) + " ");
            stringBuffer.append(sequenceArray[1].score[2].elementAt(n) + " ");
            stringBuffer.append(sequenceArray[1].score[3].elementAt(n) + " ");
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("END PRED\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            BLCFile bLCFile = new BLCFile(stringArray[0], "File");
            Sequence[] sequenceArray = new DrawableSequence[bLCFile.seqs.size()];
            int n = 0;
            while (n < bLCFile.seqs.size()) {
                sequenceArray[n] = new DrawableSequence((Sequence)bLCFile.seqs.elementAt(n));
                ++n;
            }
            String string = BLCFile.print(sequenceArray);
            AlignFrame alignFrame = new AlignFrame(null, (DrawableSequence[])sequenceArray);
            alignFrame.resize(700, 500);
            alignFrame.show();
            System.out.println(string);
        }
        catch (IOException iOException) {
            System.out.println("Exception " + iOException);
        }
    }
}

