/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.PIDColourScheme;
import jalview.QuickSort;
import jalview.ResidueProperties;
import jalview.Sequence;
import jalview.SequenceGroup;
import java.util.Hashtable;
import java.util.Vector;

public class Alignment {
    public Sequence[] sequences;
    public int[][] scores;
    public int maxLength;
    public int size;
    public Vector groups = new Vector();
    public Hashtable[] cons;
    public int[][] cons2;
    String gapCharacter = "-";
    public Vector quality;

    public Alignment(Sequence[] sequenceArray) {
        this.sequences = sequenceArray;
        this.maxLength = this.maxLength();
        this.size = this.size();
        this.groups.addElement(new SequenceGroup());
        ((SequenceGroup)this.groups.elementAt((int)0)).colourScheme = new PIDColourScheme();
        int n = 0;
        while (n < sequenceArray.length && sequenceArray[n] != null) {
            this.addToGroup((SequenceGroup)this.groups.elementAt(0), sequenceArray[n]);
            ++n;
        }
    }

    public void addSequence(Sequence sequence) {
        Sequence[] sequenceArray = new Sequence[this.sequences.length + 1];
        int n = 0;
        while (n < this.sequences.length && this.sequences[n] != null) {
            sequenceArray[n] = this.sequences[n];
            ++n;
        }
        sequenceArray[n] = sequence;
        this.size = this.size();
        this.maxLength = this.maxLength();
    }

    public int maxNameLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            if (this.sequences[n2].name.length() > n) {
                n = this.sequences[n2].name.length();
            }
            ++n2;
        }
        return n;
    }

    public void sortGroups() {
        float[] fArray = new float[this.groups.size()];
        Object[] objectArray = new Object[this.groups.size()];
        int n = 0;
        while (n < this.groups.size()) {
            fArray[n] = ((SequenceGroup)this.groups.elementAt((int)n)).sequences.size();
            objectArray[n] = this.groups.elementAt(n);
            ++n;
        }
        QuickSort.sort(fArray, objectArray);
        Vector<Object> vector = new Vector<Object>(this.groups.size());
        int n2 = this.groups.size() - 1;
        while (n2 >= 0) {
            vector.addElement(objectArray[n2]);
            --n2;
        }
        this.groups = vector;
    }

    public void removeGaps() {
        int n = 0;
        while (n < this.maxLength()) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < this.size()) {
                if (!(this.sequences[n2].sequence.length() <= n || this.sequences[n2].sequence.substring(n, n + 1).equals("-") || this.sequences[n2].sequence.substring(n, n + 1).equals(".") || this.sequences[n2].sequence.substring(n, n + 1).equals(" "))) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                System.out.println("Deleting column " + n);
                this.deleteColumns(n + 1, n + 1);
            }
            ++n;
        }
    }

    public Sequence[] getColumns(int n, int n2) {
        return this.getColumns(0, this.size() - 1, n, n2);
    }

    public void deleteColumns(int n, int n2) {
        if (n2 > this.quality.size()) {
            n2 = this.quality.size();
        }
        int n3 = n;
        while (n3 <= n2) {
            this.quality.removeElementAt(n);
            ++n3;
        }
        this.deleteColumns(0, this.size() - 1, n, n2);
    }

    public Hashtable[] removeArrayElement(Hashtable[] hashtableArray, int n) {
        if (hashtableArray != null && hashtableArray.length > n) {
            Hashtable[] hashtableArray2 = new Hashtable[hashtableArray.length - 1];
            int n2 = 0;
            while (n2 < n) {
                hashtableArray2[n2] = hashtableArray[n2];
                ++n2;
            }
            int n3 = n + 1;
            while (n3 < hashtableArray2.length) {
                hashtableArray2[n3] = hashtableArray[n3 + 1];
                ++n3;
            }
            return hashtableArray2;
        }
        return null;
    }

    public void removeIntArrayColumn(int[][] nArray, int n) {
        int n2 = this.maxLength();
        int n3 = nArray.length;
        System.out.println("cons2 length " + n3 + " " + n2);
        int n4 = n;
        while (n4 < n3 - 1) {
            nArray[n4] = nArray[n4 + 1];
            ++n4;
        }
    }

    public void deleteColumns(int n, int n2, int n3, int n4) {
        System.out.println("Deleting cols : " + n3 + " " + n4);
        int n5 = 0;
        while (n5 <= n4 - n3) {
            System.out.println("Removing cons for element " + (n3 + n5));
            this.cons = this.removeArrayElement(this.cons, n3);
            this.removeIntArrayColumn(this.cons2, n3);
            int n6 = n;
            while (n6 <= n2) {
                this.sequences[n6].deleteCharAt(n3);
                ++n6;
            }
            ++n5;
        }
        this.maxLength = this.maxLength();
    }

    public void insertColumns(Sequence[] sequenceArray, int n) {
        if (sequenceArray.length == this.size()) {
            int n2 = 0;
            while (n2 < this.size()) {
                String string = new String(this.sequences[n2].getSequence());
                this.sequences[n2].sequence = string.substring(0, n) + sequenceArray[n2].getSequence() + string.substring(n);
                ++n2;
            }
        }
        this.maxLength = this.maxLength();
    }

    public Sequence[] getColumns(int n, int n2, int n3, int n4) {
        Sequence[] sequenceArray = new Sequence[n2 - n + 1];
        int n5 = n;
        while (n5 <= n2) {
            sequenceArray[n5] = new Sequence(this.sequences[n5].name, this.sequences[n5].getSequence().substring(n3, n4), this.sequences[n5].findPosition(n3), this.sequences[n5].findPosition(n4));
            ++n5;
        }
        return sequenceArray;
    }

    public void trimLeft(int n) {
        int n2;
        int n3 = 0;
        while (n3 < this.size) {
            Sequence sequence = this.sequences[n3];
            sequence.start = n2 = sequence.findPosition(n);
            sequence.sequence = sequence.sequence.substring(n);
            sequence.num = Sequence.setNums(sequence.sequence);
            ++n3;
        }
        if (this.cons != null) {
            int n4 = this.cons.length;
            n2 = 0;
            while (n2 < n4 - n) {
                this.cons[n2] = this.cons[n + n2];
                ++n2;
            }
        }
        if (this.cons2 != null) {
            int n5 = this.maxLength();
            n2 = 0;
            while (n2 < n5 - n) {
                this.cons2[n2] = this.cons2[n + n2];
                ++n2;
            }
        }
        this.maxLength = this.maxLength();
        this.size = this.size();
    }

    public void trimRight(int n) {
        int n2 = 0;
        while (n2 < this.size) {
            int n3;
            Sequence sequence = this.sequences[n2];
            sequence.end = n3 = sequence.findPosition(n);
            sequence.sequence = sequence.sequence.substring(0, n + 1);
            ++n2;
        }
        if (this.cons != null) {
            int n4 = this.cons.length;
            Hashtable[] hashtableArray = new Hashtable[n + 1];
            int n5 = 0;
            while (n5 <= n) {
                hashtableArray[n5] = this.cons[n];
                ++n5;
            }
        }
        this.maxLength = this.maxLength();
        this.size = this.size();
    }

    public void deleteSequence(Sequence sequence) {
        int n = 0;
        while (n < this.size) {
            if (this.sequences[n] == sequence) {
                this.deleteSequence(n);
            }
            ++n;
        }
    }

    public void deleteSequence(int n) {
        Sequence[] sequenceArray = new Sequence[this.size - 1];
        int n2 = 0;
        while (n2 < n) {
            sequenceArray[n2] = this.sequences[n2];
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < this.size) {
            sequenceArray[n3 - 1] = this.sequences[n3];
            ++n3;
        }
        this.sequences = sequenceArray;
        this.size = this.size();
    }

    public Vector removeRedundancy(float f, Vector vector) {
        int n;
        Vector vector2 = new Vector();
        int n2 = 1;
        while (n2 < vector.size()) {
            n = 0;
            while (n < n2) {
                float f2;
                if (!(vector2.contains((Sequence)vector.elementAt(n2)) && vector2.contains((Sequence)vector.elementAt(n)) || !((f2 = Alignment.compare((Sequence)vector.elementAt(n), (Sequence)vector.elementAt(n2))) >= f))) {
                    if (((Sequence)vector.elementAt(n)).getSequence().length() > ((Sequence)vector.elementAt(n2)).getSequence().length()) {
                        vector2.addElement(vector.elementAt(n2));
                        System.out.println("Deleting sequence " + ((Sequence)vector.elementAt(n2)).getName());
                    } else {
                        vector2.addElement(vector.elementAt(n2));
                        System.out.println("Deleting sequence " + ((Sequence)vector.elementAt(n2)).getName());
                    }
                }
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < vector2.size()) {
            System.out.println("Deleting sequence " + ((Sequence)vector2.elementAt(n)).getName());
            this.deleteSequence((Sequence)vector2.elementAt(n));
            ++n;
        }
        return vector2;
    }

    public static float compare(Sequence sequence, Sequence sequence2) {
        String string = sequence.getSequence();
        String string2 = sequence2.getSequence();
        int n = string.length();
        int n2 = string2.length();
        if (string.substring(n).equals("-") || string.substring(n).equals(".") || string.substring(n).equals(" ")) {
            --n;
            while (string.substring(n, n + 1).equals("-") || string.substring(n, n + 1).equals(".") || string.substring(n, n + 1).equals(" ")) {
                --n;
            }
        }
        if (string2.substring(n2).equals("-") || string2.substring(n2).equals(".") || string2.substring(n2).equals(" ")) {
            --n2;
            while (string2.substring(n2, n2 + 1).equals("-") || string2.substring(n2, n2 + 1).equals(".") || string2.substring(n2, n2 + 1).equals(" ")) {
                --n2;
            }
        }
        int n3 = 0;
        int n4 = 0;
        float f = -1.0f;
        if (n > n2) {
            int n5 = 0;
            while (n5 < n2) {
                if (string.substring(n5, n5 + 1).equals(string2.substring(n5, n5 + 1))) {
                    ++n4;
                }
                ++n3;
                ++n5;
            }
            f = (float)n4 / (float)n * 100.0f;
        } else {
            int n6 = 0;
            while (n6 < n2) {
                if (string.substring(n6, n6 + 1).equals(string2.substring(n6, n6 + 1))) {
                    ++n4;
                }
                ++n3;
                ++n6;
            }
            f = (float)n4 / (float)n2 * 100.0f;
        }
        return f;
    }

    public static float PID(Sequence sequence, Sequence sequence2) {
        boolean bl = false;
        int n = sequence.getSequence().length() > sequence2.getSequence().length() ? sequence.getSequence().length() : sequence2.getSequence().length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = "";
            String string2 = "";
            string = n3 < sequence.getSequence().length() ? sequence.getSequence().substring(n3, n3 + 1) : ".";
            string2 = n3 < sequence2.getSequence().length() ? sequence2.getSequence().substring(n3, n3 + 1) : ".";
            if (!(string.equals(".") || string.equals("-") || string.equals(" ") || string2.equals(".") || string2.equals("-") || string2.equals(" ") || string.equals(string2))) {
                ++n2;
            }
            ++n3;
        }
        return 100.0f * (float)(n - n2) / (float)n;
    }

    public void sortByPID(Sequence sequence) {
        float[] fArray = new float[this.size()];
        int n = 0;
        while (n < this.size()) {
            fArray[n] = Alignment.compare(this.sequences[n], sequence);
            ++n;
        }
        QuickSort.sort(fArray, 0, fArray.length - 1, this.sequences);
        int n2 = 0;
        n2 = this.size() % 2 == 0 ? this.size() / 2 : (this.size() + 1) / 2;
        int n3 = 0;
        while (n3 < n2) {
            Sequence sequence2 = this.sequences[n3];
            this.sequences[n3] = this.sequences[this.size() - n3 - 1];
            this.sequences[this.size() - n3 - 1] = sequence2;
            ++n3;
        }
    }

    public void sortByID() {
        String[] stringArray = new String[this.size()];
        int n = 0;
        while (n < this.size()) {
            stringArray[n] = this.sequences[n].name;
            ++n;
        }
        QuickSort.sort(stringArray, (Object[])this.sequences);
        int n2 = 0;
        n2 = this.size() % 2 == 0 ? this.size() / 2 : (this.size() + 1) / 2;
        int n3 = 0;
        while (n3 < n2) {
            Sequence sequence = this.sequences[n3];
            this.sequences[n3] = this.sequences[this.size() - n3 - 1];
            this.sequences[this.size() - n3 - 1] = sequence;
            ++n3;
        }
    }

    public SequenceGroup findGroup(int n) {
        return this.findGroup(this.sequences[n]);
    }

    public SequenceGroup findGroup(Sequence sequence) {
        int n = 0;
        while (n < this.groups.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)this.groups.elementAt(n);
            if (sequenceGroup.sequences.contains(sequence)) {
                return sequenceGroup;
            }
            ++n;
        }
        return null;
    }

    public void addToGroup(SequenceGroup sequenceGroup, Sequence sequence) {
        if (!sequenceGroup.sequences.contains(sequence)) {
            sequenceGroup.sequences.addElement(sequence);
        }
    }

    public void removeFromGroup(SequenceGroup sequenceGroup, Sequence sequence) {
        if (sequenceGroup != null && sequenceGroup.sequences != null && sequenceGroup.sequences.contains(sequence)) {
            sequenceGroup.sequences.removeElement(sequence);
            if (sequenceGroup.sequences.size() == 0) {
                this.groups.removeElement(sequenceGroup);
            }
        }
    }

    public void addGroup(SequenceGroup sequenceGroup) {
        this.groups.addElement(sequenceGroup);
    }

    public SequenceGroup addGroup() {
        SequenceGroup sequenceGroup = new SequenceGroup();
        this.groups.addElement(sequenceGroup);
        return sequenceGroup;
    }

    public void deleteGroup(SequenceGroup sequenceGroup) {
        if (this.groups.contains(sequenceGroup)) {
            this.groups.removeElement(sequenceGroup);
        }
    }

    public Sequence findName(String string) {
        int n = 0;
        while (n < this.sequences.length && this.sequences[n] != null) {
            Sequence sequence = this.sequences[n];
            if (sequence.name.equals(string)) {
                return sequence;
            }
            ++n;
        }
        return null;
    }

    public int findIndex(Sequence sequence) {
        int n = 0;
        while (n < this.sequences.length && this.sequences[n] != null) {
            if (sequence == this.sequences[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int size() {
        int n = 0;
        while (n < this.sequences.length && this.sequences[n] != null) {
            ++n;
        }
        return n;
    }

    public int maxLength() {
        this.maxLength = -1;
        int n = 0;
        while (n < this.sequences.length) {
            if (this.sequences[n] != null && this.sequences[n].length() > this.maxLength) {
                this.maxLength = this.sequences[n].sequence.length();
            }
            ++n;
        }
        this.maxLength = this.maxLength;
        int n2 = 0;
        while (n2 < this.sequences.length) {
            if (this.sequences[n2] != null) {
                int n3 = this.sequences[n2].sequence.length();
                while (n3 < this.maxLength) {
                    this.sequences[n2].insertCharAt(n3, this.gapCharacter.charAt(0));
                    ++n3;
                }
            }
            ++n2;
        }
        return this.maxLength;
    }

    public int maxIdLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.sequences.length && this.sequences[n2] != null) {
            String string = this.sequences[n2].getName() + "/" + this.sequences[n2].start + "-" + this.sequences[n2].end;
            if (string.length() > n) {
                n = string.length();
            }
            ++n2;
        }
        return n;
    }

    public void percentIdentity(Vector vector) {
        this.cons = new Hashtable[this.maxLength()];
        this.cons2 = new int[this.maxLength()][24];
        System.err.println("Maxlength " + this.maxLength());
        System.err.println(System.currentTimeMillis());
        this.percentIdentity(0, this.maxLength, vector);
        System.err.println(System.currentTimeMillis());
        this.percentIdentity2(0, this.maxLength, vector);
        System.err.println(System.currentTimeMillis());
    }

    public void percentIdentity2(int n, int n2, Vector vector) {
        int n3;
        int n4;
        int n5 = 0;
        while (n5 < 24) {
            n4 = n;
            while (n4 < n2) {
                this.cons2[n4][n5] = 0;
                ++n4;
            }
            ++n5;
        }
        n4 = n;
        while (n4 < n2) {
            n3 = 0;
            while (n3 < this.sequences.length && this.sequences[n3] != null) {
                if (vector.contains(this.sequences[n3])) {
                    int[] nArray = this.cons2[n4];
                    int n6 = this.sequences[n3].num[n4];
                    nArray[n6] = nArray[n6] + 1;
                }
                ++n3;
            }
            ++n4;
        }
        n3 = n;
        while (n3 < n2) {
            int n7 = -1000;
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            while (n10 < 24) {
                if (this.cons2[n3][n10] > n7) {
                    n7 = this.cons2[n3][n10];
                    n8 = n3;
                    n9 = n10;
                }
                ++n10;
            }
            ++n3;
        }
    }

    public void percentIdentity2() {
        this.percentIdentity2(0, this.maxLength() - 1);
    }

    public void percentIdentity2(int n, int n2) {
        int n3;
        int n4;
        this.cons2 = new int[this.maxLength()][24];
        int n5 = 0;
        while (n5 < 24) {
            n4 = 0;
            while (n4 < this.maxLength()) {
                this.cons2[n4][n5] = 0;
                ++n4;
            }
            ++n5;
        }
        n4 = n;
        while (n4 <= n2) {
            n3 = 0;
            while (n3 < this.sequences.length && this.sequences[n3] != null) {
                int[] nArray = this.cons2[n4];
                int n6 = this.sequences[n3].num[n4];
                nArray[n6] = nArray[n6] + 1;
                ++n3;
            }
            ++n4;
        }
        n3 = n;
        while (n3 <= n2) {
            int n7 = -1000;
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            while (n10 < 24) {
                if (this.cons2[n3][n10] > n7) {
                    n7 = this.cons2[n3][n10];
                    n8 = n3;
                    n9 = n10;
                }
                ++n10;
            }
            ++n3;
        }
    }

    public void percentIdentity(int n, int n2, Vector vector) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = 0;
            if (n3 < this.cons.length) {
                String string;
                Object object;
                this.cons[n3] = new Hashtable();
                int n5 = 0;
                while (n5 < this.sequences.length && this.sequences[n5] != null) {
                    if (vector.contains(this.sequences[n5])) {
                        object = this.sequences[n5].getSequence();
                        string = "";
                        ++n4;
                        if (((String)object).length() > n3 + 1) {
                            string = ((String)object).substring(n3, n3 + 1);
                        } else if (((String)object).length() == n3 + 1) {
                            string = ((String)object).substring(n3);
                        }
                        if (this.cons[n3].get(string) != null) {
                            int n6 = (Integer)this.cons[n3].get(string) + 1;
                            this.cons[n3].put(string, new Integer(n6));
                        } else {
                            this.cons[n3].put(string, new Integer(1));
                        }
                    }
                    ++n5;
                }
                object = this.cons[n3].keys();
                string = "";
                double d = 0.0;
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    double d2 = ((Integer)this.cons[n3].get(string2)).floatValue();
                    if (d2 > d) {
                        d = d2;
                        string = string2;
                    }
                    double d3 = d2 * 100.0 / (double)n4;
                    this.cons[n3].put(string2, new Double(d3));
                }
                this.cons[n3].put("max", string);
            }
            ++n3;
        }
    }

    public void percentIdentity() {
        this.percentIdentity2();
        this.findQuality();
        this.cons = new Hashtable[this.maxLength()];
        int n = 0;
        while (n < this.maxLength) {
            String string;
            Object object;
            int n2 = 0;
            this.cons[n] = new Hashtable();
            int n3 = 0;
            while (n3 < this.sequences.length && this.sequences[n3] != null) {
                object = this.sequences[n3].getSequence();
                string = "";
                ++n2;
                if (((String)object).length() > n + 1) {
                    string = ((String)object).substring(n, n + 1);
                } else if (((String)object).length() == n + 1) {
                    string = ((String)object).substring(n);
                }
                if (this.cons[n].get(string) != null) {
                    int n4 = (Integer)this.cons[n].get(string) + 1;
                    this.cons[n].put(string, new Integer(n4));
                } else {
                    this.cons[n].put(string, new Integer(1));
                }
                ++n3;
            }
            object = this.cons[n].keys();
            string = "";
            double d = 0.0;
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                double d2 = ((Integer)this.cons[n].get(string2)).floatValue();
                if (d2 > d) {
                    d = d2;
                    string = string2;
                }
                double d3 = d2 * 100.0 / (double)n2;
                this.cons[n].put(string2, new Double(d3));
            }
            this.cons[n].put("max", string);
            ++n;
        }
    }

    public void findQuality() {
        this.findQuality(0, this.maxLength - 1);
    }

    public void findQuality(int n, int n2) {
        this.quality = new Vector();
        double d = -10000.0;
        String string = "";
        this.size = this.size();
        int n3 = n;
        while (n3 <= n2) {
            double d2 = 0.0;
            double[] dArray = new double[24];
            int n4 = 0;
            while (n4 < 24) {
                dArray[n4] = 0.0;
                try {
                    int n5 = 0;
                    while (n5 < 24) {
                        int n6 = n4;
                        dArray[n6] = dArray[n6] + ((double)this.cons2[n3][n5] * (double)ResidueProperties.BLOSUM62[n4][n5] + 4.0);
                        ++n5;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Exception : " + exception);
                }
                int n7 = n4++;
                dArray[n7] = dArray[n7] / (double)this.size;
            }
            int n8 = 0;
            while (n8 < this.size) {
                double d3 = 0.0;
                double[] dArray2 = new double[24];
                int n9 = 0;
                while (n9 < 23) {
                    double d4 = 0.0;
                    try {
                        d4 = (double)ResidueProperties.BLOSUM62[n9][this.sequences[n8].num[n3]] + 4.0;
                    }
                    catch (Exception exception) {
                        System.out.println("Exception in sr " + exception);
                    }
                    dArray2[n9] = dArray[n9] - d4;
                    d3 += dArray2[n9] * dArray2[n9];
                    ++n9;
                }
                d2 += Math.sqrt(d3);
                ++n8;
            }
            if (d < d2) {
                d = d2;
            }
            this.quality.addElement(new Double(d2));
            string = string + "-";
            ++n3;
        }
        int n10 = n;
        while (n10 <= n2) {
            double d5 = (Double)this.quality.elementAt(n10);
            d5 = (d - d5) * (double)(this.size - this.cons2[n10][23]) / (double)this.size;
            this.quality.setElementAt(new Double(d5), n10);
            ++n10;
        }
    }
}

