/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.Bond;
import MCview.Residue;
import MCview.myAtom;
import jalview.DrawableSequence;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.awt.Color;
import java.util.Vector;

public class PDBChain {
    public String id;
    public Vector bonds = new Vector();
    public Vector atoms = new Vector();
    public Vector residues = new Vector();
    public int offset;
    public Sequence sequence;
    public boolean isVisible = false;
    public DrawableSequence ds;

    public PDBChain(String string) {
        this.id = string;
    }

    public String print() {
        String string = "";
        int n = 0;
        while (n < this.bonds.size()) {
            string = string + ((Bond)this.bonds.elementAt((int)n)).at1.resName + " " + ((Bond)this.bonds.elementAt((int)n)).at1.resNumber + " " + this.offset + "\n";
            ++n;
        }
        return string;
    }

    public void makeCaBondList() {
        int n = 0;
        while (n < this.residues.size() - 1) {
            Residue residue = (Residue)this.residues.elementAt(n);
            Residue residue2 = (Residue)this.residues.elementAt(n + 1);
            myAtom myAtom2 = residue.findAtom("CA");
            myAtom myAtom3 = residue2.findAtom("CA");
            if (myAtom2 != null && myAtom3 != null && myAtom2.chain.equals(myAtom3.chain)) {
                this.makeBond(myAtom2, myAtom3);
            }
            ++n;
        }
    }

    public void makeBond(myAtom myAtom2, myAtom myAtom3) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        fArray[0] = myAtom2.x;
        fArray[1] = myAtom2.y;
        fArray[2] = myAtom2.z;
        fArray2[0] = myAtom3.x;
        fArray2[1] = myAtom3.y;
        fArray2[2] = myAtom3.z;
        this.bonds.addElement(new Bond(fArray, fArray2, myAtom2, myAtom3));
    }

    public void makeResidueList() {
        int n = 0;
        String string = "";
        int n2 = 0;
        while (n2 < this.atoms.size()) {
            int n3;
            myAtom myAtom2 = (myAtom)this.atoms.elementAt(n2);
            String string2 = myAtom2.resName;
            int n4 = n3 = myAtom2.resNumber;
            if (n2 == 0) {
                this.offset = n3;
            }
            Vector<myAtom> vector = new Vector<myAtom>();
            vector.addElement((myAtom)this.atoms.elementAt(n2));
            n3 = ((myAtom)this.atoms.elementAt((int)(++n2))).resNumber;
            while (n3 == n4 && n2 < this.atoms.size()) {
                vector.addElement((myAtom)this.atoms.elementAt(n2));
                if (++n2 < this.atoms.size()) {
                    n3 = ((myAtom)this.atoms.elementAt((int)n2)).resNumber;
                    continue;
                }
                ++n3;
            }
            --n2;
            this.residues.addElement(new Residue(vector, n3 - 1, n));
            ++n;
            Residue residue = (Residue)this.residues.lastElement();
            myAtom myAtom3 = (myAtom)residue.atoms.elementAt(0);
            String string3 = ResidueProperties.aa[(Integer)ResidueProperties.aa3Hash.get(myAtom3.resName)];
            string = string + string3;
            ++n2;
        }
        this.sequence = new Sequence("PDB_seq", string, 1, string.length());
        System.out.println("Sequence = " + string);
        System.out.println("No of residues = " + this.residues.size());
    }

    public void setChargeColours() {
        int n = 0;
        while (n < this.bonds.size()) {
            try {
                int n2;
                Bond bond = (Bond)this.bonds.elementAt(n);
                if (bond.at1.resName.toUpperCase().equals("ASP") || bond.at1.resName.toUpperCase().equals("GLU")) {
                    bond.startCol = Color.red;
                } else if (bond.at1.resName.toUpperCase().equals("LYS") || bond.at1.resName.toUpperCase().equals("ARG")) {
                    bond.startCol = Color.blue;
                } else if (bond.at1.resName.toUpperCase().equals("CYS")) {
                    bond.startCol = Color.yellow;
                } else {
                    n2 = (Integer)ResidueProperties.aa3Hash.get(bond.at1.resName.toUpperCase());
                    bond.startCol = Color.lightGray;
                }
                if (bond.at2.resName.toUpperCase().equals("ASP") || bond.at2.resName.toUpperCase().equals("GLU")) {
                    bond.endCol = Color.red;
                } else if (bond.at2.resName.toUpperCase().equals("LYS") || bond.at2.resName.toUpperCase().equals("ARG")) {
                    bond.endCol = Color.blue;
                } else if (bond.at2.resName.toUpperCase().equals("CYS")) {
                    bond.endCol = Color.yellow;
                } else {
                    n2 = (Integer)ResidueProperties.aa3Hash.get(bond.at2.resName.toUpperCase());
                    bond.endCol = Color.lightGray;
                }
            }
            catch (Exception exception) {
                Bond bond = (Bond)this.bonds.elementAt(n);
                bond.startCol = Color.gray;
                bond.endCol = Color.gray;
            }
            ++n;
        }
    }

    public void setHydrophobicityColours() {
        int n = 0;
        while (n < this.bonds.size()) {
            try {
                Bond bond = (Bond)this.bonds.elementAt(n);
                int n2 = (Integer)ResidueProperties.aa3Hash.get(bond.at1.resName.toUpperCase());
                float f = ((float)ResidueProperties.hyd[n2] - -3.9f) / 8.4f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                if (f < 0.0f) {
                    f = 0.0f;
                }
                bond.startCol = new Color(f, 0.0f, 1.0f - f);
                n2 = (Integer)ResidueProperties.aa3Hash.get(bond.at2.resName.toUpperCase());
                f = ((float)ResidueProperties.hyd[n2] - -3.9f) / 8.4f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                if (f < 0.0f) {
                    f = 0.0f;
                }
                bond.endCol = new Color(f, 0.2f, 1.0f - f);
            }
            catch (Exception exception) {
                Bond bond = (Bond)this.bonds.elementAt(n);
                bond.startCol = Color.gray;
                bond.endCol = Color.gray;
            }
            ++n;
        }
    }

    public void colourBySequence() {
        this.colourBySequence(this.ds);
    }

    public void colourBySequence(DrawableSequence drawableSequence) {
        int n = 0;
        while (n < this.bonds.size()) {
            Bond bond = (Bond)this.bonds.elementAt(n);
            try {
                int n2;
                int n3;
                if (bond.at1.resNumber >= this.offset + drawableSequence.pdbstart - 1 && bond.at1.resNumber <= this.offset + drawableSequence.pdbend - 1) {
                    n3 = drawableSequence.seqstart + (bond.at1.resNumber - drawableSequence.pdbstart - this.offset);
                    n2 = drawableSequence.findIndex(n3);
                    bond.startCol = (Color)drawableSequence.boxColour.elementAt(n2);
                } else {
                    bond.startCol = Color.gray;
                }
                if (bond.at2.resNumber >= this.offset + drawableSequence.pdbstart - 1 && bond.at2.resNumber <= drawableSequence.pdbend + this.offset - 1) {
                    n3 = drawableSequence.seqstart + (bond.at2.resNumber - drawableSequence.pdbstart - this.offset);
                    n2 = drawableSequence.findIndex(n3);
                    bond.endCol = (Color)drawableSequence.boxColour.elementAt(n2);
                } else {
                    bond.endCol = Color.gray;
                }
            }
            catch (Exception exception) {
                bond.startCol = Color.lightGray;
                bond.endCol = Color.lightGray;
            }
            ++n;
        }
    }

    public void setChainColours() {
        int n = 0;
        while (n < this.bonds.size()) {
            Bond bond = (Bond)this.bonds.elementAt(n);
            try {
                bond.startCol = (Color)ResidueProperties.chainColours.get(this.id);
                bond.endCol = (Color)ResidueProperties.chainColours.get(this.id);
            }
            catch (Exception exception) {
                bond.startCol = Color.lightGray;
                bond.endCol = Color.lightGray;
            }
            ++n;
        }
    }
}

