/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.main.CommandLine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.JOptionPane;

public class IOUtil {
    private static String rootdir;

    public static String getRootDir() {
        if (rootdir == null) {
            String tmp;
            File handle;
            rootdir = System.getProperty("APOLLO_ROOT");
            if (rootdir == null && !(handle = new File(tmp = (rootdir = ".") + "/conf")).exists()) {
                String home = System.getProperty("user.home");
                if (home == null) {
                    home = "/tmp";
                }
                rootdir = home + "/apollo-webstart";
            }
            System.out.println("APOLLO_ROOT: " + rootdir);
        }
        return rootdir;
    }

    public static String readFile(String fileName) throws IOException {
        String text = "";
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String line = "";
        while ((line = in.readLine()) != null) {
            text = text + line + "\n";
        }
        in.close();
        return text;
    }

    public static void writeFile(String fileName, String text) throws IOException {
        PrintWriter outStream = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
        outStream.write(text, 0, text.length());
        outStream.close();
    }

    public static boolean copyFile(String from, String to) {
        String text;
        try {
            text = IOUtil.readFile(from);
        }
        catch (Exception ex) {
            System.err.println("Caught exception opening " + from + " for reading");
            return false;
        }
        try {
            IOUtil.writeFile(to, text);
        }
        catch (Exception ex) {
            System.err.println("Caught exception writing to " + to);
            return false;
        }
        return true;
    }

    public static String stripControlChars(String s) {
        StringBuffer stripped = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isISOControl(c)) continue;
            stripped.append(c);
        }
        return new String(stripped);
    }

    public static String findFile(String name) {
        return IOUtil.findFile(name, false);
    }

    public static String findFile(String name, boolean canCreate) {
        String homeDotApolloDir;
        String path;
        File handle;
        if (name == null) {
            return null;
        }
        boolean DEBUG = Config.getDebug();
        if ((name = name.trim()) == null || name.equals("")) {
            return null;
        }
        if (DEBUG) {
            System.out.println("\nfindFile(name = " + name + ", canCreate = " + canCreate + ")");
        }
        if ((handle = new File(name = IOUtil.expandSquiggle(name))).exists()) {
            if (DEBUG) {
                System.out.println("findFile: orig name is ok: " + name);
            }
            return name;
        }
        if (handle.isAbsolute() && !canCreate) {
            if (DEBUG) {
                System.out.println("findFile: handle is absolute, can't find file, not allowed to create: " + name);
            }
            return null;
        }
        if (canCreate) {
            File dir;
            String dirstring = "";
            if (name.lastIndexOf("/") < 0 && name.lastIndexOf("\\") < 0) {
                if (handle.isAbsolute()) {
                    System.out.println("No directory separator in absolute file name " + name);
                    return null;
                }
            } else if (name.lastIndexOf("/") >= 0) {
                dirstring = name.substring(0, name.lastIndexOf("/"));
            } else if (name.lastIndexOf("\\") >= 0) {
                dirstring = name.substring(0, name.lastIndexOf("\\"));
            }
            if (dirstring.equals("")) {
                dirstring = ".";
                name = dirstring + "/" + name;
            }
            if ((dir = new File(dirstring)).canRead() && dir.canWrite()) {
                if (DEBUG) {
                    System.out.println("findFile: can write to dir " + dirstring + "--returning " + name);
                }
                return name;
            }
            if (handle.isAbsolute()) {
                System.out.println("findFile: can't write to directory " + dir);
                return null;
            }
            if (DEBUG) {
                System.out.println("findFile: can't write to dir " + dirstring);
            }
        }
        if ((handle = new File(path = (homeDotApolloDir = System.getProperty("user.home") + "/.apollo/") + name)).exists()) {
            if (DEBUG) {
                System.out.println("Found " + name + " in " + homeDotApolloDir);
            }
            return path;
        }
        if (DEBUG) {
            System.out.println("findFile: didn't find " + name + " in .apollo");
        }
        if ((handle = new File(path = IOUtil.getRootDir() + "/conf/" + name)).exists()) {
            if (DEBUG) {
                System.out.println("findFile: found " + path + " under rootDir/conf");
            }
            return path;
        }
        if (DEBUG) {
            System.out.println("findFile: didn't find " + name + " in conf");
        }
        if ((handle = new File(path = IOUtil.getRootDir() + "/" + name)).exists()) {
            if (DEBUG) {
                System.out.println("findFile: found " + path + " under APOLLO_ROOT");
            }
            return path;
        }
        if (canCreate) {
            if (IOUtil.canWriteToDirectory(path)) {
                if (DEBUG) {
                    System.out.println("findFile: can write to dir for path " + path + "--returning that as place to create " + name);
                }
                return path;
            }
            if (DEBUG) {
                System.out.println("findFile: can't write to dir for path " + path);
            }
        }
        if (DEBUG) {
            System.out.println("findFile: didn't find " + name + " in " + path);
        }
        if ((handle = new File(path = IOUtil.getRootDir() + "/data/" + name)).exists()) {
            if (DEBUG) {
                System.out.println("findFile: found " + path + " under APOLLO_ROOT/data");
            }
            return path;
        }
        if (DEBUG) {
            System.out.println("findFile: didn't find " + name + " in " + path);
        }
        if (canCreate) {
            System.err.println("Warning: couldn't find or create file " + name + " anywhere");
        }
        return null;
    }

    public static String expandSquiggle(String name) {
        if (name.startsWith("~/")) {
            name = name.substring(2);
            name = System.getProperty("user.home") + "/" + name;
        } else if (name.startsWith("~")) {
            String users = System.getProperty("user.home");
            users = users.substring(0, users.lastIndexOf("/"));
            name = users + "/" + name.substring(1);
        }
        return name;
    }

    public static boolean canWriteToDirectory(String path) {
        String dirstring = "";
        if (path.lastIndexOf("/") < 0 && path.lastIndexOf("\\") < 0) {
            dirstring = ".";
        } else if (path.lastIndexOf("/") >= 0) {
            dirstring = path.substring(0, path.lastIndexOf("/"));
        } else if (path.lastIndexOf("\\") >= 0) {
            dirstring = path.substring(0, path.lastIndexOf("\\"));
        }
        File dir = new File(dirstring);
        return dir.canRead() && dir.canWrite();
    }

    public static boolean isWindows() {
        String osname = System.getProperty("os.name");
        return osname.startsWith("Windows");
    }

    public static boolean isMac() {
        String osname = System.getProperty("os.name");
        return osname.startsWith("Mac");
    }

    public static boolean isUnix() {
        String osname = System.getProperty("os.name");
        return osname.startsWith("Linux") || osname.startsWith("Solaris") || osname.startsWith("Sun") || osname.startsWith("Mac OS X") || osname.indexOf("ix") > 0;
    }

    public static boolean isWebStart() {
        return IOUtil.getRootDir().indexOf("webstart") > 0;
    }

    public static void errorDialog(String msg) {
        if (!CommandLine.isInCommandLineMode()) {
            JOptionPane.showMessageDialog(null, msg, "Warning", 2);
        }
        System.out.println("Warning: " + msg);
    }

    public static InputStream getStreamFromUrl(URL url, String badUrlMessage, String notFoundMessage) throws ApolloAdapterException {
        InputStream stream = null;
        try {
            System.err.println("Trying to open URL " + url);
            stream = url.openStream();
            if (Config.DEBUG) {
                System.err.println("Succesfully opened URL " + url);
            }
            System.err.flush();
        }
        catch (IOException e) {
            System.err.println(badUrlMessage);
            stream = null;
            throw new ApolloAdapterException(badUrlMessage);
        }
        try {
            int tries = 1500;
            do {
                Thread.sleep(10L);
            } while (stream.available() <= 1 && --tries > 0);
            if (stream.available() <= 1) {
                System.err.println(notFoundMessage);
                stream = null;
                throw new ApolloAdapterException(notFoundMessage);
            }
        }
        catch (Exception e) {
            System.err.println(notFoundMessage);
            stream = null;
            throw new ApolloAdapterException(notFoundMessage);
        }
        return stream;
    }

    public static InputStream getStreamFromUrl(URL url, String badUrlMessage) throws ApolloAdapterException {
        return IOUtil.getStreamFromUrl(url, badUrlMessage, "Requested region not found");
    }
}

