/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    protected static SimpleDateFormat[] date_formats = new SimpleDateFormat[]{new SimpleDateFormat("dd-MMM-yyyy"), new SimpleDateFormat("d-MMM-yy"), new SimpleDateFormat("yyyy-M-d"), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"), new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy"), new SimpleDateFormat("EEE MMM dd HH:mm:sszzz yyyy"), new SimpleDateFormat()};
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);

    public static Date makeADate(String date_str) {
        if (date_str == null || date_str.equals("")) {
            return null;
        }
        Date date = null;
        if (date == null) {
            for (int i = 0; date == null && i < date_formats.length; ++i) {
                SimpleDateFormat df = date_formats[i];
                try {
                    date = df.parse(date_str);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    public static String formatDate(Date date) {
        return dateFormat.format(date);
    }

    public static String toGMT(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }

    public static String dateNoTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        return sdf.format(date).toUpperCase();
    }
}

