/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

import apollo.util.HashtableEntry;
import apollo.util.HashtableEnumerator;
import java.io.Serializable;
import java.util.Enumeration;

public class CaseInsensitiveStringHash
implements Serializable {
    private transient HashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final char[] lc = new char[256];
    private static final char[] tmpStr = new char[16];

    private static final int calcHashCode(String str) {
        int h = 0;
        int off = 0;
        char[] llc = lc;
        int len = str.length();
        if (len < 16) {
            str.getChars(0, len, tmpStr, 0);
            for (int i = len; i > 0; --i) {
                h = h * 37 + llc[tmpStr[off++]];
            }
        } else {
            int skip = len / 8;
            int i = len;
            while (i > 0) {
                h = h * 39 + llc[str.charAt(off)];
                i -= skip;
                off += skip;
            }
        }
        return h;
    }

    public CaseInsensitiveStringHash(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new HashtableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public CaseInsensitiveStringHash(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CaseInsensitiveStringHash() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new HashtableEnumerator(this.table, true);
    }

    public synchronized Enumeration elements() {
        return new HashtableEnumerator(this.table, false);
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            HashtableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        HashtableEntry[] tab = this.table;
        int hash = CaseInsensitiveStringHash.calcHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equalsIgnoreCase(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(String key) {
        HashtableEntry[] tab = this.table;
        int hash = CaseInsensitiveStringHash.calcHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equalsIgnoreCase(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        HashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        HashtableEntry[] newTable = new HashtableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            HashtableEntry old = oldTable[i];
            while (old != null) {
                HashtableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized Object put(String key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] tab = this.table;
        int hash = CaseInsensitiveStringHash.calcHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equalsIgnoreCase(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new HashtableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public synchronized Object remove(String key) {
        HashtableEntry[] tab = this.table;
        int hash = CaseInsensitiveStringHash.calcHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry e = tab[index];
        HashtableEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equalsIgnoreCase(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        HashtableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    static {
        for (char idx = '\u0000'; idx < '\u0100'; idx = (char)(idx + '\u0001')) {
            CaseInsensitiveStringHash.lc[idx] = Character.toLowerCase(idx);
        }
    }
}

