/*
 * Decompiled with CFR 0.152.
 */
package apollo.test;

import apollo.dataadapter.TransactionOutputAdapter;
import apollo.dataadapter.chado.ChadoTransactionTransformer;
import apollo.dataadapter.chadoxml.ChadoTransactionXMLWriter;
import apollo.test.ApolloTest;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TestTransactions
extends ApolloTest {
    private final String XORT_ROOT = "/home/wgm/xort/FB_XORT/";

    public TestTransactions(String name) {
        super(name);
    }

    public void testChadoTransactions() {
        ChadoTransactionXMLWriter output = new ChadoTransactionXMLWriter();
        ChadoTransactionTransformer transformer = new ChadoTransactionTransformer();
        ((TransactionOutputAdapter)output).setTransformer(new ChadoTransactionTransformer());
        String fileName = "/home/wgm/apolloTemp/chadoOutput.xml";
        ((TransactionOutputAdapter)output).setTarget(fileName);
        if (!this.curationSet.isChromosomeArmUsed()) {
            output.setMapID(this.curationSet.getChromosome());
            output.setMapType("chromosome");
        } else {
            output.setMapID(this.curationSet.getChromosome());
            output.setMapType("chromosome_arm");
        }
        try {
            output.commitTransactions(this.curationSet.getTransactionManager());
            boolean succeed = false;
            String tnFileName = "/home/wgm/apolloTemp/chadoOutput.ctn";
            if (this.validateChaodXML(tnFileName)) {
                // empty if block
            }
            succeed = this.openLogFile("chadoOutput.ctn");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void commitTransactions(String file) throws Exception {
        String xort = "/home/wgm/xort/FB_XORT/bin/xort_loader.pl";
        xort = xort + " -d chado";
        xort = xort + " -f ";
        xort = xort + file;
        xort = xort + " -i 0";
        xort = xort + " -b 1";
        this.outputParaMsg("Start Loading Transaction XML");
        System.out.println("xort: " + xort);
        Process process = Runtime.getRuntime().exec("perl " + xort);
        int code = process.waitFor();
        InputStream is = null;
        is = code != 0 ? process.getErrorStream() : process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        process.destroy();
        this.outputParaMsg("End Loading Transaction XML");
    }

    private boolean openLogFile(String chadoFileName) throws Exception {
        String logFileName = "/home/wgm/xort/FB_XORT/tmp/validator_" + chadoFileName + ".log";
        FileReader fr = new FileReader(logFileName);
        BufferedReader reader = new BufferedReader(fr);
        String line = null;
        this.outputParaMsg("Validator Log File");
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line.trim());
            buffer.append("\n");
        }
        System.out.println(buffer.toString());
        this.outputParaMsg("Validator Log File");
        return buffer.length() == 0;
    }

    private boolean validateChaodXML(String chadoFileName) throws Exception {
        String xort = "/home/wgm/xort/FB_XORT/bin/xort_validator.pl";
        xort = xort + " -d chado";
        xort = xort + " -f ";
        xort = xort + chadoFileName;
        xort = xort + " -v 1";
        Process process = Runtime.getRuntime().exec("perl " + xort);
        int code = process.waitFor();
        InputStream is = null;
        is = code != 0 ? process.getErrorStream() : process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        this.outputParaMsg("Validator Process Message");
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        process.destroy();
        this.outputParaMsg("Validator Process Message");
        return code == 0;
    }

    private void outputParaMsg(String msg) {
        System.out.println("------- " + msg + " --------");
    }
}

