/*
 * Decompiled with CFR 0.152.
 */
package apollo.test;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.gamexml.GAMEAdapter;
import apollo.dataadapter.gamexml.GAMEAdapterGUI;
import apollo.dataadapter.synteny.SyntenyAdapter;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.editor.AnnotationEditor;
import apollo.editor.TransactionManager;
import apollo.gui.ApolloFrame;
import apollo.gui.TierManagerI;
import apollo.gui.annotinfo.FeatureEditorDialog;
import apollo.gui.genomemap.AnnotationView;
import apollo.gui.genomemap.FeatureTierManager;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CompositeApolloFrame;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.main.CommandLine;
import apollo.main.DataLoader;
import apollo.util.FeatureList;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterUI;

public class TestApollo
extends TestCase {
    private static final boolean MULTI_SPECIES = true;
    private CurationSet curationSet;
    private CompositeApolloFrame apolloFrame;
    private CompositeDataHolder compositeDataHolder;
    private DataLoader loader;
    private SyntenyAdapter syntenyAdapter;
    boolean firstLoad = true;

    public TestApollo(String s) {
        super(s);
    }

    protected void setUp() {
        Config.initializeConfiguration();
        this.apolloFrame = ApolloFrame.getApolloFrame();
    }

    private void loadExampleData() {
        CompositeDataHolder cdh = this.getCompositeDataHolder();
        this.loadCompositeDataHolder(cdh);
    }

    private void loadCompositeDataHolder(CompositeDataHolder cdh) {
        this.loadCompositeDataHolder(cdh, this.getDataAdapter());
    }

    private void loadCompositeDataHolder(CompositeDataHolder cdh, ApolloDataAdapterI adap) {
        this.curationSet = cdh.getCurationSet(0);
        this.apolloFrame.loadData(adap, cdh);
        if (this.firstLoad) {
            this.apolloFrame.completeGUIInitialization();
            this.firstLoad = false;
        }
    }

    private CompositeDataHolder getCompositeDataHolder() {
        if (this.compositeDataHolder == null) {
            this.compositeDataHolder = this.getMultiSpecies();
        }
        return this.compositeDataHolder;
    }

    private ApolloDataAdapterI getDataAdapter() {
        return this.syntenyAdapter;
    }

    private ApolloDataAdapterI getGameWriteAdapter() {
        ApolloDataAdapterI gameAdap = this.getDataAdapter();
        gameAdap = this.syntenyAdapter.getChildAdapter(0);
        String file = "test-save.game";
        gameAdap.setDataInput(new DataInput(DataInputType.FILE, file));
        return gameAdap;
    }

    private DataLoader getDataLoader() {
        if (this.loader == null) {
            this.loader = new DataLoader();
        }
        return this.loader;
    }

    private CompositeDataHolder getSingleSpecies() {
        String gameFile = TestApollo.exampleFileName();
        String[] gameArgs = new String[]{"-x", gameFile};
        try {
            CompositeDataHolder cdh = this.getDataLoader().getCompositeDataHolder(gameArgs, null);
            return cdh;
        }
        catch (ApolloAdapterException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private CompositeDataHolder getMultiSpecies() {
        this.syntenyAdapter = new SyntenyAdapter();
        DataInput di1 = new DataInput(DataInputType.FILE, TestApollo.exampleFileName());
        System.out.println("INput 1 " + di1);
        this.syntenyAdapter.getChildAdapter(0).setDataInput(di1);
        this.setUIDataAdapter(this.syntenyAdapter.getChildAdapter(0), di1);
        DataInput di2 = new DataInput(DataInputType.FILE, TestApollo.dpseExampleFileName());
        System.out.println("Input 2 " + di2);
        this.syntenyAdapter.getChildAdapter(1).setDataInput(di2);
        this.setUIDataAdapter(this.syntenyAdapter.getChildAdapter(1), di2);
        int numOfSpec = 2;
        try {
            CompositeDataHolder cdh = this.syntenyAdapter.loadSpeciesThatContainLinks(numOfSpec);
            return cdh;
        }
        catch (DataAdapterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void setUIDataAdapter(ApolloDataAdapterI adap, DataInput di) {
        GAMEAdapterGUI gameGui = (GAMEAdapterGUI)this.getReadUI(adap);
        gameGui.setCurrentInput(di.getInputString());
        gameGui.setDataAdapter((DataAdapter)adap);
    }

    private DataAdapterUI getReadUI(ApolloDataAdapterI adap) {
        return adap.getUI(ApolloDataAdapterI.OP_READ_DATA);
    }

    private static String exampleFileName() {
        return TestApollo.apolloRoot() + "/data/example.xml";
    }

    private static String dpseExampleFileName() {
        return TestApollo.apolloRoot() + "/data/dpse-example.xml";
    }

    private static String apolloRoot() {
        return System.getProperty("APOLLO_ROOT");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestApollo("test"));
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestApollo.suite());
        System.exit(0);
    }

    public void test() {
        this.loadExampleData();
        this.addDeleteCoalesceTest(false, true);
        this.addDeleteCoalesceTest(false, false);
        this.addDeleteCoalesceTest(true, false);
        this.testUndo();
        this.testSplitNaming();
        this.testPeptideAlignment();
        this.testSynteny();
    }

    public void testUndo() {
        System.out.println("----testUndo");
        FeatureEditorDialog.testNameUndo(this);
    }

    public void testSplitNaming() {
        System.out.println("--- Split Naming");
        SeqFeatureI annot = this.getFirstAnnot();
        if (annot.getNumberOfChildren() > 1) {
            System.out.println("simple split wont work, >1 transcript");
            return;
        }
        SeqFeatureI transcript = annot.getFeatureAt(0);
        if (transcript.getNumberOfChildren() <= 1) {
            System.out.println("cant split " + transcript.getName() + " only has 1 exon");
            return;
        }
        SeqFeatureI firstExon = transcript.getFeatureAt(0);
        SeqFeatureI secondExon = transcript.getFeatureAt(1);
        ApolloNameAdapterI na = this.getNameAdapter(annot);
        String genSplitName = na.generateAnnotSplitName(annot, this.getAnnots(), this.curName());
        Vector<SeqFeatureI> annots = new Vector<SeqFeatureI>(2);
        annots.add(firstExon);
        annots.add(secondExon);
        this.getEditor().setSelections(null, annots, null, null);
        this.getEditor().splitTranscript();
        TestApollo.assertEquals((Object)genSplitName, (Object)this.getFirstAnnot().getName());
        this.checkForRedundantSplitSynonym(this.getFirstAnnot());
    }

    private void checkForRedundantSplitSynonym(SeqFeatureI sf) {
        TestApollo.assertTrue((boolean)sf.hasAnnotatedFeature());
        this.checkForRedundantSplitSynonym(sf.getAnnotatedFeature(), true);
    }

    private void checkForRedundantSplitSynonym(AnnotatedFeatureI annot, boolean checkKids) {
        int i;
        for (i = 0; i < annot.getSynonymSize() - 1; ++i) {
            String syn1 = annot.getSynonym(i).getName();
            for (int j = i; j < annot.getSynonymSize(); ++j) {
                String syn2 = annot.getSynonym(j).getName();
                TestApollo.assertTrue((!syn1.equals(syn2) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < annot.size(); ++i) {
            AnnotatedFeatureI transcript = annot.getFeatureAt(i).getAnnotatedFeature();
            this.checkForRedundantSplitSynonym(transcript, false);
        }
    }

    private SeqFeatureI getFirstAnnot() {
        TestApollo.assertNotNull((Object)this.curationSet);
        return this.curationSet.getAnnots().getFeatureAt(0);
    }

    private SeqFeatureI getFirstExon() {
        return this.getFirstAnnot().getFeatureAt(0).getFeatureAt(0);
    }

    private SeqFeatureI getLastAnnot() {
        int last = this.getCurationSet().getAnnots().size() - 1;
        return this.getCurationSet().getAnnots().getFeatureAt(last);
    }

    private SeqFeatureI getLastExon() {
        return this.getLastAnnot().getFeatureAt(0).getFeatureAt(0);
    }

    private CurationSet getCurationSet() {
        return this.curationSet;
    }

    private StrandedFeatureSetI getAnnots() {
        return this.curationSet.getAnnots();
    }

    private String curName() {
        return this.curationSet.getName();
    }

    private ApolloNameAdapterI getNameAdapter(SeqFeatureI annot) {
        return this.getCurationState().getNameAdapter(annot.getAnnotatedFeature());
    }

    private GuiCurationState getCurationState() {
        return CurationManager.getCurationManager().getActiveCurState();
    }

    private StrandedZoomableApolloPanel getSZAP() {
        return this.getCurationState().getSZAP();
    }

    private AnnotationView getForwardAnnotView() {
        return this.getSZAP().getAnnotView(1);
    }

    private TierManagerI getForwardAnnotTierManager() {
        return this.getForwardAnnotView().getTierManager();
    }

    private TransactionManager getTranManager() {
        return this.getCurationSet().getTransactionManager();
    }

    private int getTransNum() {
        return this.getTranManager().size();
    }

    private AnnotationEditor getEditor() {
        boolean forwardStrand = true;
        return this.getCurationState().getAnnotationEditor(forwardStrand);
    }

    private void testPeptideAlignment() {
        SeqFeatureI blastxResult = this.getBlastXResult();
        TestApollo.assertTrue((boolean)blastxResult.alignmentIsPeptide());
        System.out.println("peptide alignment test passed");
    }

    private SeqFeatureI getBlastXResult() {
        String blastxHitName = "Q9VNA4";
        FeatureList fl = this.curationSet.getResults().findFeaturesByName(blastxHitName);
        TestApollo.assertNotNull((Object)fl.getFeature(0));
        return fl.getFeature(0);
    }

    public void testSynteny() {
        System.out.println("Testing synteny for links...");
        TestApollo.assertTrue((boolean)this.getCompositeDataHolder().hasNonEmptyLinkSet());
        System.out.println("Synteny has links");
    }

    private void addDeleteCoalesceTest(boolean doSecondAdd, boolean doInterimSave) {
        boolean numTransOK;
        this.print("\n\nTESTING add del coalesce... secondAdd " + doSecondAdd + " interim save " + doInterimSave);
        this.getTranManager().clear();
        int low = 1178050;
        int high = 1178100;
        int strand = 1;
        this.getEditor().createAnnotation(low, high, strand, "gene");
        SeqFeatureI addedGene = this.getTranManager().getTransaction(0).getSeqFeature();
        this.print("added " + addedGene.getName() + " # trans " + this.getTransNum());
        if (doInterimSave) {
            this.print("\nDoing interim save to test-save.game");
            ApolloDataAdapterI gameAd = this.getGameWriteAdapter();
            try {
                gameAd.commitChanges(this.getCurationSet());
            }
            catch (ApolloAdapterException e) {
                this.print("got exception on save" + (Object)((Object)e));
            }
            this.print("saved");
        }
        Vector<SeqFeatureI> annots = new Vector<SeqFeatureI>();
        SeqFeatureI addedExon = addedGene.getFeatureAt(0).getFeatureAt(0);
        annots.add(addedExon);
        this.print("deleting exon " + addedExon + " " + addedExon.getName());
        this.getEditor().deleteSelectedFeatures(annots, null);
        this.print("deleted feat, # trans " + this.getTransNum());
        if (doSecondAdd) {
            this.print("doing second add...");
            this.getEditor().createAnnotation(low, high, strand, "gene");
            SeqFeatureI addedGene2 = this.getTranManager().getTransaction(0).getSeqFeature();
            this.print("added " + addedGene2.getName() + " # trans " + this.getTransNum());
        }
        this.getTranManager().coalesce();
        this.print("coalesced - # trans " + this.getTransNum());
        boolean bl = numTransOK = this.getTransNum() == 0;
        if (doSecondAdd) {
            numTransOK = this.getTransNum() == 1;
        }
        TestApollo.assertTrue((String)"coalesce transactions", (boolean)numTransOK);
        this.print("add del coalesced - pass ");
    }

    private void testTiersChange() {
        this.print("Testing prop scheme change with gff to game style change");
        CommandLine cmdLine = CommandLine.getCommandLine();
        String[] args = new String[]{"-i", "gff", "-f", "chr2.200000-400000.gff"};
        try {
            cmdLine.setArgs(args);
            CompositeDataHolder c = this.getDataLoader().getCompositeDataHolder(cmdLine);
            this.loadCompositeDataHolder(c, this.getDataLoader().getDataAdapter());
            Vector gffTierProps = this.getTierManagerProps();
            TestApollo.assertNotNull((Object)gffTierProps);
            args = new String[]{"-x", "tiny.xml"};
            cmdLine.setArgs(args);
            CompositeDataHolder cdh = this.getDataLoader().getCompositeDataHolder(cmdLine);
            this.loadCompositeDataHolder(cdh, this.getDataLoader().getDataAdapter());
            Vector gameTierProps = this.getTierManagerProps();
            String m = "game != gff prop scheme";
            TestApollo.assertTrue((String)m, (!gameTierProps.equals(gffTierProps) ? 1 : 0) != 0);
            this.print("\ngame & gff prop scheme test passed, !=");
        }
        catch (ApolloAdapterException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private Vector getTierManagerProps() {
        FeatureTierManager f = (FeatureTierManager)this.getForwardAnnotTierManager();
        return (Vector)f.getTierProperties().clone();
    }

    private void print(String m) {
        System.out.println(m);
    }

    public void testEquals() {
        System.out.println("----Test start");
        String fileName = "doc/example.xml";
        CurationSet set = new CurationSet();
        GAMEAdapter gameAdapter = new GAMEAdapter();
        gameAdapter.setInput(fileName);
        gameAdapter.setInputType(DataInputType.FILE);
        try {
            set = gameAdapter.getCurationSet();
        }
        catch (ApolloAdapterException e) {
            e.printStackTrace();
        }
        TestApollo.assertNotNull((Object)set);
        TestApollo.assertNotNull((Object)set.getTransactionManager().getTransactions());
        System.out.println("----Test end");
    }
}

