/*
 * Decompiled with CFR 0.152.
 */
package apollo.main;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.GFFAdapter;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.SerialDiskAdapter;
import apollo.dataadapter.chadoxml.ChadoXmlAdapter;
import apollo.dataadapter.gamexml.GAMEAdapter;
import apollo.dataadapter.genbank.GenbankAdapter;
import apollo.datamodel.ApolloDataI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.SequenceI;
import apollo.gui.ApolloFrame;
import apollo.gui.CheckMemoryThread;
import apollo.gui.synteny.CurationManager;
import apollo.main.CommandLine;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterRegistry;
import org.bdgp.io.IOOperation;
import org.bdgp.io.VisualDataAdapter;
import org.bdgp.swing.widget.DataAdapterChooser;
import org.bdgp.util.ProgressListener;

public class DataLoader {
    private ApolloDataAdapterI data_adapter;
    private CompositeDataHolder compositeDataHolder;
    private Object return_value;

    public CompositeDataHolder getCompositeDataHolder(Properties props, ProgressListener listener) throws ApolloAdapterException {
        try {
            DataAdapterRegistry adapterRegistry = Config.getAdapterRegistry();
            String adapterClass = props.getProperty("adapter");
            ApolloDataAdapterI datasource = (ApolloDataAdapterI)adapterRegistry.getAdapter(adapterClass);
            if (datasource == null) {
                System.out.println(adapterClass + " not found in registry. " + "this is what's available:");
                String[] names = adapterRegistry.getAdapterNames(IOOperation.READ);
                for (int i = 0; i < names.length; ++i) {
                    System.out.println("  " + names[i]);
                }
            } else {
                datasource.setStateInformation(props);
                datasource.setRegion(props.getProperty("region"));
                this.compositeDataHolder = this.getData(datasource, listener);
            }
        }
        catch (Exception ie) {
            throw new ApolloAdapterException(ie.getMessage(), ie);
        }
        return this.compositeDataHolder;
    }

    public CompositeDataHolder getCompositeDataHolder(String[] args, ProgressListener listener) throws ApolloAdapterException {
        return this.getCompositeDataHolder(args, listener, false);
    }

    public CompositeDataHolder getCompositeDataHolder(CommandLine commandLine) throws ApolloAdapterException {
        ApolloDataAdapterI datasource = null;
        if (commandLine.readIsSpecified()) {
            try {
                datasource = commandLine.getReadAdapter();
            }
            catch (Exception e) {
                throw new ApolloAdapterException(e);
            }
        }
        this.compositeDataHolder = this.getData(datasource, null, true);
        return this.compositeDataHolder;
    }

    private CompositeDataHolder getCompositeDataHolder(String[] args, ProgressListener listener, boolean quitOnCancel) throws ApolloAdapterException {
        ApolloDataAdapterI datasource = null;
        if (args.length >= 1) {
            DataAdapterRegistry adapterRegistry = Config.getAdapterRegistry();
            try {
                CommandLine commandLine = CommandLine.getCommandLine();
                commandLine.setArgs(args);
                if (commandLine.readIsSpecified()) {
                    datasource = commandLine.getReadAdapter();
                }
                if (datasource != null) {
                    this.compositeDataHolder = this.getData(datasource, listener, quitOnCancel);
                    return this.compositeDataHolder;
                }
                if (args[0].startsWith("-h")) {
                    commandLine.printHelp();
                    System.exit(0);
                }
                if (args[0].equals("-g") || args[0].equals("-gff") || args.length > 2 && (args[2].equals("-g") || args[2].equals("-gff"))) {
                    String gffFile = null;
                    String fastaFile = null;
                    if (args[0].startsWith("-g")) {
                        gffFile = args[1];
                        if (args.length > 2 && args[2].startsWith("-s")) {
                            fastaFile = args[3];
                        } else if (args.length > 2) {
                            commandLine.printHelp();
                            System.err.println("Ignoring unknown arguments: " + args[2] + " " + args[3]);
                        }
                    } else {
                        gffFile = args[3];
                        if (args[0].startsWith("-s")) {
                            fastaFile = args[1];
                        } else {
                            commandLine.printHelp();
                            System.err.println("Ignoring unknown arguments: " + args[0] + " " + args[1]);
                        }
                    }
                    datasource = (GFFAdapter)adapterRegistry.getAdapter("apollo.dataadapter.GFFAdapter");
                    ((GFFAdapter)datasource).setFilename(gffFile);
                    if (fastaFile != null) {
                        ((GFFAdapter)datasource).setSequenceFilename(fastaFile);
                    }
                } else if (args[0].equals("-b")) {
                    datasource = (SerialDiskAdapter)adapterRegistry.getAdapter("apollo.dataadapter.SerialDiskAdapter");
                    ((SerialDiskAdapter)datasource).setFilename(args[1]);
                } else if (args[0].equals("-x")) {
                    datasource = (GAMEAdapter)adapterRegistry.getAdapter("apollo.dataadapter.gamexml.GAMEAdapter");
                    if (datasource == null) {
                        System.err.println("Unable to create a GAME data adapter");
                    } else {
                        DataInputType inputType = DataInputType.FILE;
                        if (args[1].startsWith("http:") || args[1].startsWith("file:")) {
                            inputType = DataInputType.URL;
                        }
                        ((GAMEAdapter)datasource).setInputType(inputType);
                        ((GAMEAdapter)datasource).setInput(args[1]);
                    }
                } else if (args[0].equals("-gb")) {
                    datasource = (GenbankAdapter)adapterRegistry.getAdapter("apollo.dataadapter.genbank.GenbankAdapter");
                    if (datasource == null) {
                        System.err.println("Unable to create a Genbank data adapter");
                    } else {
                        ((GenbankAdapter)datasource).setInputType(DataInputType.FILE);
                        ((GenbankAdapter)datasource).setInput(args[1]);
                    }
                } else if (args[0].equals("-cx") || args[0].equals("-chado")) {
                    datasource = (ChadoXmlAdapter)adapterRegistry.getAdapter("apollo.dataadapter.chadoxml.ChadoXmlAdapter");
                    if (datasource == null) {
                        System.err.println("Unable to create chadoXML data adapter");
                    } else {
                        ((ChadoXmlAdapter)datasource).setInput(args[1]);
                    }
                } else {
                    if (args[0].startsWith("-")) {
                        commandLine.printHelp();
                        throw new ApolloAdapterException("Unrecognized command line argument: " + args[0]);
                    }
                    System.err.println("No filetype argument specified--assuming " + args[0] + " is GAME XML.");
                    datasource = (GAMEAdapter)adapterRegistry.getAdapter("apollo.dataadapter.gamexml.GAMEAdapter");
                    if (datasource == null) {
                        System.err.println("Unable to create a GAME data adapter");
                        return null;
                    }
                    DataInputType inputType = DataInputType.FILE;
                    if (args[0].startsWith("http:") || args[0].startsWith("file:")) {
                        inputType = DataInputType.URL;
                    }
                    ((GAMEAdapter)datasource).setInputType(inputType);
                    ((GAMEAdapter)datasource).setInput(args[0]);
                }
            }
            catch (Exception ie) {
                ie.printStackTrace();
                throw new ApolloAdapterException(ie.getMessage());
            }
            if (datasource != null) {
                this.compositeDataHolder = this.getData(datasource, listener, quitOnCancel);
            }
        } else if (args.length == 0) {
            this.compositeDataHolder = this.getData(datasource, listener, quitOnCancel);
        } else {
            CommandLine.getCommandLine().printHelp();
            StringBuffer arglist = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                arglist.append("arg " + i + ": " + args[i] + " ");
            }
            throw new ApolloAdapterException("Invalid command line: " + arglist);
        }
        return this.compositeDataHolder;
    }

    private CompositeDataHolder getData(ApolloDataAdapterI datasource, ProgressListener listener) throws ApolloAdapterException {
        return this.getData(datasource, listener, false);
    }

    private CompositeDataHolder getData(ApolloDataAdapterI datasource, ProgressListener listener, boolean quitOnCancel) throws ApolloAdapterException {
        CompositeDataHolder out = null;
        if (datasource == null) {
            boolean appendData = false;
            DataChooserThread chooserRun = new DataChooserThread(quitOnCancel, appendData);
            chooserRun.run();
            if (this.return_value == null) {
                return null;
            }
            ApolloDataI ad = (ApolloDataI)this.return_value;
            if (ad.isCurationSet()) {
                out = new CompositeDataHolder(ad.getCurationSet());
            } else if (ad.isCompositeDataHolder()) {
                out = ad.getCompositeDataHolder();
            }
            this.return_value = null;
            System.gc();
        } else {
            this.data_adapter = datasource;
            if (listener != null && datasource instanceof VisualDataAdapter) {
                datasource.addProgressListener(listener);
            }
            try {
                CurationSet cs = datasource.getCurationSet();
                out = new CompositeDataHolder(cs);
            }
            catch (ApolloAdapterException e) {
                JOptionPane msg = new JOptionPane();
                System.err.println((Object)((Object)e) + "\nPrinting stack trace:");
                e.printStackTrace();
                JOptionPane.showMessageDialog(ApolloFrame.getFrame(), e.toString(), "Format error", 2);
            }
        }
        Config.getController().curationSetIsLoaded(out != null);
        this.getSequence(out);
        return out;
    }

    public boolean putCurationSet(ApolloDataAdapterI datasource, CurationSet curation_set) {
        try {
            datasource.commitChanges(curation_set);
            Config.getController().setAnnotationChanged(false);
            return true;
        }
        catch (DataAdapterException ex) {
            System.err.println(ex.getMessage());
            JOptionPane.showMessageDialog(null, "Could not save because of " + ex.toString());
            return false;
        }
    }

    public boolean saveCompositeDataHolder(ApolloDataAdapterI datasource, CompositeDataHolder cdh) {
        try {
            datasource.commitChanges(cdh);
            Config.getController().setAnnotationChanged(false);
            return true;
        }
        catch (DataAdapterException ex) {
            System.err.println((Object)ex);
            JOptionPane.showMessageDialog(null, "Could not save because of " + ex.toString());
            return false;
        }
    }

    public void getSequence(CompositeDataHolder compositeDataHolder) throws ApolloAdapterException {
        if (compositeDataHolder.isMultiSpecies()) {
            return;
        }
        CurationSet curation_set = compositeDataHolder.getCurationSet(0);
        if (this.data_adapter != null && curation_set != null) {
            SequenceI seq = curation_set.getRefSequence();
            if (seq == null || seq.getLength() == 0) {
                try {
                    DbXref dbx = new DbXref(curation_set.getName(), curation_set.getName(), curation_set.getName());
                    System.out.println("Trying to get sequence for region " + dbx.getIdValue());
                    seq = this.data_adapter.getSequence(dbx);
                    curation_set.setRefSequence(seq);
                }
                catch (NotImplementedException e) {
                    System.err.println("Didn't set sequence because methods were not implemented");
                    seq = null;
                }
            }
            if (seq != null && seq.getLength() > 0) {
                if (curation_set.getResults() == null) {
                    System.err.println("No results!");
                } else {
                    curation_set.getResults().setRefSequence(seq);
                }
                if (curation_set.getAnnots() == null) {
                    System.err.println("No curated annotations!");
                } else {
                    curation_set.getAnnots().setRefSequence(seq);
                }
            }
        }
    }

    public ApolloDataAdapterI getDataAdapter() {
        return this.data_adapter;
    }

    public void addToCurationSet() throws ApolloAdapterException {
        try {
            DataAdapterRegistry registry = Config.getAdapterRegistry();
            DataAdapter[] loaders = registry.getAdapters(ApolloDataAdapterI.OP_APPEND_DATA, false);
            for (int i = 0; i < loaders.length; ++i) {
                ApolloDataAdapterI adapter = (ApolloDataAdapterI)loaders[i];
                CurationManager cm = CurationManager.getCurationManager();
                adapter.setCuration(cm.getActiveCurState().getCurationSet());
            }
            this.addData();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApolloAdapterException(e.getMessage(), e);
        }
    }

    private boolean addData() throws ApolloAdapterException {
        boolean out = false;
        boolean exitOnCancel = false;
        boolean appendData = true;
        DataChooserThread chooserRun = new DataChooserThread(exitOnCancel, appendData);
        chooserRun.run();
        if (this.return_value != null) {
            out = (Boolean)this.return_value;
        }
        this.return_value = null;
        System.gc();
        return out;
    }

    public void saveFileDialog(ApolloDataI apolloData) {
        SaveAdapterChooser chooser = new SaveAdapterChooser(apolloData);
        String historyFile = Config.getAdapterHistoryFile();
        if (historyFile != null && historyFile.length() > 0) {
            chooser.setPropertiesFile(new File(historyFile));
        }
        chooser.show();
        Config.getController().setAnnotationChanged(false);
    }

    class SaveAdapterChooser
    extends DataAdapterChooser {
        SaveAdapterChooser(Object input) {
            super(Config.getAdapterRegistry(), ApolloDataAdapterI.OP_WRITE_DATA, "Write data", input, false);
        }

        public void doCommit() {
            CheckMemoryThread cmt = new CheckMemoryThread(Config.getMemoryAllocation());
            cmt.checkFreeMemory();
            cmt.halt();
            cmt = null;
            super.doCommit();
            this.input = null;
        }
    }

    class ApolloAdapterChooser
    extends DataAdapterChooser {
        ApolloAdapterChooser(Frame parent, DataAdapterRegistry registry, IOOperation op, String title, Object input, boolean failfast) {
            super(parent, registry, op, title, input, failfast);
        }

        public Object getOutput() {
            Object returnedOutput = this.output;
            this.output = null;
            return returnedOutput;
        }

        public void doCommit() {
            try {
                super.doCommitWithExceptions();
            }
            catch (DataAdapterException exception) {
                System.err.println(exception.getMessage());
                JOptionPane.showMessageDialog((Component)((Object)this), exception.getMessage());
                this.failed = false;
            }
        }
    }

    private class DataChooserThread
    implements Runnable {
        private boolean quitOnCancel;
        private boolean appendData;

        private DataChooserThread(boolean quitOnCancel, boolean appendData) {
            this.quitOnCancel = quitOnCancel;
            this.appendData = appendData;
        }

        public void run() {
            IOOperation op = this.appendData ? ApolloDataAdapterI.OP_APPEND_DATA : ApolloDataAdapterI.OP_READ_DATA;
            String title = this.appendData ? "Apollo: adding data" : "Apollo: load data";
            ApolloAdapterChooser chooser = new ApolloAdapterChooser(ApolloFrame.getFrame(), Config.getAdapterRegistry(), op, title, null, true);
            chooser.setBackground(Config.getDataLoaderBackgroundColor());
            chooser.setForeground(Config.getDataLoaderLabelColor());
            chooser.setLabelColor(Config.getDataLoaderTitleColor());
            String historyFile = Config.getAdapterHistoryFile();
            if (historyFile != null && historyFile.length() > 0) {
                chooser.setPropertiesFile(new File(historyFile));
            }
            chooser.show();
            chooser.invalidate();
            chooser.validate();
            if (!chooser.isCancelled() && !chooser.isFailure()) {
                DataAdapter adapter = chooser.getDataAdapter();
                if (adapter instanceof ApolloDataAdapterI) {
                    DataLoader.this.data_adapter = (ApolloDataAdapterI)adapter;
                }
                DataLoader.this.return_value = chooser.getOutput();
            } else if (chooser.isFailure()) {
                DataAdapterException ex = chooser.getException();
                String message = ex.getMessage();
                JOptionPane msg = new JOptionPane();
                System.err.println(message);
                JOptionPane.showMessageDialog(ApolloFrame.getFrame(), message, "Read error", 2);
                DataLoader.this.return_value = null;
            } else if (chooser.isCancelled()) {
                if (this.quitOnCancel) {
                    System.out.println("Nothing loaded so quitting");
                    System.exit(0);
                }
                DataLoader.this.return_value = null;
            }
            chooser.dispose();
            chooser = null;
        }
    }
}

