/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.tweeker;

import apollo.datamodel.CurationSet;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SequenceI;
import apollo.gui.Selection;
import apollo.gui.SequenceSelector;
import apollo.gui.detailviewers.seqexport.SeqExport;
import apollo.gui.drawable.Drawable;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.gui.tweeker.CutSite;
import apollo.gui.tweeker.RestrictionEnzyme;
import apollo.gui.tweeker.Tweeker;
import apollo.util.FeatureList;
import apollo.util.SeqFeatureUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class RestrictionEnzymeSelector
extends JPanel
implements ActionListener {
    private Vector restrictionEnzymes = new Vector();
    private JList jList;
    private JButton digestButton = new JButton("Digest");
    private JButton seqButton = new JButton("Show selected restriction fragment sequences");
    private JButton clearButton = new JButton("Clear");
    private JLabel instrucs = new JLabel("Use the control key to select multiple restriction enzymes");
    private Drawable drawable;
    private Tweeker parent;
    private SiteSelectorTable siteTable;
    private JScrollPane siteTableScroller = new JScrollPane();

    RestrictionEnzymeSelector(Tweeker parent) {
        this.parent = parent;
        Dimension buttonSize = new Dimension(90, 20);
        this.digestButton.setPreferredSize(buttonSize);
        this.digestButton.addActionListener(this);
        this.digestButton.setBackground(Color.white);
        this.seqButton.setPreferredSize(new Dimension(180, 20));
        this.seqButton.addActionListener(this);
        this.seqButton.setBackground(Color.white);
        this.seqButton.setEnabled(false);
        this.clearButton.setPreferredSize(buttonSize);
        this.clearButton.addActionListener(this);
        this.clearButton.setBackground(Color.white);
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalStrut(20));
        buttonsBox.add(this.digestButton);
        buttonsBox.add(Box.createHorizontalStrut(20));
        buttonsBox.add(this.clearButton);
        this.jList = new JList(this.getRestrictionEnzymes());
        this.jList.setCellRenderer(new RestrictionCell());
        JScrollPane scrollPane = new JScrollPane(this.jList);
        this.setBackground(Color.white);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.instrucs);
        this.add(Box.createVerticalStrut(10));
        this.add(scrollPane);
        this.add(Box.createVerticalStrut(10));
        this.add(buttonsBox);
        this.add(Box.createVerticalStrut(10));
        this.add(this.siteTableScroller);
        this.add(Box.createVerticalStrut(10));
        this.add(this.seqButton);
        this.add(Box.createVerticalStrut(10));
    }

    private GuiCurationState getActiveCurState() {
        return CurationManager.getCurationManager().getActiveCurState();
    }

    private CurationSet getCurSet() {
        return this.getActiveCurState().getCurationSet();
    }

    private StrandedZoomableApolloPanel getSZAP() {
        return this.getActiveCurState().getSZAP();
    }

    private SequenceI getSeq() {
        return this.getCurSet().getRefSequence();
    }

    public void actionPerformed(ActionEvent e) {
        boolean changed = false;
        if (e.getSource() == this.digestButton) {
            this.getSZAP().getScaleView().clearCutSites();
            this.enzymeSelected();
            if (this.siteTable != null) {
                this.siteTableScroller.setEnabled(true);
                this.siteTable.setVisible(true);
            }
            changed = true;
        } else if (e.getSource() == this.seqButton) {
            this.showFragments();
            changed = true;
        } else if (e.getSource() == this.clearButton) {
            this.clearSites();
            changed = true;
        }
        if (changed) {
            this.parent.validate();
            this.parent.pack();
        }
    }

    private void clearSites() {
        this.jList.clearSelection();
        this.seqButton.setEnabled(false);
        this.getSZAP().getScaleView().clearCutSites();
        if (this.siteTable != null) {
            this.siteTableScroller.setEnabled(false);
            this.siteTable.setVisible(false);
        }
    }

    void addToTabbedPane(JTabbedPane pane) {
        pane.addTab(this.getTitle(), null, this, this.getTip());
    }

    private String getTitle() {
        return "Restriction Enzymes";
    }

    private String getTip() {
        return "Search for restriction enzyme sites";
    }

    private Vector getRestrictionEnzymes() {
        String root = System.getProperty("APOLLO_ROOT");
        File resEnzFile = new File(root + "/data/restriction_enzymes.dat");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(resEnzFile));
            String line = reader.readLine();
            Random randomizer = new Random();
            while (line != null) {
                int spaceIndex = line.indexOf(" ");
                String resEnzymeName = line.substring(0, spaceIndex);
                String resEnzymeSequence = line.substring(spaceIndex + 1);
                Color re_color = this.getNewColor(randomizer);
                RestrictionEnzyme re = new RestrictionEnzyme(resEnzymeName, resEnzymeSequence, this.getSeq(), re_color);
                this.restrictionEnzymes.addElement(re);
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't find restriction enzyme file: " + resEnzFile + "\n" + e);
        }
        catch (IOException e) {
            String m = "IOException occured while reading restriction enzyme file: ";
            System.err.println(m + e);
        }
        return this.restrictionEnzymes;
    }

    private Color getNewColor(Random randomizer) {
        int red = 0;
        int green = 0;
        int blue = 0;
        boolean tooPale = true;
        while (tooPale) {
            red = randomizer.nextInt(255);
            if (red + (green = randomizer.nextInt(255)) + (blue = randomizer.nextInt(255)) > 510) continue;
            tooPale = false;
        }
        return new Color(red, green, blue);
    }

    private void enzymeSelected() {
        int[] ind = this.jList.getSelectedIndices();
        Vector all_positions = new Vector();
        for (int i = 0; i < ind.length; ++i) {
            RestrictionEnzyme re = (RestrictionEnzyme)this.restrictionEnzymes.elementAt(ind[i]);
            String cut_site = re.getCutSite();
            SequenceSelector ss = new SequenceSelector(this.getCurSet(), cut_site, false, false);
            Vector forward_positions = ss.getZones();
            ss = new SequenceSelector(this.getCurSet(), cut_site, true, false);
            Vector reverse_positions = ss.getZones();
            System.out.println(re.toString() + " adding " + (forward_positions.size() + reverse_positions.size()) + " cut sites, color = " + re.getColor().toString());
            this.getSZAP().getScaleView().addCutSites(forward_positions, reverse_positions, re.getColor());
            this.collectSites(re, forward_positions, all_positions, 1);
            this.collectSites(re, reverse_positions, all_positions, -1);
        }
        if (all_positions.size() > 0) {
            CutSiteModel model = new CutSiteModel();
            this.addTail(all_positions);
            model.setData(all_positions);
            if (this.siteTable == null) {
                this.siteTable = new SiteSelectorTable();
                this.siteTableScroller.setViewportView(this.siteTable);
            }
            this.siteTable.setModel(model);
            TableColumn siteColumn = this.siteTable.getColumnModel().getColumn(0);
            CutSiteRenderer siteRenderer = new CutSiteRenderer();
            siteRenderer.setToolTipText("Click to center on this site");
            siteColumn.setCellRenderer(siteRenderer);
            TableColumn bpColumn = this.siteTable.getColumnModel().getColumn(2);
            DefaultTableCellRenderer bpRenderer = new DefaultTableCellRenderer();
            bpRenderer.setToolTipText("Upstream from this site to previous site");
            bpColumn.setCellRenderer(bpRenderer);
            this.initColumnSizes(this.siteTable);
            this.seqButton.setEnabled(true);
        } else {
            this.seqButton.setEnabled(false);
            this.clearSites();
            this.siteTable = null;
        }
    }

    void clear() {
        this.getSZAP().getScaleView().clearCutSites();
    }

    protected void showFragments() {
        CutSiteModel model = (CutSiteModel)this.siteTable.getModel();
        Vector cutSites = model.getData();
        Vector<SeqFeature> fragments = new Vector<SeqFeature>();
        int rows = cutSites.size();
        for (int i = 0; i < rows; ++i) {
            String name;
            int low;
            int high;
            CutSite site = (CutSite)cutSites.elementAt(i);
            if (!site.exportFragment()) continue;
            if (i == 0) {
                high = site.getHigh();
                low = this.getCurSet().getLow();
                name = "Upstream_" + site.getRestrictionEnzyme().getName();
            } else {
                CutSite preceding = (CutSite)cutSites.elementAt(i - 1);
                high = site.getHigh();
                low = preceding.getLow();
                name = site.getRestrictionEnzyme() != null ? preceding.getRestrictionEnzyme().getName() + "_" + site.getRestrictionEnzyme().getName() : preceding.getRestrictionEnzyme().getName() + "_" + "Downstream";
            }
            SeqFeature frag = new SeqFeature(low, high, "restriction_fragment", 1);
            frag.setName(name);
            frag.setRefSequence(this.getSeq());
            fragments.addElement(frag);
        }
        if (fragments.size() > 0) {
            Selection selection = new Selection();
            selection.add(new FeatureList(fragments), this);
            new SeqExport(selection, this.getActiveCurState().getController());
        }
    }

    protected void collectSites(RestrictionEnzyme re, Vector new_positions, Vector all_positions, int strand) {
        int match_cnt = new_positions.size();
        for (int i = 0; i < match_cnt; ++i) {
            int[] match_positions = (int[])new_positions.elementAt(i);
            int cut_count = all_positions.size();
            boolean palindrome = false;
            for (int j = 0; j < cut_count && !palindrome; ++j) {
                CutSite cutsite = (CutSite)all_positions.elementAt(j);
                palindrome = match_positions[0] == cutsite.getLow() && match_positions[1] == cutsite.getHigh();
            }
            if (palindrome) continue;
            CutSite match = strand == 1 ? new CutSite(match_positions[0], match_positions[1], re) : new CutSite(match_positions[1], match_positions[0], re);
            match.setRefSequence(re.getRefSequence());
            all_positions.add(match);
            SeqFeatureUtil.sort(all_positions, 1);
        }
    }

    private void addTail(Vector all_positions) {
        all_positions.addElement(new CutSite(this.getCurSet().getEnd(), this.getCurSet().getEnd(), null));
    }

    private void initColumnSizes(JTable table) {
        CutSiteModel model = (CutSiteModel)table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        Object[] longValues = model.longValues();
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    protected static class CutSiteRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object value) {
            if (value != null) {
                RestrictionEnzyme re = (RestrictionEnzyme)value;
                this.setForeground(Color.white);
                this.setBackground(re.getColor());
                this.setText(re.toString());
            } else {
                this.setForeground(Color.black);
                this.setBackground(Color.white);
                this.setText("Downstream");
            }
        }
    }

    protected class CutSiteModel
    extends AbstractTableModel {
        private Vector data;
        private Vector columns = new Vector();

        protected CutSiteModel() {
            this.columns.addElement("Enzyme");
            this.columns.addElement("Restriction site position");
            this.columns.addElement("Fragment position");
            this.columns.addElement("Fragment length");
            this.columns.addElement("Select");
        }

        protected void setData(Vector data) {
            this.data = data;
        }

        protected Vector getData() {
            return this.data;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public Object[] longValues() {
            Object[] longestValues = new Object[this.getColumnCount()];
            for (int col = 0; col < this.columns.size() - 1; ++col) {
                longestValues[col] = col == 0 ? ((RestrictionEnzyme)this.getValueAt(0, col)).toString() : (String)this.getValueAt(0, col);
                for (int row = 1; row < this.data.size(); ++row) {
                    String obj;
                    String string = obj = col == 0 ? ((RestrictionEnzyme)this.getValueAt(0, col)).toString() : (String)this.getValueAt(row, col);
                    if (obj.length() <= ((String)longestValues[col]).length()) continue;
                    longestValues[col] = obj;
                }
            }
            longestValues[this.getColumnCount() - 1] = Boolean.TRUE;
            return longestValues;
        }

        public String getColumnName(int column) {
            return (String)this.columns.elementAt(column);
        }

        public Object getValueAt(int row, int column) {
            CutSite site = (CutSite)this.data.elementAt(row);
            switch (column) {
                case 0: {
                    return site.getRestrictionEnzyme();
                }
                case 1: {
                    return site.getStart() + "-" + site.getEnd();
                }
                case 2: {
                    CutSite preceding = row > 0 ? (CutSite)this.data.elementAt(row - 1) : null;
                    return preceding == null ? RestrictionEnzymeSelector.this.getCurSet().getLow() + "-" + site.getHigh() : preceding.getLow() + "-" + site.getHigh();
                }
                case 3: {
                    CutSite preceding = row > 0 ? (CutSite)this.data.elementAt(row - 1) : null;
                    return preceding == null ? "" + (site.getHigh() - RestrictionEnzymeSelector.this.getCurSet().getLow() + 1) : "" + (site.getHigh() - preceding.getLow() + 1);
                }
                case 4: {
                    return new Boolean(site.exportFragment());
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col == this.getColumnCount() - 1;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == this.getColumnCount() - 1) {
                CutSite site = (CutSite)this.data.elementAt(row);
                site.exportFragment((Boolean)value);
                this.fireTableCellUpdated(row, col);
            }
        }
    }

    protected class SiteSelectorTable
    extends JTable {
        SiteSelectorTable() {
            this.setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new TableSelector());
        }

        private void fireBaseFocusEvent(String posString) {
            int pos = Integer.parseInt(posString);
            BaseFocusEvent evt = new BaseFocusEvent(this, pos, new SeqFeature());
            RestrictionEnzymeSelector.this.getActiveCurState().getController().handleBaseFocusEvent(evt);
        }

        private class TableSelector
        implements ListSelectionListener {
            private TableSelector() {
            }

            public void valueChanged(ListSelectionEvent e) {
                int row = SiteSelectorTable.this.getSelectedRow();
                if (row >= 0 && !e.getValueIsAdjusting()) {
                    int low;
                    int high;
                    String position = (String)SiteSelectorTable.this.getValueAt(row, 1);
                    int index = position.indexOf("-");
                    SiteSelectorTable.this.fireBaseFocusEvent(position.substring(0, index));
                    CutSiteModel model = (CutSiteModel)RestrictionEnzymeSelector.this.siteTable.getModel();
                    Vector cutSites = model.getData();
                    CutSite site = (CutSite)cutSites.elementAt(row);
                    int strand = 1;
                    if (row == 0) {
                        high = site.getHigh();
                        low = RestrictionEnzymeSelector.this.getCurSet().getLow();
                    } else {
                        CutSite preceding = (CutSite)cutSites.elementAt(row - 1);
                        high = site.getHigh();
                        low = preceding.getLow();
                        strand = site.getStart() > site.getEnd() ? 1 : -1;
                    }
                    SeqFeature frag = new SeqFeature(low, high, "Sequence selection", 1);
                    RestrictionEnzymeSelector.this.getActiveCurState().getSelectionManager().select(frag, (Object)this);
                    int maxWindow = 100;
                    if (high - low > maxWindow) {
                        int subtract = -1 * (high - low - maxWindow);
                        int centerBase = low + maxWindow / 2;
                        RestrictionEnzymeSelector.this.getSZAP().zoomToSelectionWithWindow(subtract, centerBase);
                    } else {
                        RestrictionEnzymeSelector.this.getSZAP().zoomToSelection();
                    }
                }
            }
        }
    }

    protected class RestrictionCell
    extends JLabel
    implements ListCellRenderer {
        protected RestrictionCell() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setForeground(((RestrictionEnzyme)value).getColor());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

