/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.synteny;

import apollo.config.Config;
import apollo.gui.StatusBar;
import apollo.gui.UnBorderedSplitPane;
import apollo.gui.event.ReverseComplementEvent;
import apollo.gui.event.ReverseComplementListener;
import apollo.gui.genomemap.ApolloPanel;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CompositeApolloFrame;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.SyntenyLinkPanel;
import gov.sandia.postscript.PSGr2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SyntenyPanel
extends JPanel
implements ReverseComplementListener {
    private Vector speciesPanels;
    private Vector linkPanels;
    private StatusBar sb;
    private CompositeApolloFrame compositeApolloFrame;
    int curNumCuration = 0;

    public SyntenyPanel(Vector speciesPanels, Vector linkPanels, CompositeApolloFrame c) {
        this.speciesPanels = speciesPanels;
        this.linkPanels = linkPanels;
        this.compositeApolloFrame = c;
        for (int i = 0; i < linkPanels.size(); ++i) {
            ((SyntenyLinkPanel)linkPanels.elementAt(i)).setSyntenyPanel(this);
        }
        this.setPreferredSize(new Dimension(900, 350));
        this._layoutPanels();
    }

    void setPanels(Vector szaps, Vector linkPanels) {
        this.speciesPanels = szaps;
        this.linkPanels = linkPanels;
        for (int i = 0; i < linkPanels.size(); ++i) {
            ((SyntenyLinkPanel)linkPanels.elementAt(i)).setSyntenyPanel(this);
        }
        this._layoutPanels();
    }

    public void print(File file, String orientation, String scale) {
        try {
            int yOffset;
            PrintWriter fw = new PrintWriter(new FileWriter(file));
            PSGr2 psg = new PSGr2((Writer)fw);
            double scaleVal = 1.0;
            try {
                scaleVal = new Double(scale);
            }
            catch (Exception e) {
                System.out.println("Invalid scale factor");
                return;
            }
            if (orientation.equals("landscape")) {
                fw.println("-30 30 translate");
                fw.println("90 rotate");
                yOffset = (int)(-822.0 * scaleVal);
                fw.println("" + (int)(30.0 * scaleVal) + " " + (int)(-822.0 * scaleVal) + " translate");
                fw.println("" + scale + " " + scale + " scale");
            } else {
                fw.println("-30 30 translate");
                yOffset = (int)(762.0 - 792.0 * scaleVal);
                fw.println("30 " + yOffset + " translate");
                fw.println("" + scale + " " + scale + " scale");
            }
            this.invalidate();
            psg.setClip(new Rectangle(0, 0, this.getSize().width, this.getSize().height));
            for (int i = 0; i < this.speciesPanels.size(); ++i) {
                ApolloPanel ap = ((StrandedZoomableApolloPanel)this.speciesPanels.elementAt(i)).getApolloPanel();
                ap.paintComponent((Graphics)psg);
                yOffset = (int)((double)ap.getSize().height);
                fw.println("0 " + -yOffset + " translate");
                if (i == this.speciesPanels.size() - 1) continue;
                SyntenyLinkPanel slp = (SyntenyLinkPanel)this.linkPanels.elementAt(i);
                slp.paintComponent((Graphics)psg);
                yOffset = (int)((double)slp.getSize().height);
                fw.println("0 " + -yOffset + " translate");
            }
            psg.dispose();
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Failed printing to file " + file + " Exception: " + e);
            e.printStackTrace();
        }
    }

    public Vector getPanels() {
        return this.speciesPanels;
    }

    public Vector getLinkPanels() {
        return this.linkPanels;
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 550);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void addPanel(StrandedZoomableApolloPanel ap) {
        if (!this.speciesPanels.contains(ap)) {
            this.speciesPanels.addElement(ap);
        }
    }

    public void removePanel(StrandedZoomableApolloPanel ap) {
        if (this.speciesPanels.contains(ap)) {
            this.speciesPanels.removeElement(ap);
            this._layoutPanels();
        }
    }

    public void addLinkPanel(SyntenyLinkPanel linkPanel) {
        if (!this.linkPanels.contains(linkPanel)) {
            this.linkPanels.addElement(linkPanel);
        }
    }

    public boolean handleReverseComplementEvent(ReverseComplementEvent evt) {
        this.repaint();
        return false;
    }

    public void setStatusBar(StatusBar sb) {
        int i;
        if (this.speciesPanels.size() > 0) {
            for (i = 0; i < this.speciesPanels.size(); ++i) {
                ((StrandedZoomableApolloPanel)this.speciesPanels.elementAt(i)).setStatusBar(sb);
            }
        }
        if (this.linkPanels.size() > 0) {
            for (i = 0; i < this.linkPanels.size(); ++i) {
                SyntenyLinkPanel lp = (SyntenyLinkPanel)this.linkPanels.elementAt(i);
                lp.setStatusBar(sb);
            }
        }
        this.sb = sb;
    }

    private void linkPanelsWithController() {
        if (this.speciesPanels.size() > 0) {
            for (int i = 0; i < this.speciesPanels.size(); ++i) {
            }
        }
    }

    public void zoomToSelection() {
        if (this.speciesPanels.size() > 0) {
            for (int i = 0; i < this.speciesPanels.size(); ++i) {
                ((StrandedZoomableApolloPanel)this.speciesPanels.elementAt(i)).zoomToSelection();
            }
        }
    }

    public StatusBar getStatusBar() {
        return this.sb;
    }

    private void _layoutPanels() {
        UnBorderedSplitPane currentSplitPane = null;
        JComponent topComponent = null;
        Object bottomComponent = null;
        boolean lastComponentWasSzap = false;
        int bigPanelSize = Config.getStyle().getSingleSpeciesPanelSize();
        int smallPanelSize = Config.getStyle().getLinkPanelSize();
        int currentDividerLocation = 0;
        if (CurationManager.getCurationManager().numberOfCurations() == this.curNumCuration) {
            return;
        }
        this.curNumCuration = CurationManager.getCurationManager().numberOfCurations();
        if (bigPanelSize <= 0) {
            bigPanelSize = 300;
        }
        if (smallPanelSize <= 0) {
            smallPanelSize = 50;
        }
        if (this.speciesPanels.size() > 0) {
            this.removeAll();
            for (int i = 0; i < this.speciesPanels.size(); ++i) {
                if (currentSplitPane == null) {
                    topComponent = this.getSzap(i);
                } else {
                    currentSplitPane = new UnBorderedSplitPane(0, currentSplitPane, this.getSzap(i));
                    currentSplitPane.setResizeWeight(0.5);
                    currentSplitPane.setDividerLocation(currentDividerLocation += smallPanelSize);
                    topComponent = currentSplitPane;
                }
                if (this.linkPanels.size() <= i) continue;
                currentSplitPane = new UnBorderedSplitPane(0, topComponent, this.getLinkPanel(i));
                currentSplitPane.setResizeWeight(0.5);
                currentSplitPane.setDividerLocation(currentDividerLocation += bigPanelSize);
            }
            this.setLayout(new BorderLayout());
            if (currentSplitPane != null) {
                this.add((Component)currentSplitPane, "Center");
            } else {
                this.add((Component)topComponent, "Center");
            }
        }
    }

    public void setVisible(boolean state) {
        super.setVisible(state);
        System.out.println("Got a setVisible call in SyntenyPanel");
    }

    public boolean areOpaqueLinksUsed() {
        return ((SyntenyLinkPanel)this.getLinkPanels().get(0)).getUseOpaqueLinks();
    }

    public boolean areLinksShadedByPercId() {
        return ((SyntenyLinkPanel)this.getLinkPanels().get(0)).getShadeByPercId();
    }

    public void setUseOpaqueLinks(boolean value) {
        Vector panels = this.getLinkPanels();
        for (int i = 0; i < panels.size(); ++i) {
            ((SyntenyLinkPanel)panels.get(i)).setUseOpaqueLinks(value);
            ((SyntenyLinkPanel)panels.get(i)).repaint();
        }
    }

    public void setShadeByPercId(boolean value) {
        Vector panels = this.getLinkPanels();
        for (int i = 0; i < panels.size(); ++i) {
            ((SyntenyLinkPanel)panels.get(i)).setShadeByPercId(value);
            ((SyntenyLinkPanel)panels.get(i)).repaint();
        }
    }

    public void setLockScrolling(boolean value) {
        for (int i = 0; i < this.getPanels().size(); ++i) {
            this.getSzap(i).setScrollingPropagated(value);
        }
    }

    private int numberOfPanels() {
        return this.getPanels().size();
    }

    private StrandedZoomableApolloPanel getSzap(int i) {
        return (StrandedZoomableApolloPanel)this.getPanels().get(i);
    }

    private SyntenyLinkPanel getLinkPanel(int i) {
        return (SyntenyLinkPanel)this.getLinkPanels().get(i);
    }

    void setShiftLockZoom(boolean state) {
        for (int i = 0; i < this.numberOfPanels(); ++i) {
            this.getSzap(i).setShiftForLockedZooming(state);
        }
    }
}

