/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.synteny;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.datamodel.Link;
import apollo.gui.synteny.DrawableLink;
import apollo.gui.synteny.SyntenyLinkPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class SyntenyLinkPolygon
extends Polygon
implements DrawableLink {
    private Link link;
    protected String name;
    protected FeatureProperty property;
    protected double size;
    private int queryWidth;
    private int queryY;
    private SyntenyLinkPanel syntenyLinkPanel;
    private boolean selected = false;
    static PropertyScheme pscheme = Config.getPropertyScheme();

    SyntenyLinkPolygon(Link link, String name, SyntenyLinkPanel s) {
        this.setLink(link);
        this.setProperty();
        this.syntenyLinkPanel = s;
    }

    public void setQueryPixels(int x1, int x2, int y) {
        this.addPoint(x1, y);
        this.addPoint(x2, y);
        this.queryWidth = Math.abs(x2 - x1);
        this.queryY = y;
    }

    public void setHitPixels(int x1, int x2, int y) {
        int xSmaller = x1 < x2 ? x1 : x2;
        int xLarger = x1 > x2 ? x1 : x2;
        this.addPoint(xLarger, y);
        this.addPoint(xSmaller, y);
        this.setSize((xLarger - xSmaller + this.queryWidth) / 2 * Math.abs(y - this.queryY));
    }

    void setLink(Link link) {
        this.link = link;
    }

    public Link getLink() {
        return this.link;
    }

    private double getPercentIdentity() {
        return this.getLink().getPercentIdentity();
    }

    public Color getColour() {
        if (this.property == null) {
            return Color.BLUE;
        }
        return this.syntenyLinkPanel.getColor(this.property, this.selected);
    }

    protected void setProperty() {
        this.property = this.link != null && this.link.getType() != null ? this.getFeatureType(this.link.getType()) : null;
    }

    protected FeatureProperty getProperty() {
        return this.property;
    }

    protected FeatureProperty getFeatureType(String type) {
        FeatureProperty prop = null;
        prop = pscheme.getFeatureProperty(type);
        if (prop == null) {
            System.out.println("No type " + type);
        }
        return prop;
    }

    public boolean isVisible() {
        if (this.property == null) {
            return true;
        }
        return this.property.getTier().isVisible();
    }

    public void setSize(double size) {
        this.size = size;
    }

    public double getSize() {
        return this.size;
    }

    private Polygon getPolygon() {
        return this;
    }

    private void setPaintByScore(Graphics2D g2d) {
        if (this.getPercentIdentity() > 80.0) {
            g2d.setPaint(this.syntenyLinkPanel.getVeryHighMatchPaint(this.getProperty(), this.selected));
        } else if (this.getPercentIdentity() > 65.0) {
            g2d.setPaint(this.syntenyLinkPanel.getHighMatchPaint(this.getProperty(), this.selected));
        } else if (this.getPercentIdentity() > 50.0) {
            g2d.setPaint(this.syntenyLinkPanel.getMediumMatchPaint(this.getProperty(), this.selected));
        } else {
            g2d.setPaint(this.syntenyLinkPanel.getLowMatchPaint(this.getProperty(), this.selected));
        }
    }

    public void draw(Graphics g, boolean full) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
        }
        Polygon p = this.getPolygon();
        if (full) {
            g.setColor(Config.getEdgematchColor());
            if (full) {
                g.drawPolygon(p);
            }
        }
        if (this.syntenyLinkPanel.getShadeByPercId() && this.getLink().hasPercentIdentity() && g2d != null) {
            this.setPaintByScore(g2d);
        } else if (g2d != null) {
            g2d.setPaint(this.getColour());
        } else {
            g.setColor(this.getColour());
        }
        if (p.xpoints[0] == p.xpoints[1] && p.xpoints[2] == p.xpoints[3]) {
            g.drawLine(p.xpoints[0], p.ypoints[0], p.xpoints[2], p.ypoints[2]);
        } else {
            g.fillPolygon(p);
        }
    }

    public Point getQueryMidUserPoint() {
        int xMidPixel = (this.xpoints[0] + this.xpoints[1]) / 2;
        int yMid = 0;
        return this.syntenyLinkPanel.getQueryTransformer().toUser(xMidPixel, yMid);
    }

    public Point getHitMidUserPoint() {
        int xMidPixel = (this.xpoints[2] + this.xpoints[3]) / 2;
        int yMid = 0;
        return this.syntenyLinkPanel.getHitTransformer().toUser(xMidPixel, yMid);
    }

    public boolean intersects(Rectangle r) {
        return this.getPolygon().intersects(r);
    }

    public String getStatusBarString() {
        String scoreString = "";
        if (this.getPercentIdentity() > 0.0) {
            scoreString = String.valueOf(this.getPercentIdentity()) + ":";
        }
        String name1 = this.getLink().getName1();
        String name2 = this.getLink().getName2();
        if (name1 == null || name1.equals("no_name")) {
            name1 = "(" + this.getLink().getLow1() + "-" + this.getLink().getHigh1() + ")";
            name2 = "(" + this.getLink().getLow2() + "-" + this.getLink().getHigh2() + ")";
        }
        return scoreString + name1 + "-" + name2;
    }

    public boolean hasNames() {
        return this.getLink().hasNames();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

