/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.synteny;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropSchemeChangeEvent;
import apollo.config.PropSchemeChangeListener;
import apollo.config.PropertyScheme;
import apollo.datamodel.Link;
import apollo.datamodel.LinkSet;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.SelectionManager;
import apollo.gui.StatusBar;
import apollo.gui.Transformer;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.event.BaseFocusListener;
import apollo.gui.event.ChainedRepaintEvent;
import apollo.gui.event.ChainedRepaintListener;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.event.MouseButtonEvent;
import apollo.gui.event.NamedFeatureSelectionEvent;
import apollo.gui.event.RubberbandEvent;
import apollo.gui.event.RubberbandListener;
import apollo.gui.event.ScrollEvent;
import apollo.gui.event.ScrollListener;
import apollo.gui.event.ZoomEvent;
import apollo.gui.event.ZoomListener;
import apollo.gui.genomemap.Rubberband;
import apollo.gui.genomemap.RubberbandRectangle;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.menus.SyntenyLinkMenu;
import apollo.gui.synteny.DrawableLink;
import apollo.gui.synteny.SyntenyLinkPolygon;
import apollo.gui.synteny.SyntenyPanel;
import apollo.util.FeatureList;
import gov.sandia.postscript.PSGr2;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;

public class SyntenyLinkPanel
extends JPanel
implements BaseFocusListener,
ChainedRepaintListener,
FeatureSelectionListener,
MouseMotionListener,
RubberbandListener,
PropSchemeChangeListener,
ZoomListener,
ScrollListener {
    LinkSet links;
    Transformer trans1;
    Transformer trans2;
    boolean autoStraighten = true;
    RubberbandRectangle rubberband;
    StrandedZoomableApolloPanel szap1;
    StrandedZoomableApolloPanel szap2;
    Hashtable linkHash;
    Vector polyHolder;
    private ArrayList drawables = new ArrayList();
    boolean useOpaqueLinks = Config.getStyle().useOpaqueLinks();
    boolean shadeByPercId;
    StatusBar statusbar;
    private LinkSet selectedLinks;
    private SyntenyPanel syntenyPanel;
    private static final String dnaLinkTypeString = "dna-dna-align";
    private static final String protLinkTypeString = "protein-protein-align";
    private HashMap colorToScorePaint = new HashMap(2);
    Comparator polygonComparator = new Comparator(){

        public int compare(Object polygon1, Object polygon2) {
            double result = ((SyntenyLinkPolygon)polygon1).getSize() - ((SyntenyLinkPolygon)polygon2).getSize();
            if (result > 0.0) {
                return 1;
            }
            if (result < 0.0) {
                return -1;
            }
            return 0;
        }
    };

    public SyntenyLinkPanel(StrandedZoomableApolloPanel szap1, StrandedZoomableApolloPanel szap2) {
        this.trans1 = szap1.getTransformer();
        this.trans2 = szap2.getTransformer();
        this.linkHash = new Hashtable();
        this.szap1 = szap1;
        this.szap2 = szap2;
        this.addMouseListener(new LinkMouseListener());
        this.addMouseMotionListener(this);
        this.rubberband = new RubberbandRectangle(this);
        this.rubberband.setActive(true);
        this.rubberband.addListener(this);
    }

    Transformer getQueryTransformer() {
        return this.trans1;
    }

    Transformer getHitTransformer() {
        return this.trans2;
    }

    void setSyntenyPanel(SyntenyPanel syntenyPanel) {
        this.syntenyPanel = syntenyPanel;
    }

    public void print(File file, String orientation, String scale) {
        try {
            PrintWriter fw = new PrintWriter(new FileWriter(file));
            PSGr2 psg = new PSGr2((Writer)fw);
            double scaleVal = 1.0;
            try {
                scaleVal = new Double(scale);
            }
            catch (Exception e) {
                System.out.println("Invalid scale factor");
                return;
            }
            if (orientation.equals("landscape")) {
                fw.println("-30 30 translate");
                fw.println("90 rotate");
                fw.println("" + (int)(30.0 * scaleVal) + " " + (int)(-822.0 * scaleVal) + " translate");
                fw.println("" + scale + " " + scale + " scale");
            } else {
                fw.println("-30 30 translate");
                int yOffset = (int)(762.0 - 792.0 * scaleVal);
                fw.println("30 " + yOffset + " translate");
                fw.println("" + scale + " " + scale + " scale");
            }
            this.invalidate();
            psg.setClip(new Rectangle(0, 0, this.getSize().width, this.getSize().height));
            this.paintComponent((Graphics)psg);
            psg.dispose();
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Failed printing to file " + file);
        }
    }

    private SeqFeatureI getGeneFeature(SeqFeatureI childFeature) {
        while (childFeature.getRefFeature() != null && childFeature.getRefFeature().getTopLevelType() != null && !childFeature.getRefFeature().getTopLevelType().equals("no_type")) {
            childFeature = childFeature.getRefFeature();
        }
        return childFeature;
    }

    private void setPanelCentres(Point pos1, Point pos2, boolean straighten) {
        if (straighten) {
            this.straightenLinks(pos1, pos2);
        }
        if (this.szap1 != null) {
            this.szap1.getController().handleBaseFocusEvent(new BaseFocusEvent(this, pos1.x, null));
        }
        if (this.szap2 != null) {
            this.szap2.getController().handleBaseFocusEvent(new BaseFocusEvent(this, pos2.x, null));
        }
    }

    private void straightenLinks(Point pos1, Point pos2) {
        Transformer tmpTrans1 = null;
        Transformer tmpTrans2 = null;
        try {
            tmpTrans1 = (Transformer)this.trans1.clone();
            tmpTrans1.setXCentre(pos1.x);
            tmpTrans2 = (Transformer)this.trans2.clone();
            tmpTrans2.setXCentre(pos2.x);
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
        }
        Rectangle bounds1 = tmpTrans1.getPixelBounds();
        Rectangle bounds2 = tmpTrans2.getPixelBounds();
        double avAng = 0.0;
        int nAng = 0;
        PropertyScheme pscheme = Config.getPropertyScheme();
        for (int i = 0; i < this.links.size(); ++i) {
            int highpixel2;
            int lowpixel2;
            int highpixel1;
            int lowpixel1;
            Link link = this.links.getLink(i);
            boolean isVis = true;
            if (link.getType() != null) {
                FeatureProperty property = pscheme.getFeatureProperty(link.getType());
                isVis = property.getTier().isVisible();
            } else {
                System.out.println("Type is null for link " + link);
            }
            if (!isVis) continue;
            int startpixel1 = tmpTrans1.toPixelX(link.getLow1());
            int endpixel1 = tmpTrans1.toPixelX(link.getHigh1());
            int startpixel2 = tmpTrans2.toPixelX(link.getLow2());
            int endpixel2 = tmpTrans2.toPixelX(link.getHigh2());
            if (startpixel1 > endpixel1) {
                lowpixel1 = endpixel1;
                highpixel1 = startpixel1;
            } else {
                lowpixel1 = startpixel1;
                highpixel1 = endpixel1;
            }
            if (startpixel2 > endpixel2) {
                lowpixel2 = endpixel2;
                highpixel2 = startpixel2;
            } else {
                lowpixel2 = startpixel2;
                highpixel2 = endpixel2;
            }
            if ((highpixel1 < bounds1.x || lowpixel1 > bounds1.x + bounds1.width) && (highpixel2 < bounds2.x || lowpixel2 > bounds2.x + bounds2.width)) continue;
            int midpixel1 = (highpixel1 - lowpixel1) / 2 + lowpixel1;
            int midpixel2 = (highpixel2 - lowpixel2) / 2 + lowpixel2;
            double angle = Math.atan2(midpixel2 - midpixel1, this.getBounds().y);
            avAng += angle;
            ++nAng;
        }
        if (nAng != 0) {
            double moveDist = Math.tan(avAng /= (double)nAng) * (double)this.getBounds().y;
            Point pnt = tmpTrans2.toUser((int)(moveDist + (double)tmpTrans2.getPixelBounds().x + (double)(tmpTrans2.getPixelBounds().width / 2)), 0);
            pos2.x = pnt.x;
        }
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent event) {
        if (event.getSource().equals(this)) {
            return false;
        }
        this.deselectLinks();
        if (this.links.linkedByName()) {
            this.doNamedFeatureSelection(event);
        } else {
            this.doRegularFeatureSelection(event);
        }
        this.repaint();
        return true;
    }

    private void doNamedFeatureSelection(FeatureSelectionEvent event) {
        ArrayList<SeqFeatureI> foundFeatures = new ArrayList<SeqFeatureI>();
        HashSet<String> linkNameSet = new HashSet<String>();
        FeatureList selectedFeatures = event.getFeatures();
        for (int i = 0; i < selectedFeatures.size(); ++i) {
            SeqFeatureI selectedFeature = selectedFeatures.getFeature(i);
            if (Config.getStyle().syntenyLinksAreGeneToGene()) {
                selectedFeature = this.getGeneFeature(selectedFeature);
            }
            if (selectedFeature == null || foundFeatures.contains(selectedFeature) || selectedFeature.getName() == "no_name") continue;
            foundFeatures.add(selectedFeature);
            LinkSet linkedLinks = this.links.findLinksWithName(selectedFeature.getName());
            int linkedLinksSize = linkedLinks.size();
            for (int j = 0; j < linkedLinksSize; ++j) {
                Link link = linkedLinks.getLink(j);
                linkNameSet.add(link.getName1());
                linkNameSet.add(link.getName2());
                this.addToSelection(link);
            }
            String[] linkNamesArray = linkNameSet.toArray(new String[linkNameSet.size()]);
            this.fireNamedFeatureSelectionEvent(this, event.getSource(), linkNamesArray);
        }
    }

    private void doRegularFeatureSelection(FeatureSelectionEvent event) {
        FeatureList selectedFeats = event.getFeatures();
        FeatureList linkedFeats = this.getSelectedLinkedSpeciesFeats(selectedFeats);
        if (linkedFeats.isEmpty()) {
            return;
        }
        SelectionManager s = this.getSelectionManagerForFeature(linkedFeats.getFeature(0));
        s.select(linkedFeats, true, false, this);
    }

    private FeatureList getSelectedLinkedSpeciesFeats(FeatureList selectedFeats) {
        FeatureList linkedFeats = new FeatureList();
        for (int i = 0; i < selectedFeats.size(); ++i) {
            SeqFeatureI selectedFeat = selectedFeats.getFeature(i);
            for (int j = 0; j < this.links.size(); ++j) {
                Link link = this.links.getLink(j);
                SeqFeatureI linkedFeat = link.getLinkedSpeciesFeature(selectedFeat);
                if (linkedFeat == null) continue;
                linkedFeats.addFeature(linkedFeat);
                this.addToSelection(link);
            }
        }
        return linkedFeats;
    }

    private SelectionManager getSelectionManagerForFeature(SeqFeatureI feat) {
        if (this.featFromSzap1(feat)) {
            return this.szap1.getSelectionManager();
        }
        return this.szap2.getSelectionManager();
    }

    private boolean featFromSzap1(SeqFeatureI feat) {
        String species1 = this.szap1.getCurationSet().getOrganism();
        return feat.getRefSequence().getOrganism().equals(species1);
    }

    private void fireNamedFeatureSelectionEvent(Object source, Object originalEventSource, String[] featureNames) {
        Controller controllerToOmit = null;
        boolean propagateToSZAP1 = true;
        boolean propagateToSZAP2 = true;
        if (originalEventSource instanceof ControlledObjectI) {
            controllerToOmit = ((ControlledObjectI)originalEventSource).getController();
            propagateToSZAP1 = !this.szap1.getController().equals(controllerToOmit);
            propagateToSZAP2 = !this.szap2.getController().equals(controllerToOmit);
        } else if (originalEventSource instanceof Controller) {
            controllerToOmit = (Controller)originalEventSource;
            propagateToSZAP1 = !this.szap1.getController().equals(controllerToOmit);
            propagateToSZAP2 = !this.szap2.getController().equals(controllerToOmit);
        } else if (originalEventSource instanceof SyntenyLinkPanel) {
            propagateToSZAP1 = !((SyntenyLinkPanel)originalEventSource).isManagingSZAP(this.szap1);
            boolean bl = propagateToSZAP2 = !((SyntenyLinkPanel)originalEventSource).isManagingSZAP(this.szap2);
        }
        if (propagateToSZAP1) {
            this.szap1.getController().handleNamedFeatureSelectionEvent(new NamedFeatureSelectionEvent(source, featureNames));
        }
        if (propagateToSZAP2) {
            this.szap2.getController().handleNamedFeatureSelectionEvent(new NamedFeatureSelectionEvent(source, featureNames));
        }
    }

    public boolean isManagingSZAP(StrandedZoomableApolloPanel szap) {
        return this.szap1 == szap || this.szap2 == szap;
    }

    private void fireZoomEvent(ZoomEvent event) {
        Controller controllerToOmit = null;
        Object originalEventSource = event.getSource();
        boolean propagateToSZAP1 = true;
        boolean propagateToSZAP2 = true;
        if (originalEventSource instanceof ControlledObjectI) {
            controllerToOmit = ((ControlledObjectI)originalEventSource).getController();
            propagateToSZAP1 = !this.szap1.getController().equals(controllerToOmit);
            propagateToSZAP2 = !this.szap2.getController().equals(controllerToOmit);
        } else if (originalEventSource instanceof SyntenyLinkPanel) {
            propagateToSZAP1 = !((SyntenyLinkPanel)originalEventSource).isManagingSZAP(this.szap1);
            boolean bl = propagateToSZAP2 = !((SyntenyLinkPanel)originalEventSource).isManagingSZAP(this.szap2);
        }
        if (propagateToSZAP1) {
            this.szap1.getController().handleZoomEvent(new ZoomEvent(this, true, event.getZoomFactor(), event.getFactorMultiplier()));
        }
        if (propagateToSZAP2) {
            this.szap2.getController().handleZoomEvent(new ZoomEvent(this, true, event.getZoomFactor(), event.getFactorMultiplier()));
        }
    }

    public boolean handleRubberbandEvent(RubberbandEvent evt) {
        Rubberband rb = (Rubberband)evt.getSource();
        DrawableLink foundLink = null;
        if (rb.getComponent() == this) {
            foundLink = this.findDrawableLinkInRect(evt.getBounds());
        }
        if (foundLink != null) {
            Point pos1 = foundLink.getQueryMidUserPoint();
            Point pos2 = foundLink.getHitMidUserPoint();
            this.fireSelectionForSeqHighlight(foundLink);
            this.setPanelCentres(pos1, pos2, false);
        }
        this.repaint();
        return true;
    }

    public boolean syncScales() {
        int curWidth2;
        int curWidth1 = this.szap1.getApolloPanel().getVisibleBasepairWidth();
        if (curWidth1 > (curWidth2 = this.szap2.getApolloPanel().getVisibleBasepairWidth())) {
            int[] limits = new int[]{this.szap1.getApolloPanel().getLinearCentre() - curWidth2 / 2, this.szap1.getApolloPanel().getLinearCentre() + curWidth2 / 2};
            this.szap1.zoomToWidth(curWidth2, limits);
        } else {
            int[] limits = new int[]{this.szap2.getApolloPanel().getLinearCentre() - curWidth1 / 2, this.szap2.getApolloPanel().getLinearCentre() + curWidth1 / 2};
            this.szap2.zoomToWidth(curWidth1, limits);
        }
        this.repaint();
        return true;
    }

    public boolean getAutoStraighten() {
        return this.autoStraighten;
    }

    public void setAutoStraighten(boolean state) {
        this.autoStraighten = state;
    }

    public void setStatusBar(StatusBar bar) {
        this.statusbar = bar;
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    public void paintComponent(Graphics g) {
        int i;
        g.setColor(Config.getCoordBackground());
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(Color.red);
        Rectangle bounds1 = this.trans1.getPixelBounds();
        Rectangle bounds2 = this.trans2.getPixelBounds();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
        this.drawables.clear();
        this.polyHolder = new Vector();
        ArrayList<SyntenyLinkPolygon> selectedDrawableLinks = new ArrayList<SyntenyLinkPolygon>();
        for (int i2 = 0; i2 < this.links.size(); ++i2) {
            int highpixel2;
            int lowpixel2;
            int highpixel1;
            int lowpixel1;
            Link link = this.links.getLink(i2);
            int startpixel1 = this.trans1.toPixelX(link.getLow1());
            int endpixel1 = this.trans1.toPixelX(link.getHigh1());
            int startpixel2 = this.trans2.toPixelX(link.getLow2());
            int endpixel2 = this.trans2.toPixelX(link.getHigh2());
            if (startpixel1 > endpixel1) {
                lowpixel1 = endpixel1;
                highpixel1 = startpixel1;
            } else {
                lowpixel1 = startpixel1;
                highpixel1 = endpixel1;
            }
            if (startpixel2 > endpixel2) {
                lowpixel2 = endpixel2;
                highpixel2 = startpixel2;
            } else {
                lowpixel2 = startpixel2;
                highpixel2 = endpixel2;
            }
            if ((highpixel1 < bounds1.x || lowpixel1 > bounds1.x + bounds1.width) && (highpixel2 < bounds2.x || lowpixel2 > bounds2.x + bounds2.width)) continue;
            SyntenyLinkPolygon drawableLink = null;
            String name = link.getName1() + " " + link.getLow1() + "-" + link.getHigh1() + " " + link.getName2() + " " + link.getLow2() + "-" + link.getHigh2() + " " + link.getStrand1();
            drawableLink = new SyntenyLinkPolygon(link, name, this);
            this.drawables.add(drawableLink);
            drawableLink.setQueryPixels(lowpixel1, highpixel1, 0);
            drawableLink.setHitPixels(highpixel2, lowpixel2, this.getSize().height);
            if (g2d != null) {
                g2d.setColor(drawableLink.getColour());
                if (!this.getUseOpaqueLinks()) {
                    g2d.setComposite(this.makeComposite(0.6f));
                }
            }
            if (!this.getSelectedLinks().contains(link)) continue;
            drawableLink.setSelected(true);
            selectedDrawableLinks.add(drawableLink);
        }
        Collections.sort(this.drawables, this.polygonComparator);
        double minP2CForFullDraw = 0.005;
        for (i = this.drawables.size() - 1; i >= 0; --i) {
            DrawableLink dl = this.getDrawableLink(i);
            if (selectedDrawableLinks.contains(dl)) continue;
            dl.draw(g, this.trans1.getXPixelsPerCoord() > minP2CForFullDraw && this.trans2.getXPixelsPerCoord() > minP2CForFullDraw);
        }
        for (i = 0; i < selectedDrawableLinks.size(); ++i) {
            ((DrawableLink)selectedDrawableLinks.get(i)).draw(g, true);
        }
    }

    public boolean handleBaseFocusEvent(BaseFocusEvent evt) {
        this.repaint();
        return true;
    }

    public boolean handlePropSchemeChangeEvent(PropSchemeChangeEvent evt) {
        this.repaint();
        return true;
    }

    public boolean handleZoomEvent(ZoomEvent evt) {
        if (evt.isPropagated()) {
            this.fireZoomEvent(evt);
        }
        this.repaint();
        return true;
    }

    private void fireSelectionForSeqHighlight(DrawableLink foundDrawableLink) {
        Link link = foundDrawableLink.getLink();
        SeqFeature fake1 = new SeqFeature(link.getLow1(), link.getHigh1(), link.getType(), link.getStrand1());
        Vector<SeqFeature> features1 = new Vector<SeqFeature>();
        features1.addElement(fake1);
        this.szap1.getSelectionManager().select(features1, (Object)this);
        SeqFeature fake2 = new SeqFeature(link.getLow2(), link.getHigh2(), link.getType(), link.getStrand2());
        Vector<SeqFeature> features2 = new Vector<SeqFeature>();
        features2.add(fake2);
        this.szap2.getSelectionManager().select(features2, (Object)this);
    }

    public void mouseMoved(MouseEvent evt) {
        int pos1 = this.trans1.toUser((int)evt.getX(), (int)0).x;
        int pos2 = this.trans2.toUser((int)evt.getX(), (int)0).x;
        DrawableLink foundLink = this._findLink(evt.getPoint());
        if (this.statusbar != null) {
            this.statusbar.setPositionPane(new String(new Integer(pos1).toString() + " " + new Integer(pos2).toString()));
            if (foundLink != null) {
                this.statusbar.setFeaturePane(foundLink.getStatusBarString());
            } else {
                this.statusbar.setFeaturePane("");
            }
        }
    }

    public void mouseDragged(MouseEvent evt) {
    }

    private LinkSet getSelectedLinks() {
        if (this.selectedLinks == null) {
            this.selectedLinks = new LinkSet();
        }
        return this.selectedLinks;
    }

    private void deselectLinks() {
        this.getSelectedLinks().clear();
    }

    private void addToSelection(Link link) {
        this.getSelectedLinks().addLink(link);
    }

    private boolean nothingSelected() {
        return this.getSelectedLinks().size() == 0;
    }

    public Link findFeaturePair(Point pos) {
        DrawableLink foundDrawableLink = this._findLink(pos);
        if (foundDrawableLink != null) {
            return foundDrawableLink.getLink();
        }
        return null;
    }

    private DrawableLink _findLink(Point pos) {
        for (int i = 0; i < this.drawables.size(); ++i) {
            DrawableLink link = this.getDrawableLink(i);
            if (!link.isVisible() || !link.contains(pos)) continue;
            return link;
        }
        return null;
    }

    private DrawableLink findDrawableLinkInRect(Rectangle bounds) {
        for (int i = 0; i < this.drawables.size(); ++i) {
            DrawableLink dl = this.getDrawableLink(i);
            if (!dl.isVisible() || !dl.intersects(bounds)) continue;
            return dl;
        }
        return null;
    }

    private DrawableLink getDrawableLink(int i) {
        return (DrawableLink)this.drawables.get(i);
    }

    public void setLinks(LinkSet links) {
        this.links = links;
    }

    public boolean handleChainedRepaint(ChainedRepaintEvent event) {
        this.repaint();
        return true;
    }

    TexturePaint getLowMatchPaint(FeatureProperty prop, boolean selected) {
        return this.getPropertyScorePaint(prop, selected).getLowMatchPaint();
    }

    TexturePaint getMediumMatchPaint(FeatureProperty prop, boolean selected) {
        return this.getPropertyScorePaint(prop, selected).getMediumMatchPaint();
    }

    TexturePaint getHighMatchPaint(FeatureProperty prop, boolean selected) {
        return this.getPropertyScorePaint(prop, selected).getHighMatchPaint();
    }

    TexturePaint getVeryHighMatchPaint(FeatureProperty prop, boolean selected) {
        return this.getPropertyScorePaint(prop, selected).getVeryHighMatchPaint();
    }

    private PropertyScorePaint getPropertyScorePaint(FeatureProperty prop, boolean select) {
        Color color = this.getColor(prop, select);
        PropertyScorePaint scorePaint = (PropertyScorePaint)this.colorToScorePaint.get(color);
        if (scorePaint == null) {
            scorePaint = new PropertyScorePaint(color);
            this.colorToScorePaint.put(color, scorePaint);
        }
        return scorePaint;
    }

    public void setUseOpaqueLinks(boolean value) {
        this.useOpaqueLinks = value;
    }

    public void setShadeByPercId(boolean value) {
        this.shadeByPercId = value;
    }

    public boolean getUseOpaqueLinks() {
        return this.useOpaqueLinks;
    }

    public boolean getShadeByPercId() {
        return this.shadeByPercId;
    }

    public boolean handleScrollEvent(ScrollEvent event) {
        Object eventSource = event.getSource();
        boolean propagateToSZAP1 = true;
        boolean propagateToSZAP2 = true;
        Controller controllerToOmit = null;
        if (eventSource instanceof ControlledObjectI) {
            controllerToOmit = ((ControlledObjectI)eventSource).getController();
        } else if (eventSource instanceof Controller) {
            controllerToOmit = (Controller)eventSource;
        }
        if (controllerToOmit != null) {
            propagateToSZAP1 = !this.szap1.getController().equals(controllerToOmit);
            propagateToSZAP2 = !this.szap2.getController().equals(controllerToOmit);
        } else if (eventSource instanceof SyntenyLinkPanel) {
            propagateToSZAP1 = !((SyntenyLinkPanel)eventSource).isManagingSZAP(this.szap1);
            propagateToSZAP2 = !((SyntenyLinkPanel)eventSource).isManagingSZAP(this.szap2);
        }
        event.setSource(this);
        if (propagateToSZAP1) {
            this.szap1.getController().handleScrollEvent(event);
        }
        if (propagateToSZAP2) {
            this.szap2.getController().handleScrollEvent(event);
        }
        return true;
    }

    public void displayJustDnaLinks() {
        this.setDnaLinkVisibility(true);
        this.setProteinLinkVisibility(false);
    }

    public void displayJustProteinLinks() {
        this.setDnaLinkVisibility(false);
        this.setProteinLinkVisibility(true);
    }

    public void displayBothLinks() {
        this.setDnaLinkVisibility(true);
        this.setProteinLinkVisibility(true);
    }

    private void setDnaLinkVisibility(boolean vis) {
        Config.getPropertyScheme().getTierProperty(dnaLinkTypeString).setVisible(vis);
    }

    private void setProteinLinkVisibility(boolean vis) {
        Config.getPropertyScheme().getTierProperty(protLinkTypeString).setVisible(vis);
    }

    public void setSingleStrandVisibility(boolean szap1Forward, boolean szap2Forward) {
        this.szap1.setForwardVisible(szap1Forward);
        this.szap1.setReverseVisible(!szap1Forward);
        this.szap2.setForwardVisible(szap2Forward);
        this.szap2.setReverseVisible(!szap2Forward);
    }

    public void showAllStrands() {
        this.szap1.setForwardVisible(true);
        this.szap1.setReverseVisible(true);
        this.szap2.setForwardVisible(true);
        this.szap2.setReverseVisible(true);
    }

    public boolean isTopForwardVisible() {
        return this.szap1.isForwardStrandVisible();
    }

    public boolean isTopReverseVisible() {
        return this.szap1.isReverseStrandVisible();
    }

    public boolean isBottomForwardVisible() {
        return this.szap2.isForwardStrandVisible();
    }

    public boolean isBottomReverseVisible() {
        return this.szap2.isReverseStrandVisible();
    }

    public void homeInOnSelectedLink() {
        if (this.getSelectedLinks().size() != 1) {
            return;
        }
        Link link = this.getSelectedLinks().getLink(0);
        this.setSingleStrandVisibility(link.isForwardStrand1(), link.isForwardStrand2());
        this.szap1.zoomToSelection();
        this.szap2.zoomToSelection();
        this.repaint();
    }

    Color getSelectColor(Color c) {
        return c.brighter();
    }

    Color getColor(FeatureProperty prop, boolean selected) {
        Color c = prop.getColour();
        if (!selected) {
            return c;
        }
        return this.getSelectColor(c);
    }

    private class PropertyScorePaint {
        private Color color;
        private TexturePaint veryHighMatchPaint;
        private TexturePaint highMatchPaint;
        private TexturePaint mediumMatchPaint;
        private TexturePaint lowMatchPaint;

        private PropertyScorePaint(Color color) {
            this.color = color;
        }

        private TexturePaint getVeryHighMatchPaint() {
            if (this.veryHighMatchPaint == null) {
                this.veryHighMatchPaint = this.makeTexturePaint(1);
            }
            return this.veryHighMatchPaint;
        }

        private TexturePaint getHighMatchPaint() {
            if (this.highMatchPaint == null) {
                this.highMatchPaint = this.makeTexturePaint(3);
            }
            return this.highMatchPaint;
        }

        private TexturePaint getMediumMatchPaint() {
            if (this.mediumMatchPaint == null) {
                this.mediumMatchPaint = this.makeTexturePaint(5);
            }
            return this.mediumMatchPaint;
        }

        private TexturePaint getLowMatchPaint() {
            if (this.lowMatchPaint == null) {
                this.lowMatchPaint = this.makeTexturePaint(7);
            }
            return this.lowMatchPaint;
        }

        private TexturePaint makeTexturePaint(int ovalSize) {
            BufferedImage image = new BufferedImage(5, 5, 1);
            Graphics2D imageGraphics = image.createGraphics();
            imageGraphics.setColor(this.color);
            imageGraphics.fillRect(0, 0, 5, 5);
            imageGraphics.setColor(Color.lightGray);
            imageGraphics.fillOval(0, 0, ovalSize, ovalSize);
            Rectangle rectangle = new Rectangle(0, 0, 5, 5);
            return new TexturePaint(image, rectangle);
        }
    }

    private class LinkMouseListener
    implements MouseListener {
        private LinkMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            DrawableLink selectedDrawLink = SyntenyLinkPanel.this._findLink(evt.getPoint());
            if (MouseButtonEvent.isRightMouseClick(evt)) {
                if (SyntenyLinkPanel.this.nothingSelected() && selectedDrawLink != null) {
                    this.handleDrawableLinkSelection(selectedDrawLink);
                }
                this.showPopupMenu(evt);
            } else if (MouseButtonEvent.isMiddleMouseClick(evt)) {
                Point pos1 = SyntenyLinkPanel.this.trans1.toUser(evt.getX(), 0);
                Point pos2 = SyntenyLinkPanel.this.trans2.toUser(evt.getX(), 0);
                SyntenyLinkPanel.this.setPanelCentres(pos1, pos2, SyntenyLinkPanel.this.autoStraighten);
            } else if (MouseButtonEvent.isLeftMouseClick(evt)) {
                SyntenyLinkPanel.this.deselectLinks();
                if (selectedDrawLink != null) {
                    this.handleDrawableLinkSelection(selectedDrawLink);
                    boolean straighten = false;
                    Point pos1 = selectedDrawLink.getQueryMidUserPoint();
                    Point pos2 = selectedDrawLink.getHitMidUserPoint();
                    SyntenyLinkPanel.this.setPanelCentres(pos1, pos2, straighten);
                }
            }
            SyntenyLinkPanel.this.repaint();
        }

        private void handleDrawableLinkSelection(DrawableLink drawableLink) {
            Link selectedLink = drawableLink.getLink();
            SyntenyLinkPanel.this.addToSelection(selectedLink);
            if (SyntenyLinkPanel.this.links.linkedByName()) {
                if (drawableLink.hasNames()) {
                    this.handleLinkNameSelection(selectedLink);
                } else {
                    SyntenyLinkPanel.this.fireSelectionForSeqHighlight(drawableLink);
                }
            } else {
                this.fireFeatureSelectionEvent(selectedLink.getSpeciesFeature1());
                this.fireFeatureSelectionEvent(selectedLink.getSpeciesFeature2());
            }
        }

        private void fireFeatureSelectionEvent(SeqFeatureI feat) {
            SelectionManager s = SyntenyLinkPanel.this.getSelectionManagerForFeature(feat);
            s.select(feat, (Object)this);
        }

        private void handleLinkNameSelection(Link link) {
            String[] geneNameArray = new String[]{link.getName1(), link.getName2()};
            SyntenyLinkPanel.this.fireNamedFeatureSelectionEvent(this, null, geneNameArray);
        }

        private void showPopupMenu(MouseEvent evt) {
            SyntenyLinkMenu popup = new SyntenyLinkMenu(SyntenyLinkPanel.this, SyntenyLinkPanel.this.getSelectedLinks());
            popup.show((Component)evt.getSource(), evt.getX(), evt.getY());
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }
    }
}

