/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.gui.ApolloFrame;
import apollo.gui.Controller;
import apollo.gui.detailviewers.exonviewer.BaseFineEditor;
import apollo.gui.synteny.CurationManager;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class WindowMenu
extends JMenu {
    ApolloFrame frame;

    public WindowMenu(ApolloFrame frame) {
        super("Window");
        this.frame = frame;
        this.addMenuListener(new WindowMenuListener());
    }

    public void menuInit() {
        this.removeAll();
        Vector windows = Controller.getMasterController().getWindowList(this.frame);
        CurationManager cm = CurationManager.getCurationManager();
        for (int i = 0; i < cm.numberOfCurations(); ++i) {
            windows.addAll(cm.getCurationController(i).getWindowList(this.frame));
        }
        int nAdded = 0;
        int winCount = 1;
        for (int i = 0; i < windows.size(); ++i) {
            Window win = (Window)windows.elementAt(i);
            if (!win.isVisible()) continue;
            String title = win instanceof Dialog ? ((Dialog)win).getTitle() : (win instanceof Frame ? ((Frame)win).getTitle() : "Window " + winCount++);
            JMenuItem item = new JMenuItem(title);
            if (win instanceof BaseFineEditor) {
                item.setForeground(((BaseFineEditor)win).getIndicatorColor());
            }
            item.addActionListener(new MenuActionListener(win));
            this.add(item);
            ++nAdded;
        }
        if (nAdded == 0) {
            JMenuItem item = new JMenuItem("<no open windows>");
            item.setEnabled(false);
            this.add(item);
            return;
        }
    }

    private class MenuActionListener
    implements ActionListener {
        Window w;

        public MenuActionListener(Window w) {
            this.w = w;
        }

        public void actionPerformed(ActionEvent e) {
            Frame f;
            this.w.toFront();
            if (this.w instanceof Frame && (f = (Frame)this.w).getState() == 1) {
                f.setState(0);
            }
        }
    }

    private class WindowMenuListener
    implements MenuListener {
        private WindowMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
            WindowMenu.this.removeAll();
        }

        public void menuDeselected(MenuEvent e) {
            WindowMenu.this.removeAll();
        }

        public void menuSelected(MenuEvent e) {
            WindowMenu.this.menuInit();
        }
    }
}

