/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.gui.ApolloFrame;
import apollo.gui.Selection;
import apollo.gui.detailviewers.seqexport.SeqExport;
import apollo.gui.drawable.DrawableAnnotationConstants;
import apollo.gui.evidencepanel.EvidencePanelOrientationManager;
import apollo.gui.featuretree.FeatureTreeFrame;
import apollo.gui.genomemap.RevCompListener;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ViewMenu
extends JMenu
implements ActionListener,
DrawableAnnotationConstants {
    JMenuItem orientation;
    JMenuItem navigator;
    private int navigatorPosition;
    JMenuItem invertcolours;
    JMenuItem zoom;
    JMenuItem flip;
    JMenuItem resetViews;
    JCheckBoxMenuItem forward;
    JCheckBoxMenuItem reverse;
    JCheckBoxMenuItem annotations;
    JCheckBoxMenuItem controls;
    JCheckBoxMenuItem results;
    private JCheckBoxMenuItem showSites;
    JCheckBoxMenuItem scale;
    JCheckBoxMenuItem reverseComplement;
    JCheckBoxMenuItem textAvoid;
    public static JCheckBoxMenuItem tree;
    JCheckBoxMenuItem guide;
    JCheckBoxMenuItem showEdgeMatches;
    private JMenuItem newSequenceWindowMenuItem;
    ApolloFrame frame;

    public ViewMenu(ApolloFrame frame) {
        super("View");
        this.frame = frame;
        this.addMenuListener(new ViewMenuListener());
        this.menuInit();
    }

    public void menuInit() {
        this.flip = new JMenuItem("Flip strands");
        this.forward = new JCheckBoxMenuItem("Show forward strand");
        this.reverse = new JCheckBoxMenuItem("Show reverse strand");
        this.reverseComplement = new JCheckBoxMenuItem("Reverse complement");
        this.results = new JCheckBoxMenuItem("Show results");
        this.annotations = new JCheckBoxMenuItem("Show annotations");
        this.showSites = new JCheckBoxMenuItem("Show starts/stops (when zoomed in)");
        this.scale = new JCheckBoxMenuItem("Show axis");
        this.showEdgeMatches = new JCheckBoxMenuItem("Show edge matches");
        this.textAvoid = new JCheckBoxMenuItem("Avoid text overlaps");
        this.guide = new JCheckBoxMenuItem("Show guide line");
        tree = new JCheckBoxMenuItem("Show annotation tree");
        this.newSequenceWindowMenuItem = new JMenuItem("Open new sequence window");
        this.invertcolours = new JMenuItem("Invert result background color");
        this.zoom = new JMenuItem("Zoom to selected");
        this.resetViews = new JMenuItem("Reset views");
        this.controls = new JCheckBoxMenuItem("Show control panel");
        this.guide.setState(false);
        this.textAvoid.setState(true);
        this.showEdgeMatches.setState(true);
        this.showEdgeMatches.setEnabled(true);
        this.newSequenceWindowMenuItem.setEnabled(this.getActiveCurState().haveSequence());
        this.add(this.flip);
        this.add(this.reverseComplement);
        this.add(this.forward);
        this.add(this.reverse);
        this.addSeparator();
        this.add(this.results);
        this.add(this.annotations);
        this.add(this.scale);
        this.add(this.showSites);
        this.addSeparator();
        this.navigatorPosition = this.getItemCount();
        this.navigator = this.add(this.getActiveNavigationAction());
        this.add(this.controls);
        this.add(tree);
        this.add(this.newSequenceWindowMenuItem);
        this.addSeparator();
        this.add(this.showEdgeMatches);
        this.add(this.textAvoid);
        this.add(this.guide);
        this.orientation = this.add(EvidencePanelOrientationManager.getSingleton().getAction());
        this.add(this.invertcolours);
        this.addSeparator();
        this.add(this.zoom);
        this.add(this.resetViews);
        this.flip.addActionListener(this);
        tree.addActionListener(this);
        this.guide.addActionListener(this);
        this.orientation.addActionListener(this);
        this.forward.addActionListener(this);
        this.reverse.addActionListener(this);
        this.annotations.addActionListener(this);
        this.results.addActionListener(this);
        this.scale.addActionListener(this);
        this.showSites.addActionListener(this);
        this.reverseComplement.addActionListener(this);
        this.textAvoid.addActionListener(this);
        this.showEdgeMatches.addActionListener(this);
        this.invertcolours.addActionListener(this);
        this.zoom.addActionListener(this);
        this.resetViews.addActionListener(this);
        this.controls.addActionListener(this);
        this.newSequenceWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Selection sel = ViewMenu.this.getActiveCurState().getSelectionManager().getSelection();
                new SeqExport(sel, ViewMenu.this.getActiveCurState().getController());
            }
        });
        this.zoom.setMnemonic('Z');
        this.forward.setMnemonic('F');
        this.reverse.setMnemonic('R');
        this.orientation.setMnemonic('V');
        this.flip.setMnemonic('B');
        this.zoom.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.forward.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.reverse.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.orientation.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.flip.setAccelerator(KeyStroke.getKeyStroke(66, 2));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.zoom) {
            this.getSZAP().zoomToSelection();
        } else if (e.getSource() == this.resetViews) {
            this.getSZAP().resetViews();
        } else if (e.getSource() == this.forward) {
            this.getSZAP().setForwardVisible(this.forward.getState());
        } else if (e.getSource() == this.reverse) {
            this.getSZAP().setReverseVisible(this.reverse.getState());
        } else if (e.getSource() == this.annotations) {
            this.getSZAP().setAnnotationViewsVisible(this.annotations.getState());
        } else if (e.getSource() == this.controls) {
            this.getSZAP().setControlPanelVisibility(this.controls.getState());
        } else if (e.getSource() == this.results) {
            this.getSZAP().setResultViewsVisible(this.results.getState());
        } else if (e.getSource() == this.scale) {
            this.getSZAP().setScaleViewVisible(this.scale.getState());
            this.frame.repaint();
        } else if (e.getSource() == this.showSites) {
            this.getSZAP().setSiteViewVisibleOnZoom(this.showSites.getState());
        } else if (e.getSource() == this.reverseComplement) {
            this.revComp();
        } else if (e.getSource() == this.flip) {
            this.revComp(true);
            if (this.forward.getState() && !this.reverse.getState()) {
                this.getSZAP().setForwardVisible(false);
                this.forward.setState(false);
                this.getSZAP().setReverseVisible(true);
                this.reverse.setState(true);
            } else if (!this.forward.getState() && this.reverse.getState()) {
                this.getSZAP().setForwardVisible(true);
                this.forward.setState(true);
                this.getSZAP().setReverseVisible(false);
                this.reverse.setState(false);
            }
        } else if (e.getSource() == this.textAvoid) {
            this.getSZAP().setTextAvoidance(this.textAvoid.getState());
        } else if (e.getSource() == this.guide) {
            this.getSZAP().setGuideLine(this.guide.getState());
        } else if (e.getSource() == tree) {
            FeatureTreeFrame treeFrame = CurationManager.getCurationManager().getActiveCurState().getFeatureTreeFrame();
            treeFrame.setVisible(tree.getState());
            if (!tree.getState()) {
                treeFrame.removeNotify();
            } else {
                treeFrame.addWindowListener(new ItemWindowListener(tree));
            }
            if (treeFrame.getState() == 1) {
                treeFrame.setState(0);
            }
        } else if (e.getSource() == this.showEdgeMatches) {
            this.getSZAP().setEdgeMatching(this.showEdgeMatches.getState());
        } else if (e.getSource() == this.invertcolours) {
            this.invertResultBackgroundColor();
        }
    }

    private void invertColors() {
        Color tmp;
        if (this.reverseComplement.getState()) {
            tmp = Config.getCoordForeground();
            Config.getStyle().setCoordForeground(Config.getCoordRevcompColor());
            Config.getStyle().setCoordRevcompColor(tmp);
        }
        tmp = Config.getCoordForeground();
        Config.getStyle().setCoordForeground(Config.getCoordBackground());
        Config.getStyle().setSequenceColor(Config.getCoordBackground());
        Config.getStyle().setCoordBackground(tmp);
        if (this.reverseComplement.getState()) {
            tmp = Config.getCoordForeground();
            Config.getStyle().setCoordForeground(Config.getCoordRevcompColor());
            Config.getStyle().setCoordRevcompColor(tmp);
        }
        Color annotColor = Config.getStyle().getAnnotationBackground();
        annotColor = this.oppositeColor(annotColor);
        Config.getStyle().setAnnotationBackground(annotColor);
        Color annotLabelColor = Config.getStyle().getAnnotationLabelColor();
        annotLabelColor = this.oppositeColor(annotLabelColor);
        Config.getStyle().setAnnotationLabelColor(annotLabelColor);
        Color featureColor = Config.getStyle().getFeatureBackground();
        featureColor = this.oppositeColor(featureColor);
        Config.getStyle().setFeatureBackground(featureColor);
        Color featureLabelColor = Config.getStyle().getFeatureLabelColor();
        featureLabelColor = this.oppositeColor(featureLabelColor);
        Config.getStyle().setFeatureLabelColor(featureLabelColor);
        Color edgematchColor = Config.getStyle().getEdgematchColor();
        Config.getStyle().setEdgematchColor(this.oppositeColor(edgematchColor));
        this.getSZAP().setViewColours();
        this.frame.repaint();
    }

    private void invertResultBackgroundColor() {
        Color featureColor = Config.getStyle().getFeatureBackground();
        featureColor = this.oppositeColor(featureColor);
        Config.getStyle().setFeatureBackground(featureColor);
        Color featureLabelColor = Config.getStyle().getFeatureLabelColor();
        featureLabelColor = this.oppositeColor(featureLabelColor);
        Config.getStyle().setFeatureLabelColor(featureLabelColor);
        Color edgematchColor = Config.getStyle().getEdgematchColor();
        Config.getStyle().setEdgematchColor(this.oppositeColor(edgematchColor));
        this.getSZAP().setViewColours();
        this.frame.repaint();
    }

    public Color oppositeColor(Color orig) {
        int red = orig.getRed();
        int green = orig.getGreen();
        int blue = orig.getBlue();
        Color opposite = new Color(255 - red, 255 - green, 255 - blue);
        return opposite;
    }

    public void revComp() {
        this.revComp(false);
    }

    public void revComp(boolean toggleReverseComplementCheckbox) {
        if (this.getSZAP().getRevCompListener() == null) {
            this.getSZAP().setRevCompListener(new RevCompListener(){

                public void updateRevComp(boolean isRevComp) {
                    ViewMenu.this.reverseComplement.setState(isRevComp);
                    if (ViewMenu.this.reverseComplement.getState()) {
                        ViewMenu.this.reverseComplement.setForeground(Color.red);
                    } else {
                        ViewMenu.this.reverseComplement.setForeground(Color.black);
                    }
                }
            });
        }
        if (toggleReverseComplementCheckbox) {
            this.reverseComplement.setState(!this.reverseComplement.getState());
        }
        if (this.reverseComplement.getState()) {
            this.reverseComplement.setForeground(Color.red);
        } else {
            this.reverseComplement.setForeground(Color.black);
        }
        this.getSZAP().setReverseComplement(this.reverseComplement.getState());
    }

    void setHaveSequence(boolean haveSequence) {
        this.newSequenceWindowMenuItem.setEnabled(haveSequence);
    }

    private StrandedZoomableApolloPanel getSZAP() {
        return this.getActiveCurState().getSZAP();
    }

    private Action getActiveNavigationAction() {
        return this.getActiveCurState().getNavigationBar().getNavigationAction();
    }

    private GuiCurationState getActiveCurState() {
        return CurationManager.getCurationManager().getActiveCurState();
    }

    private class ViewMenuListener
    implements MenuListener {
        private ViewMenuListener() {
        }

        public void menuSelected(MenuEvent e) {
            ViewMenu.this.remove(ViewMenu.this.navigatorPosition);
            JMenuItem i = new JMenuItem(ViewMenu.this.getActiveNavigationAction());
            ViewMenu.this.navigator = ViewMenu.this.insert(i, ViewMenu.this.navigatorPosition);
            tree.setEnabled(ViewMenu.this.getActiveCurState().haveAnnots());
            ViewMenu.this.annotations.setState(ViewMenu.this.getSZAP().areAnnotationViewsVisible());
            ViewMenu.this.controls.setState(ViewMenu.this.getSZAP().isControlPanelVisible());
            ViewMenu.this.results.setState(ViewMenu.this.getSZAP().areResultViewsVisible());
            ViewMenu.this.scale.setState(ViewMenu.this.getSZAP().isScaleViewVisible());
            ViewMenu.this.showSites.setState(ViewMenu.this.getSZAP().getSiteViewVisibleOnZoom());
            ViewMenu.this.forward.setState(ViewMenu.this.getSZAP().isForwardStrandVisible());
            ViewMenu.this.reverse.setState(ViewMenu.this.getSZAP().isReverseStrandVisible());
            ViewMenu.this.reverseComplement.setState(ViewMenu.this.getSZAP().isReverseComplement());
            Color rc = ViewMenu.this.reverseComplement.getState() ? Color.red : Color.black;
            ViewMenu.this.reverseComplement.setForeground(rc);
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    private class ItemWindowListener
    extends WindowAdapter {
        JCheckBoxMenuItem item;

        public ItemWindowListener(JCheckBoxMenuItem item) {
            this.item = item;
        }

        public void windowClosing(WindowEvent e) {
            this.item.setState(false);
            ((Window)e.getSource()).removeWindowListener(this);
        }
    }
}

