/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.FeatureProperty;
import apollo.config.TierProperty;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.gui.PropertyPanel;
import apollo.gui.SliderWindow;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ThresholdMenu
extends JPopupMenu
implements ActionListener {
    PropertyPanel type_panel;
    TierProperty tier_prop;
    Hashtable threshItems = new Hashtable();
    JMenuItem collapseTier;
    ApolloDataAdapterI adapter;

    public ThresholdMenu(PropertyPanel pp, TierProperty tp, Point pos) {
        super("Pick colors");
        this.type_panel = pp;
        this.tier_prop = tp;
        this.menuInit();
    }

    public void menuInit() {
        Vector fpVect = this.tier_prop.getFeatureProperties();
        for (int i = 0; i < fpVect.size(); ++i) {
            FeatureProperty fp = (FeatureProperty)fpVect.elementAt(i);
            JMenuItem item = new JMenuItem(fp.getDisplayType());
            item.setBackground(fp.getColour());
            this.add(item);
            item.setEnabled(true);
            this.threshItems.put(item, fp);
            item.addActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)e.getSource();
            FeatureProperty fp = (FeatureProperty)this.threshItems.get(item);
            DefaultBoundedRangeModel model = new DefaultBoundedRangeModel((double)fp.getThreshold() < 0.0 ? (int)fp.getMinScore() : (int)fp.getThreshold(), 0, (int)fp.getMinScore(), (int)fp.getMaxScore());
            new SliderWindow("Set threshold (" + fp.getDisplayType() + " type)", "Threshold for type", model, this.type_panel.getLocationOnScreen());
            model.addChangeListener(new ThresholdListener(fp));
        }
    }

    class ThresholdListener
    implements ChangeListener {
        FeatureProperty fp;

        public ThresholdListener(FeatureProperty fp) {
            this.fp = fp;
        }

        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() instanceof DefaultBoundedRangeModel) {
                this.fp.setThreshold(((DefaultBoundedRangeModel)evt.getSource()).getValue());
            }
        }
    }
}

