/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.gui.TypePanel;
import apollo.gui.drawable.DrawableAnnotationConstants;
import apollo.gui.synteny.SyntenyPanel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class SyntenyViewMenu
extends JMenu
implements ActionListener,
DrawableAnnotationConstants {
    JMenuItem collapse;
    JMenuItem expand;
    JMenuItem zoom;
    JMenuItem orientation;
    JMenuItem navigator;
    JMenuItem invertcolours;
    JCheckBoxMenuItem reverseComplement;
    JCheckBoxMenuItem textAvoid;
    JCheckBoxMenuItem types;
    JCheckBoxMenuItem gcplot;
    JCheckBoxMenuItem threeD;
    JCheckBoxMenuItem outline;
    JCheckBoxMenuItem showEdgeMatches;
    JMenuItem showAllTiers;
    JMenuItem hideAllTiers;
    JFrame frame;
    SyntenyPanel sp;

    public SyntenyViewMenu(JFrame frame, SyntenyPanel sp) {
        super("View");
        this.frame = frame;
        this.sp = sp;
        this.menuInit();
    }

    public void menuInit() {
        this.collapse = new JMenuItem("Collapse all tiers");
        this.expand = new JMenuItem("Expand all tiers");
        this.zoom = new JMenuItem("Zoom to selected");
        this.invertcolours = new JMenuItem("Invert screen colours");
        this.types = new JCheckBoxMenuItem("Show types panel");
        this.gcplot = new JCheckBoxMenuItem("Show GC plot");
        this.reverseComplement = new JCheckBoxMenuItem("Reverse complement");
        this.textAvoid = new JCheckBoxMenuItem("Avoid text overlaps");
        this.threeD = new JCheckBoxMenuItem("Draw 3D rectangles");
        this.outline = new JCheckBoxMenuItem("Draw outline rectangles");
        this.showEdgeMatches = new JCheckBoxMenuItem("Show edge matches");
        this.showAllTiers = new JMenuItem("Show all tiers");
        this.hideAllTiers = new JMenuItem("Hide all tiers");
        this.types.setState(false);
        this.gcplot.setState(false);
        this.textAvoid.setState(true);
        this.threeD.setState(Config.getDraw3D());
        this.outline.setState(Config.getDrawOutline());
        this.reverseComplement.setState(false);
        this.showEdgeMatches.setState(true);
        this.showEdgeMatches.setEnabled(true);
        this.add(this.reverseComplement);
        this.addSeparator();
        this.add(this.zoom);
        this.add(this.types);
        this.add(this.showEdgeMatches);
        this.add(this.textAvoid);
        this.add(this.gcplot);
        this.addSeparator();
        this.add(this.collapse);
        this.add(this.expand);
        this.add(this.showAllTiers);
        this.add(this.hideAllTiers);
        this.addSeparator();
        this.add(this.invertcolours);
        this.add(this.threeD);
        this.add(this.outline);
        this.collapse.addActionListener(this);
        this.expand.addActionListener(this);
        this.zoom.addActionListener(this);
        this.types.addActionListener(this);
        this.gcplot.addActionListener(this);
        this.reverseComplement.addActionListener(this);
        this.textAvoid.addActionListener(this);
        this.showEdgeMatches.addActionListener(this);
        this.showAllTiers.addActionListener(this);
        this.hideAllTiers.addActionListener(this);
        this.invertcolours.addActionListener(this);
        this.threeD.addActionListener(this);
        this.outline.addActionListener(this);
        this.collapse.setMnemonic('C');
        this.expand.setMnemonic('E');
        this.zoom.setMnemonic('Z');
        this.collapse.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.expand.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.zoom.setAccelerator(KeyStroke.getKeyStroke(90, 2));
    }

    private TypePanel getTypePanel() {
        return TypePanel.getTypePanelInstance();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.zoom) {
            this.sp.zoomToSelection();
        } else if (e.getSource() == this.types) {
            this.getTypePanel().setVisible(this.types.getState());
            this.getTypePanel().addWindowListener(new ItemWindowListener(this.types));
        } else {
            System.out.println("Unhandled menu item");
        }
    }

    class ItemWindowListener
    extends WindowAdapter {
        JCheckBoxMenuItem item;

        public ItemWindowListener(JCheckBoxMenuItem item) {
            this.item = item;
        }

        public void windowClosing(WindowEvent e) {
            this.item.setState(false);
            ((Window)e.getSource()).removeWindowListener(this);
        }
    }
}

