/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.config.PeptideStatus;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.editor.AnnotSessionDoneEvent;
import apollo.gui.Controller;
import apollo.gui.synteny.GuiCurationState;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PeptideMenu
extends JMenu
implements ActionListener {
    private AnnotatedFeatureI gene;
    private GuiCurationState curationState;

    public PeptideMenu(GuiCurationState curState) {
        this.curationState = curState;
    }

    public void setGene(AnnotatedFeatureI g) {
        this.gene = g;
        if (g == null) {
            return;
        }
        if (!g.isProteinCodingGene()) {
            this.setText("NOT A PEPTIDE");
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            Hashtable curator_values = Config.getPeptideStates();
            String pep_status = g.getProperty("sp_status");
            PeptideStatus this_status = Config.getPeptideStatus(pep_status);
            JMenuItem item = new JMenuItem(this_status.getText());
            this.add(item);
            item.addActionListener(this);
            Enumeration e = curator_values.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                PeptideStatus a_status = (PeptideStatus)curator_values.get(key);
                if (a_status.getPrecedence() < this_status.getPrecedence() || a_status.getText().equals(this_status.getText()) || !a_status.getCurated()) continue;
                item = new JMenuItem(a_status.getText());
                this.add(item);
                item.addActionListener(this);
            }
            this.setText(this_status.getText());
        }
    }

    private Controller getController() {
        return this.curationState.getController();
    }

    void clear() {
        this.gene = null;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem item = (JMenuItem)e.getSource();
        this.gene.addProperty("sp_status", item.getText());
        AnnotSessionDoneEvent de = new AnnotSessionDoneEvent(this);
        this.getController().handleAnnotationChangeEvent(de);
    }
}

