/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SequenceI;
import apollo.gui.ApolloFrame;
import apollo.gui.synteny.CompositeApolloFrame;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.gui.synteny.SyntenyPanel;
import apollo.main.DataLoader;
import apollo.main.LoadUtil;
import apollo.seq.io.FastaFile;
import apollo.util.ExampleFileFilter;
import gov.sandia.postscript.PSGrBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FileMenu
extends JMenu
implements ActionListener {
    JMenuItem open;
    JMenuItem addon;
    JMenuItem save;
    JMenuItem saveAll;
    JMenuItem saveAs;
    JMenuItem saveFasta;
    JMenuItem writeTypes;
    JMenuItem print;
    JMenuItem quit;
    ApolloFrame frame;
    private static Object[] quit_options = new Object[]{"Quit anyway", "Save first, then quit", "Cancel"};

    public FileMenu(ApolloFrame frame) {
        super("File");
        this.frame = frame;
        this.addMenuListener(new FileMenuListener());
        this.buildMenu();
        this.menuInit();
    }

    public void buildMenu() {
        this.open = new JMenuItem("Open new...");
        this.addon = new JMenuItem("Layer more results or annotations...");
        this.save = new JMenuItem("Save");
        this.saveAs = new JMenuItem("Save as...");
        this.saveFasta = new JMenuItem("Save sequence...");
        this.writeTypes = new JMenuItem("Save type preferences...");
        this.quit = new JMenuItem("Quit");
        this.print = new JMenuItem("Print to file...");
        this.open.addActionListener(this);
        this.addon.addActionListener(this);
        this.save.addActionListener(this);
        this.saveAs.addActionListener(this);
        this.saveFasta.addActionListener(this);
        this.writeTypes.addActionListener(this);
        this.quit.addActionListener(this);
        this.print.addActionListener(this);
        this.open.setMnemonic('O');
        this.save.setMnemonic('S');
        this.saveAs.setMnemonic('A');
        this.quit.setMnemonic('Q');
        this.open.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        if (Config.isEditingEnabled()) {
            this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        }
        this.saveAs.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.quit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
    }

    public void menuInit() {
        this.removeAll();
        this.add(this.open);
        if (Config.dataAdapterIsAvailable(ApolloDataAdapterI.OP_APPEND_DATA)) {
            this.add(this.addon);
        }
        this.addSeparator();
        if (Config.isEditingEnabled()) {
            this.add(this.save);
            this.save.setVisible(false);
        }
        this.add(this.saveAs);
        this.add(this.saveFasta);
        this.add(this.writeTypes);
        this.addSeparator();
        this.add(this.print);
        this.addSeparator();
        this.add(this.quit);
        boolean allowSave = this.getCurationManager().getDataAdapter().canWriteData();
        CurationSet curation = this.getActiveCurState().getCurationSet();
        if (curation == null) {
            this.saveFasta.setEnabled(false);
        } else {
            this.saveFasta.setEnabled(curation.isSequenceAvailable(curation.getEnd()));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quit) {
            if (LoadUtil.confirmSaved(quit_options, new DataLoader())) {
                System.exit(0);
            }
        } else if (e.getSource() == this.save) {
            DataLoader loader = new DataLoader();
            JDialog saveDialog = new JDialog((Frame)this.frame, "Saving data...");
            saveDialog.setLocationRelativeTo(this.frame);
            JPanel p = new JPanel();
            p.setPreferredSize(new Dimension(200, 10));
            saveDialog.getContentPane().add(p);
            saveDialog.pack();
            saveDialog.show();
            loader.putCurationSet(this.getActiveCurState().getDataAdapter(), this.getActiveCurState().getCurationSet());
            saveDialog.hide();
            saveDialog.dispose();
        } else if (e.getSource() == this.saveAll) {
            DataLoader loader = new DataLoader();
            loader.saveCompositeDataHolder(this.getCurationManager().getDataAdapter(), this.getCurationManager().getCompositeDataHolder());
        } else if (e.getSource() == this.saveAs) {
            DataLoader loader = new DataLoader();
            loader.saveFileDialog(this.getCurationManager().getCompositeDataHolder());
        } else if (e.getSource() == this.print) {
            this.print();
        } else if (e.getSource() == this.open) {
            LoadUtil.loadWithProgress(this.frame, new String[0], true);
        } else if (e.getSource() == this.addon) {
            LoadUtil.loadWithProgress(this.frame, new String[0], false);
        } else if (e.getSource() == this.saveFasta) {
            this.saveFastaFile();
        } else if (e.getSource() == this.writeTypes) {
            try {
                String suggestedName = this.suggestTiersFileName();
                JFileChooser chooser = new JFileChooser(suggestedName);
                chooser.setSelectedFile(new File(suggestedName));
                chooser.setDialogTitle("Save tiers file");
                int result = chooser.showSaveDialog(this.frame);
                if (result == 0) {
                    Config.getPropertyScheme().write(chooser.getSelectedFile());
                    String m = "Saved types to " + chooser.getSelectedFile() + "\n";
                    if (!chooser.getSelectedFile().toString().equals(suggestedName)) {
                        m = m + "\nIf you want to use your new types next time you run Apollo, be sure to\nchange the Types parameter in " + Config.getStyle().getFileName() + "\nto '" + chooser.getSelectedFile() + "'";
                    }
                    JOptionPane.showMessageDialog(null, m);
                }
            }
            catch (Exception ex) {
                System.err.println("Failed writing types");
                ex.printStackTrace();
            }
        }
    }

    private void print() {
        try {
            final SyntenyPanel syntenyPanel = CompositeApolloFrame.getApolloFrame().getSyntenyPanel();
            if (syntenyPanel == null) {
                System.err.println("Couldn't find SyntenyPanel to print");
                return;
            }
            JFileChooser chooser = new JFileChooser();
            JPanel accPan = new JPanel();
            final JRadioButton portrait = new JRadioButton("Portrait");
            JRadioButton landscape = new JRadioButton("Landscape", true);
            ButtonGroup orientation = new ButtonGroup();
            orientation.add(portrait);
            orientation.add(landscape);
            JPanel orientPan = new JPanel();
            orientPan.setLayout(new GridLayout(2, 1));
            orientPan.add(portrait);
            orientPan.add(landscape);
            orientPan.setBorder(new TitledBorder("Orientation"));
            final JTextField scaleField = new JTextField();
            scaleField.setPreferredSize(new Dimension(50, 30));
            double scale = PSGrBase.getPSScale((Dimension)syntenyPanel.getSize(), (String)"landscape");
            scaleField.setText("" + scale);
            JLabel scaleLabel = new JLabel("Scale");
            JPanel scalePan = new JPanel();
            portrait.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    double locscale = PSGrBase.getPSScale((Dimension)syntenyPanel.getSize(), (String)(portrait.isSelected() ? "portrait" : "landscape"));
                    scaleField.setText("" + locscale);
                }
            });
            landscape.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    double locscale = PSGrBase.getPSScale((Dimension)syntenyPanel.getSize(), (String)(portrait.isSelected() ? "portrait" : "landscape"));
                    scaleField.setText("" + locscale);
                }
            });
            ComponentAdapter apca = new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    double locscale = PSGrBase.getPSScale((Dimension)syntenyPanel.getSize(), (String)(portrait.isSelected() ? "portrait" : "landscape"));
                    scaleField.setText("" + locscale);
                }
            };
            syntenyPanel.addComponentListener(apca);
            scalePan.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            scalePan.add((Component)scaleLabel, gbc);
            scalePan.add((Component)scaleField, gbc);
            accPan.setLayout(new GridLayout(2, 1));
            accPan.add(orientPan);
            accPan.add(scalePan);
            chooser.setAccessory(accPan);
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("ps");
            filter.addExtension("eps");
            filter.setDescription("Postscript files");
            chooser.setFileFilter(filter);
            int result = chooser.showDialog(this.frame, "Print to file");
            syntenyPanel.removeComponentListener(apca);
            if (result == 0) {
                String s = portrait.isSelected() ? "portrait" : "landscape";
                syntenyPanel.print(chooser.getSelectedFile(), s, scaleField.getText());
            }
        }
        catch (Exception ex) {
            System.err.println("Failed creating postscript");
            ex.printStackTrace();
        }
    }

    private String suggestTiersFileName() {
        String tiersFile = Config.getStyle().getTiersFile();
        if (tiersFile.indexOf(".apollo") > 0) {
            return tiersFile;
        }
        if (tiersFile.lastIndexOf("/") >= 0) {
            tiersFile = tiersFile.substring(tiersFile.lastIndexOf("/") + 1);
        } else if (tiersFile.lastIndexOf("\\") >= 0) {
            tiersFile = tiersFile.substring(tiersFile.lastIndexOf("\\") + 1);
        }
        String homeDotApolloDir = System.getProperty("user.home") + "/.apollo/";
        tiersFile = homeDotApolloDir + tiersFile;
        return tiersFile;
    }

    private void saveFastaFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Save whole sequence in FASTA format");
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (file == null) {
                JOptionPane.showMessageDialog(null, "No file selected");
                return;
            }
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(this.getFasta());
                writer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Couldn't write sequence to " + file);
            }
            System.out.println("Saved sequence to " + file);
        }
    }

    private String getFasta() {
        CurationSet curation = this.getActiveCurState().getCurationSet();
        SequenceI seq = curation.getRefSequence();
        String header = ">" + Config.getDisplayPrefs().getHeader(curation) + " " + seq.getLength() + " residues\n";
        return FastaFile.format(header, seq.getResidues(), 50);
    }

    private CurationManager getCurationManager() {
        return CurationManager.getCurationManager();
    }

    private GuiCurationState getActiveCurState() {
        return this.getCurationManager().getActiveCurState();
    }

    private class FileMenuListener
    implements MenuListener {
        private FileMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            FileMenu.this.menuInit();
        }
    }
}

