/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.drawable.SiteCodon;
import java.util.HashSet;
import java.util.Hashtable;

public class Sites {
    private int[] positions;
    private HashSet selected = new HashSet(5);
    private Hashtable siteCodons = new Hashtable(3);
    static int initialSize = 100;
    static int growAmount = 100;
    int nSite = 0;
    int currentSize = initialSize;

    public Sites() {
        this.clearSites();
    }

    public void addSite(int pos) {
        if (this.nSite == this.currentSize - 1) {
            int[] tmpPos = new int[this.currentSize + growAmount];
            System.arraycopy(this.positions, 0, tmpPos, 0, this.currentSize);
            this.currentSize += growAmount;
            this.positions = tmpPos;
        }
        this.positions[this.nSite++] = pos;
    }

    public int size() {
        return this.nSite;
    }

    public int elementAt(int ind) {
        if (ind >= 0 && ind < this.nSite) {
            return this.positions[ind];
        }
        System.err.println("Index " + ind + " not valid in Sites");
        return -1;
    }

    void clearPositions() {
        this.positions = new int[initialSize];
        this.nSite = 0;
        this.currentSize = initialSize;
    }

    public void clearSites() {
        this.clearPositions();
        this.selected.clear();
    }

    public void selectSite(int pos, boolean state) {
        if (state) {
            this.selected.add(new Integer(pos));
        } else {
            this.selected.remove(new Integer(pos));
        }
    }

    boolean siteExistsAtPosition(int position) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.elementAt(i) != position) continue;
            return true;
        }
        return false;
    }

    boolean isSelected(int pos) {
        return this.selected.contains(new Integer(pos));
    }

    public void clearSelected() {
        this.selected.clear();
    }

    public SiteCodon getSiteCodon(SeqFeatureI sf) {
        return this.getSiteCodon(sf.getName());
    }

    public SiteCodon getSiteCodon(String name) {
        return (SiteCodon)this.siteCodons.get(name);
    }

    public SiteCodon getSiteCodon(int low, int high, String type, int strand, String namePrefix) {
        String name = namePrefix + " at " + low;
        SiteCodon site = this.getSiteCodon(name);
        if (site == null) {
            SeqFeature sf = new SeqFeature(low, high, type, strand);
            sf.setName(name);
            sf.setScore(100.0);
            site = new SiteCodon(sf, this);
            this.siteCodons.put(sf.getName(), site);
        }
        return site;
    }
}

