/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.event.MouseButtonEvent;
import apollo.gui.event.RubberbandEvent;
import apollo.gui.event.RubberbandListener;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public abstract class Rubberband
implements MouseListener,
MouseMotionListener {
    protected Point anchorPt = new Point(0, 0);
    protected Point stretchedPt = new Point(0, 0);
    protected Point lastPt = new Point(0, 0);
    protected Point endPt = new Point(0, 0);
    private Component component;
    private boolean firstStretch = true;
    private boolean active = false;
    private int modifiers;
    Vector listeners;

    public abstract void drawLast(Graphics var1);

    public abstract void drawNext(Graphics var1);

    public Rubberband() {
    }

    public Rubberband(Component c) {
        this.listeners = new Vector();
        this.setComponent(c);
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public boolean isRbButton(MouseEvent e) {
        return MouseButtonEvent.isMiddleMouseClick(e);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component c) {
        this.component = c;
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void mousePressed(MouseEvent event) {
        if (this.isActive() && this.isRbButton(event)) {
            this.anchor(event.getPoint());
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
        if (this.isActive() && this.isRbButton(event)) {
            this.setModifiers(event.getModifiers());
            this.end(event.getPoint());
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this.isActive() && this.isRbButton(event)) {
            this.stretch(event.getPoint());
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public boolean isActive() {
        return this.active;
    }

    public Point getAnchor() {
        return this.anchorPt;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Point getStretched() {
        return this.stretchedPt;
    }

    public Point getLast() {
        return this.lastPt;
    }

    public Point getEnd() {
        return this.endPt;
    }

    public void anchor(Point p) {
        this.firstStretch = true;
        this.anchorPt.x = p.x;
        this.anchorPt.y = p.y;
        this.stretchedPt.x = this.lastPt.x = this.anchorPt.x;
        this.stretchedPt.y = this.lastPt.y = this.anchorPt.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stretch(Point p) {
        this.lastPt.x = this.stretchedPt.x;
        this.lastPt.y = this.stretchedPt.y;
        this.stretchedPt.x = p.x;
        this.stretchedPt.y = p.y;
        Graphics g = this.component.getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.component.getBackground());
                if (this.firstStretch) {
                    this.firstStretch = false;
                } else {
                    this.drawLast(g);
                }
                this.drawNext(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Point p) {
        this.lastPt.x = this.endPt.x = p.x;
        this.lastPt.y = this.endPt.y = p.y;
        Graphics g = this.component.getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.component.getBackground());
                this.drawLast(g);
                Object var4_3 = null;
                g.dispose();
                if (!this.firstStretch) {
                    this.fireRubberbandEvent(new RubberbandEvent(this, this.getBounds()));
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                g.dispose();
                if (!this.firstStretch) {
                    this.fireRubberbandEvent(new RubberbandEvent(this, this.getBounds()));
                }
                throw throwable;
            }
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.stretchedPt.x < this.anchorPt.x ? this.stretchedPt.x : this.anchorPt.x, this.stretchedPt.y < this.anchorPt.y ? this.stretchedPt.y : this.anchorPt.y, Math.abs(this.stretchedPt.x - this.anchorPt.x), Math.abs(this.stretchedPt.y - this.anchorPt.y));
    }

    public Rectangle lastBounds() {
        return new Rectangle(this.lastPt.x < this.anchorPt.x ? this.lastPt.x : this.anchorPt.x, this.lastPt.y < this.anchorPt.y ? this.lastPt.y : this.anchorPt.y, Math.abs(this.lastPt.x - this.anchorPt.x), Math.abs(this.lastPt.y - this.anchorPt.y));
    }

    public void addListener(RubberbandListener l) {
        this.listeners.addElement(l);
    }

    public void removeListener(RubberbandListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    public void fireRubberbandEvent(RubberbandEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            RubberbandListener l = (RubberbandListener)this.listeners.elementAt(i);
            l.handleRubberbandEvent(evt);
        }
    }
}

