/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationEditor;
import apollo.editor.ResultChangeEvent;
import apollo.editor.ResultChangeListener;
import apollo.gui.Selection;
import apollo.gui.SelectionManager;
import apollo.gui.genomemap.AnnotationView;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.FeatureView;
import apollo.gui.genomemap.KeyViewI;
import apollo.gui.menus.TierPopupMenu;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class ResultView
extends FeatureView
implements KeyViewI,
ResultChangeListener {
    protected AnnotationView annotationView;
    private TierPopupMenu tierPopupMenu;

    public ResultView(JComponent ap, String name, SelectionManager selectionManager) {
        super(ap, name, selectionManager);
    }

    public void setAnnotationView(AnnotationView av) {
        this.annotationView = av;
    }

    public AnnotationView getAnnotationView() {
        return this.annotationView;
    }

    public FeatureSetI getTopModel() {
        if (this.dfset != null) {
            return this.dfset.getFeatureSet();
        }
        return null;
    }

    protected JPopupMenu createPopupMenu(ApolloPanelI ap, MouseEvent evt) {
        if (this.tierPopupMenu != null) {
            this.tierPopupMenu.clear();
        }
        this.tierPopupMenu = new TierPopupMenu(ap, this, ap.getSelection(), new Point(evt.getX(), evt.getY()));
        return this.tierPopupMenu;
    }

    protected void clear(boolean justFeatures) {
        super.clear(justFeatures);
        if (this.tierPopupMenu != null) {
            this.tierPopupMenu.clear();
        }
        this.tierPopupMenu = null;
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            AnnotationEditor editor = this.annotationView.getAnnotationEditor();
            if (editor == null) {
                System.err.println("Null editor in keyPressed");
            } else {
                Selection our_selections = this.getViewSelection(this.selectionManager.getSelection());
                if (our_selections.size() > 0) {
                    editor.setSelections(this.annotationView, our_selections, new Vector());
                    editor.addGeneOrTranscript();
                }
            }
        }
    }

    public boolean handleResultChangeEvent(ResultChangeEvent evt) {
        SeqFeatureI top_sf = evt.getChangeTop();
        if (top_sf != null) {
            if (top_sf.getStrand() == this.getStrand() || top_sf.getStrand() == 0) {
                if (!evt.isEndOfEditSession()) {
                    this.dfset.repairFeatureSet(evt);
                } else {
                    this.manager.doLayoutTiers();
                    this.setInvalidity(true);
                }
            }
        } else {
            System.out.println("Ignoring INVALID (null pointer for top) feature change in " + this.getName());
            try {
                throw new Exception("Where is this from??");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

