/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.dataadapter.StateInformation;
import apollo.datamodel.CurationSet;
import apollo.gui.ApolloFrame;
import apollo.gui.ChromosomeField;
import apollo.gui.ControlledObjectI;
import apollo.gui.ControlledPanel;
import apollo.gui.Controller;
import apollo.gui.synteny.GuiCurationState;
import apollo.main.LoadUtil;
import apollo.util.NumericKeyFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NavigationBar
extends ControlledPanel
implements ActionListener,
ControlledObjectI,
DataLoadListener {
    Font font;
    private GuiCurationState curationState;
    JButton leftButton;
    JButton rightButton;
    JTextField startField;
    JTextField endField;
    ChromosomeField chrField;
    JButton loadButton;
    JButton expandButton;
    private NavigatorManager navigatorManager;

    public NavigationBar(GuiCurationState cs) {
        this.curationState = cs;
        this.curationState.getController().addListener(this);
        this.initGui();
        this.updateFields();
    }

    private void initGui() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.leftButton = new JButton("<");
        this.rightButton = new JButton(">");
        JLabel startLabel = new JLabel("Start");
        this.startField = new JTextField();
        this.startField.addKeyListener(NumericKeyFilter.getFilter());
        this.startField.setPreferredSize(new Dimension(80, 25));
        JLabel endLabel = new JLabel("End");
        this.endField = new JTextField();
        this.endField.addKeyListener(NumericKeyFilter.getFilter());
        this.endField.setPreferredSize(new Dimension(80, 25));
        JLabel chrLabel = new JLabel("Chromosome");
        this.chrField = new ChromosomeField();
        this.loadButton = new JButton("Load");
        this.expandButton = new JButton("Expand");
        JPanel pan1 = new JPanel();
        pan1.setLayout(new FlowLayout());
        pan1.add(chrLabel);
        pan1.add(this.chrField.getComponent());
        pan1.add(this.leftButton);
        pan1.add(startLabel);
        pan1.add(this.startField);
        pan1.add(endLabel);
        pan1.add(this.endField);
        pan1.add(this.rightButton);
        pan1.add(this.expandButton);
        pan1.add(this.loadButton);
        this.add((Component)pan1, "Center");
        this.leftButton.addActionListener(this);
        this.rightButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.expandButton.addActionListener(this);
        this.startField.addActionListener(this);
        this.endField.addActionListener(this);
        this.chrField.addActionListener(this);
        this.loadButton.setEnabled(false);
        this.startField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NavigationBar.this.loadButton.setEnabled(true);
            }
        });
        this.endField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NavigationBar.this.loadButton.setEnabled(true);
            }
        });
        JComponent chrChooser = this.chrField.getComponent();
        if (chrChooser instanceof JComboBox) {
            ((JComboBox)chrChooser).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NavigationBar.this.loadButton.setEnabled(true);
                }
            });
        } else if (chrChooser instanceof JTextField) {
            ((JTextField)chrChooser).addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    NavigationBar.this.loadButton.setEnabled(true);
                }
            });
        }
        this.setMinimumSize(new Dimension(150, 30));
        this.setPreferredSize(new Dimension(300, 30));
        this.navigatorManager = new NavigatorManager();
        this.navigatorManager.setEnabled(Config.isNavigationManagerEnabled());
    }

    private void updateFields() {
        if (this.chrField.styleChanged()) {
            this.initGui();
        }
        if (this.getCurSet() == null) {
            System.err.println("Programmer error. NavigationBar CurSet is null.");
            return;
        }
        this.chrField.setChromosome(this.getCurSet().getChromosome());
        this.startField.setText("" + this.getCurSet().getStart());
        this.endField.setText("" + this.getCurSet().getEnd());
    }

    public void actionPerformed(ActionEvent evt) {
        StateInformation props = new StateInformation();
        ApolloDataAdapterI oldAdapter = this.curationState.getDataAdapter();
        if (oldAdapter == null) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can't load requested region", "Warning", 2);
            return;
        }
        Properties oldAdapterProps = oldAdapter.getStateInformation();
        Enumeration<?> enu = oldAdapterProps.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            props.put(key, oldAdapterProps.getProperty(key));
        }
        if (this.getCurSet() == null) {
            return;
        }
        String chr = this.getCurSet().getChromosome();
        int start = this.readNumberField(this.startField);
        int end = this.readNumberField(this.endField);
        int width = end - start;
        boolean doLoad = false;
        if (evt.getSource() == this.leftButton) {
            end = start;
            start -= width;
        } else if (evt.getSource() == this.rightButton) {
            start = end;
            end += width;
        } else if (evt.getSource() == this.loadButton || evt.getSource() == this.chrField.getComponent() || evt.getSource() == this.startField || evt.getSource() == this.endField) {
            chr = this.chrField.getChromosome();
            start = this.readNumberField(this.startField);
            end = this.readNumberField(this.endField);
            doLoad = true;
        } else if (evt.getSource() == this.expandButton) {
            start -= width / 4;
            end += width / 4;
        }
        if (start < 1) {
            start = 1;
        }
        if (end < 1) {
            end = 1;
        }
        this.leftButton.setEnabled(start != 1);
        this.chrField.setChromosome(chr);
        this.startField.setText(String.valueOf(start));
        this.endField.setText(String.valueOf(end));
        this.loadButton.setEnabled(true);
        if (doLoad) {
            String error = null;
            if (this.getCurSet() != null && this.getCurSet().getChromosome() != null && this.getCurSet().getChromosome().equals(chr) && this.getCurSet().getStart() == start && this.getCurSet().getEnd() == end) {
                error = "Region already loaded";
            } else if (chr == null || chr.equals("")) {
                error = "No chromosome selected";
            } else if (start >= end) {
                error = "Start >= End";
            }
            if (error != null) {
                error = error + "\nLoad cancelled";
                JOptionPane.showMessageDialog(this.getFrame(), error, "Warning", 2);
            } else {
                this.loadButton.setEnabled(false);
                String rangeString = "Chr " + chr + " " + start + " " + end;
                props.put("region", rangeString);
                props.put("adapter", oldAdapter.getClass().getName());
                props.put("Input Type", DataInputType.BASEPAIR_RANGE.toString());
                props.put("InputString", rangeString);
                this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                LoadUtil.loadWithProgress(this.getFrame(), props, true);
            }
        }
    }

    private int readNumberField(JTextField field) {
        int val = field.getText() == null || field.getText().equals("") ? 1 : Integer.parseInt(field.getText());
        return val;
    }

    private CurationSet getCurSet() {
        return this.curationState.getCurationSet();
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public Font getFont() {
        return this.font;
    }

    public void setController(Controller controller) {
    }

    public Controller getController() {
        return this.curationState.getController();
    }

    public boolean handleDataLoadEvent(DataLoadEvent evt) {
        if (!evt.dataRetrievalDone()) {
            return false;
        }
        if (this.getCurSet().getStart() == 1) {
            this.leftButton.setEnabled(false);
        } else {
            this.leftButton.setEnabled(true);
        }
        this.updateFields();
        this.loadButton.setEnabled(false);
        return true;
    }

    private ApolloFrame getFrame() {
        return ApolloFrame.getApolloFrame();
    }

    public Action getNavigationAction() {
        return this.navigatorManager.getAction();
    }

    private class NavigatorManager {
        private NavigationAction action = new NavigationAction(this.getNavigationMenuString());

        private NavigatorManager() {
            this.action.setEnabled(true);
        }

        private Action getAction() {
            return this.action;
        }

        private String getNavigationMenuString() {
            if (NavigationBar.this.isVisible()) {
                return "Hide navigation bar";
            }
            return "Show navigation bar";
        }

        private void setNavVisible(boolean state) {
            NavigationBar.this.setVisible(state);
            this.action.putValue("Name", this.getNavigationMenuString());
        }

        private void setEnabled(boolean state) {
            if (state) {
                this.action.setEnabled(true);
                this.setNavVisible(true);
            } else {
                this.setNavVisible(false);
                this.action.setEnabled(false);
            }
        }

        private class NavigationAction
        extends AbstractAction {
            private NavigationAction(String name) {
                super(name);
            }

            public void actionPerformed(ActionEvent evt) {
                if (NavigationBar.this.isVisible()) {
                    NavigatorManager.this.setNavVisible(false);
                } else {
                    NavigatorManager.this.setNavVisible(true);
                }
            }
        }
    }
}

