/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.Transformer;
import apollo.gui.event.ViewEvent;
import apollo.gui.event.ViewListener;
import apollo.gui.genomemap.ApolloPanel;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.ViewI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class LinearView
implements ViewI {
    protected JComponent apollo_panel;
    protected Transformer transformer;
    protected Graphics graphics;
    private String name;
    private boolean invalid;
    private Vector viewListeners = new Vector();
    protected Color backgroundColour = Color.white;
    protected Color foregroundColour = Color.black;
    protected Rectangle viewBounds;
    protected boolean visible = true;
    protected boolean debug = false;
    protected boolean limitsSet = false;
    protected boolean transparent = false;
    private int strand = 1;

    public LinearView(JComponent ap, String name, boolean visible) {
        this.init(ap, name, visible);
    }

    protected void init(JComponent ap, String name, boolean visible) {
        this.setVisible(visible);
        this.setComponent(ap);
        this.viewBounds = new Rectangle(1, 1, 1, 1);
        this.transformer = new Transformer(this.viewBounds);
        this.transformer.setYRange(new int[]{-10000, 10000});
        this.transformer.setXCentre(0);
        this.transformer.setYCentre(0);
        this.setName(name);
    }

    public void setComponent(JComponent ap) {
        this.apollo_panel = ap;
    }

    public JComponent getComponent() {
        return this.apollo_panel;
    }

    public void setInvalidity(boolean state) {
        this.invalid = state;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setBounds(Rectangle rect) {
        this.viewBounds = new Rectangle(rect);
        this.setDrawBounds(this.viewBounds);
    }

    public Rectangle getBounds() {
        return this.viewBounds;
    }

    public Rectangle getDrawBounds() {
        return this.transformer.getPixelBounds();
    }

    public void setDrawBounds(Rectangle rect) {
        this.transformer.setPixelBounds(rect);
    }

    public void setName(String name) {
        this.name = new String(name);
    }

    public String getName() {
        return this.name;
    }

    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
    }

    public Graphics getGraphics() {
        if (this.graphics == null) {
            Image image_buffer = ((ApolloPanelI)((Object)this.getComponent())).getBackBuffer();
            if (image_buffer != null) {
                this.graphics = image_buffer.getGraphics();
            } else {
                System.err.println("Oh oh, now what??");
            }
        }
        return this.graphics;
    }

    public void paintView() {
        System.err.println(this.getClass().getName() + " needs to implement method for paintView()");
        this.graphics.setColor(Color.white);
        if (!this.transparent) {
            this.graphics.fillRect(this.transformer.getPixelBounds().x, this.transformer.getPixelBounds().y, this.transformer.getPixelBounds().width, this.transformer.getPixelBounds().height);
        } else {
            this.graphics.drawRect(this.transformer.getPixelBounds().x, this.transformer.getPixelBounds().y, this.transformer.getPixelBounds().width, this.transformer.getPixelBounds().height);
        }
        this.graphics.setColor(Color.red);
        Point start = new Point(this.transformer.getXMinimum() + 11000, 0);
        Point end = new Point(this.transformer.getXMaximum() - 11000, 0);
        Point pixstart = this.transformer.toPixel(start);
        Point pixend = this.transformer.toPixel(end);
        this.graphics.drawLine(pixstart.x, pixstart.y, pixend.x, pixend.y);
        Point centre = new Point(this.transformer.getXVisibleRange()[0] + (this.transformer.getXVisibleRange()[1] - this.transformer.getXVisibleRange()[0]) / 2, this.transformer.getYVisibleRange()[0] + (this.transformer.getYVisibleRange()[1] - this.transformer.getYVisibleRange()[0]) / 2);
        Point pixcentre = this.transformer.toPixel(centre);
        System.out.println("Centre = " + centre);
        System.out.println("PixCentre = " + pixcentre);
        System.out.println("name = " + this.name);
        this.graphics.drawString(this.name, pixcentre.x, pixcentre.y);
        start = new Point(0, this.transformer.getYMinimum() + 1000);
        end = new Point(0, this.transformer.getYMaximum() - 1000);
        pixstart = this.transformer.toPixel(start);
        pixend = this.transformer.toPixel(end);
        this.graphics.drawLine(pixstart.x, pixstart.y, pixend.x, pixend.y);
        start = new Point(-1000, 1250);
        end = new Point(-1500, 1250);
        pixstart = this.transformer.toPixel(start);
        pixend = this.transformer.toPixel(end);
        this.graphics.drawLine(pixstart.x, pixstart.y, pixend.x, pixend.y);
        start = new Point(-1250, 1000);
        end = new Point(-1250, 1500);
        pixstart = this.transformer.toPixel(start);
        pixend = this.transformer.toPixel(end);
        this.graphics.drawLine(pixstart.x, pixstart.y, pixend.x, pixend.y);
    }

    public Transformer getTransform() {
        return this.transformer;
    }

    public void setTransform(Transformer transformer) {
        this.transformer = transformer;
    }

    public void setLimits(int[] limits) {
        this.transformer.setXRange(limits);
        this.limitsSet = true;
    }

    public boolean areLimitsSet() {
        return this.limitsSet;
    }

    public void setLimitsSet(boolean state) {
        this.limitsSet = state;
    }

    public void setMinimum(int min) {
        this.transformer.setXMinimum(min);
    }

    public void setMaximum(int max) {
        this.transformer.setXMaximum(max);
    }

    public int[] getLimits() {
        return this.transformer.getXRange();
    }

    public int getMaximum() {
        return this.transformer.getXMaximum();
    }

    public int getMinimum() {
        return this.transformer.getXMinimum();
    }

    public void setCentre(int centre) {
        this.transformer.setXCentre(centre);
    }

    public int getCentre() {
        return this.transformer.getXCentre();
    }

    public Rectangle getPreferredSize() {
        return this.getBounds();
    }

    public void setZoomFactor(double factor) {
        this.transformer.setXZoomFactor(factor);
    }

    public int[] getVisibleRange() {
        return this.transformer.getXVisibleRange();
    }

    public void setVisible(boolean state) {
        this.visible = state;
        if (this.isVisible()) {
            this.setInvalidity(true);
        }
        if (this.getComponent() != null) {
            ((ApolloPanel)this.getComponent()).setInvalidity(true);
            this.getComponent().doLayout();
            ((ApolloPanel)this.getComponent()).setInvalidity(false);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setDebug(boolean state) {
        this.debug = state;
    }

    public void addViewListener(ViewListener l) {
        this.viewListeners.addElement(l);
    }

    public void fireViewEvent(ViewEvent evt) {
        for (int i = 0; i < this.viewListeners.size(); ++i) {
            ViewListener l = (ViewListener)this.viewListeners.elementAt(i);
            l.handleViewEvent(evt);
        }
    }

    public void setBackgroundColour(Color colour) {
        this.backgroundColour = colour;
    }

    public Color getBackgroundColour() {
        return this.backgroundColour;
    }

    public void setForegroundColour(Color colour) {
        this.foregroundColour = colour;
    }

    public Color getForegroundColour() {
        return this.foregroundColour;
    }

    public void setTransparent(boolean state) {
        this.transparent = state;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void clear() {
        System.err.println(this.getClass().getName() + " needs to implement clear method");
    }

    public void setStrand(int strand) {
        this.strand = strand;
    }

    public int getStrand() {
        return this.strand;
    }

    boolean isReverseStrand() {
        return this.getStrand() == -1;
    }

    boolean isForwardStrand() {
        return this.getStrand() == 1;
    }

    protected Rectangle getSelectionRectangle(Point pnt) {
        if (this.getTransform().getXOrientation() == 1 && this.getStrand() == 1 || this.getTransform().getXOrientation() == -1 && this.getStrand() == -1) {
            return new Rectangle(pnt.x - 3, pnt.y - 1, 4, 1);
        }
        return new Rectangle(pnt.x, pnt.y, 4, 1);
    }
}

