/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.gui.ScoreCalculator;
import apollo.gui.WindowScoreCalculator;
import apollo.gui.genomemap.ScrollAdjustedView;
import java.awt.Color;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphView
extends ScrollAdjustedView
implements ChangeListener {
    ScoreCalculator calculator;
    Color plotColour = Config.getCoordForeground();

    public GraphView(JComponent ap, String name) {
        super(ap, name, false, 31);
        this.getTransform().setYOrientation(-1);
    }

    public ScoreCalculator getScoreCalculator() {
        return this.calculator;
    }

    public void clear() {
        this.setScoreCalculator(null);
    }

    public void setScoreCalculator(ScoreCalculator calc) {
        if (this.calculator != null && this.calculator instanceof WindowScoreCalculator) {
            ((WindowScoreCalculator)this.calculator).getModel().removeChangeListener(this);
        }
        this.calculator = calc;
        if (calc == null) {
            return;
        }
        int[] yrange = calc.getYRange();
        double tenpc = (double)(yrange[1] - yrange[0] + 1) / 10.0;
        if (tenpc == 0.0) {
            tenpc = 1.0;
        }
        yrange[0] = (int)((double)yrange[0] - tenpc);
        yrange[1] = (int)((double)yrange[1] + tenpc);
        this.transformer.setYRange(calc.getYRange());
        this.transformer.setXRange(calc.getXRange());
        this.setXOrientation(this.transformer.getXOrientation());
        if (this.calculator instanceof WindowScoreCalculator) {
            ((WindowScoreCalculator)this.calculator).getModel().addChangeListener(this);
        }
    }

    public void stateChanged(ChangeEvent evt) {
        WindowScoreCalculator wsc = (WindowScoreCalculator)this.calculator;
        wsc.setWinSize(wsc.getModel().getValue());
        this.getComponent().repaint();
    }

    public void paintView() {
        this.graphics.setColor(this.getBackgroundColour());
        if (!this.transparent) {
            this.graphics.fillRect(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        } else {
            this.graphics.drawRect(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        }
        if (this.calculator == null) {
            return;
        }
        this.graphics.setColor(this.getForegroundColour());
        int[] visRange = this.getVisibleRange();
        int startCoord = visRange[0];
        int endCoord = visRange[1];
        int[] yrange = this.calculator.getYRange();
        Point start = this.transformer.toPixel(new Point(visRange[0], yrange[0]));
        Point end = this.transformer.toPixel(new Point(visRange[1], yrange[0]));
        this.graphics.drawLine(start.x, start.y, end.x, end.y);
        start = this.transformer.toPixel(new Point(visRange[0], yrange[1]));
        end = this.transformer.toPixel(new Point(visRange[1], yrange[1]));
        this.graphics.drawLine(start.x, start.y, end.x, end.y);
        if (this.transformer.getXPixelsPerCoord() > 0.001) {
            int incr;
            int highPix;
            int lowPix;
            this.graphics.setColor(this.plotColour);
            if (startCoord < 1) {
                startCoord = 1;
            }
            if (endCoord > this.calculator.getXRange()[1]) {
                endCoord = this.calculator.getXRange()[1];
            }
            if (!this.reverseComplement) {
                lowPix = start.x;
                highPix = end.x;
                incr = 1;
            } else {
                lowPix = end.x;
                highPix = start.x;
                incr = -1;
            }
            int[] positions = new int[highPix - lowPix + 1];
            int nPos = 0;
            int lastX = -10;
            for (int i = start.x; i != end.x + incr; i += incr) {
                Point pos = this.transformer.toUser(i, 0);
                if (pos.x <= 1 || pos.x > this.calculator.getXRange()[1] || pos.x == lastX) continue;
                positions[nPos++] = pos.x;
                lastX = pos.x;
            }
            int[] tmpPos = new int[nPos];
            System.arraycopy(positions, 0, tmpPos, 0, nPos);
            positions = tmpPos;
            double[] scores = this.calculator.getScoresForPositions(positions);
            Point oldpnt = null;
            nPos = 0;
            lastX = -10;
            for (int i = start.x; i != end.x + incr; i += incr) {
                Point pos = this.transformer.toUser(i, 0);
                if (pos.x <= 1 || pos.x > this.calculator.getXRange()[1] || pos.x == lastX) continue;
                Point pnt = this.transformer.toPixel(new Point(positions[nPos], (int)scores[nPos++]));
                if (oldpnt != null) {
                    this.graphics.drawLine(oldpnt.x, oldpnt.y, pnt.x, pnt.y);
                    oldpnt.x = pnt.x;
                    oldpnt.y = pnt.y;
                } else {
                    oldpnt = new Point(pnt);
                }
                lastX = pos.x;
            }
        }
    }

    public void setPlotColour(Color colour) {
        this.plotColour = colour;
    }

    public Color getPlotColour() {
        return this.plotColour;
    }

    public void setXOrientation(int direction) {
        super.setXOrientation(direction);
        if (direction == 1 || direction == -1) {
            this.calculator.setXOrientation(direction);
        }
    }
}

