/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.Selection;
import apollo.gui.SelectionItem;
import apollo.gui.SelectionManager;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableSetI;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.FeatureTier;
import apollo.gui.genomemap.FeatureTierManager;
import apollo.gui.genomemap.FeatureTierManagerI;
import apollo.gui.genomemap.PopupViewI;
import apollo.gui.genomemap.SelectViewI;
import apollo.gui.genomemap.TierView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public abstract class FeatureView
extends TierView
implements PopupViewI,
SelectViewI {
    protected Dimension pickSize;
    protected DrawableSetI dfset = null;
    private int[] edges = null;
    private int lastTierNum;
    private int startTierNum;
    private boolean inTierDrag = false;
    private Color tierColour;
    protected Vector drawables = new Vector();
    private Vector selectedDrawables;
    double lastBPP = 1.0E8;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public FeatureView(JComponent ap, String name, SelectionManager selectionManager) {
        super(ap, name, selectionManager);
        this.setTransparent(false);
        this.setLeadSpaceSize(2);
        this.addScrollBar();
    }

    public void paintView() {
        super.paintView();
        if (this.inTierDrag) {
            this.drawDragRectangle(this.graphics);
        }
    }

    protected void drawDragRectangle(Graphics g) {
        int low = this.manager.toUser(this.lastTierNum);
        int high = this.manager.toUser(this.lastTierNum - 1 * this.transformer.getYOrientation());
        Point lowpos = this.transformer.toPixel(this.transformer.getXVisibleRange()[0], low);
        Point highpos = this.transformer.toPixel(this.transformer.getXVisibleRange()[1], high);
        Rectangle decBounds = this.transformer.getYOrientation() == 1 ? new Rectangle(lowpos.x, lowpos.y, highpos.x - lowpos.x, highpos.y - lowpos.y) : new Rectangle(lowpos.x, highpos.y, highpos.x - lowpos.x, lowpos.y - highpos.y);
        if (decBounds.height < 0) {
            decBounds.height = -decBounds.height;
        }
        if (decBounds.width < 0) {
            decBounds.width = -decBounds.width;
        }
        g.setColor(this.tierColour);
        g.fillRect(decBounds.x, decBounds.y, decBounds.width, decBounds.height);
    }

    public boolean beginTierDrag(MouseEvent evt) {
        int tierNum;
        Point dragStartPoint = new Point(evt.getPoint());
        Point userCoord = this.getTransform().toUser(dragStartPoint);
        this.lastTierNum = tierNum = (int)this.manager.toTier(userCoord.y);
        this.startTierNum = tierNum;
        this.tierColour = ((FeatureTier)this.manager.getTiers().elementAt(tierNum)).getColour();
        this.inTierDrag = true;
        return true;
    }

    public void updateTierDrag(MouseEvent evt) {
        Point userCoord = this.getTransform().toUser(evt.getPoint());
        int tierNum = (int)this.manager.toTier(userCoord.y);
        if (tierNum != this.lastTierNum) {
            int lowestVis = this.getLowestVisibleTier();
            int change = tierNum - this.lastTierNum;
            if (tierNum < lowestVis) {
                if (this.vscrollable && this.vScroll != null && lowestVis > 0) {
                    this.vScroll.setValue(this.manager.toUser(lowestVis + change));
                }
                tierNum += change;
            } else if (tierNum > lowestVis + this.manager.getNumVisible() - 1) {
                if (this.vscrollable && this.vScroll != null && lowestVis + this.manager.getNumVisible() < this.manager.getNumTiers()) {
                    this.vScroll.setValue(this.manager.toUser(lowestVis + change));
                }
                tierNum += change;
            }
        }
        this.lastTierNum = tierNum;
    }

    public void endTierDrag(MouseEvent evt) {
        String toType;
        String fromType = ((FeatureTierManagerI)this.manager).getTierLabel(this.startTierNum);
        if (!fromType.equals(toType = ((FeatureTierManagerI)this.manager).getTierLabel(this.lastTierNum))) {
            Config.getPropertyScheme().moveTier(fromType, toType);
        }
        this.inTierDrag = false;
    }

    protected Selection findFeaturesForSelection(Rectangle r, boolean selectParents) {
        Selection selection = new Selection();
        if (!this.isVisible()) {
            return selection;
        }
        Vector selected_drawables = this.findDrawables(r);
        this.selectedDrawables = (Vector)selected_drawables.clone();
        for (int i = 0; i < selected_drawables.size(); ++i) {
            Drawable dsf = (Drawable)selected_drawables.elementAt(i);
            if (dsf.getFeature().isAnnotTop()) {
                selectParents = false;
            }
            if (selectParents) {
                if (dsf.getRefDrawable() == null) {
                    System.out.println(dsf.getName() + " has no ref drawable " + " draw class is " + dsf.getClass().getName() + " type is " + dsf.getFeature().getFeatureType());
                } else {
                    dsf = dsf.getRefDrawable();
                }
                if (dsf.getFeature() == null) {
                    System.out.println(dsf.getName() + " ref drawable has no feature " + " draw class is " + dsf.getClass().getName() + " type is " + dsf.getFeature().getFeatureType());
                }
            }
            SelectionItem si = new SelectionItem(this, dsf.getFeature());
            si.addSelectionListener(dsf);
            selection.add(si);
        }
        return selection;
    }

    protected Vector findDrawables(Rectangle rect, boolean selected_only) {
        Vector<Drawable> matches = new Vector<Drawable>();
        if (this.visibleDrawables == null) {
            return matches;
        }
        if (this.getBounds().intersects(rect)) {
            Drawable se;
            int j;
            Vector curVis;
            int i;
            for (i = 0; i < this.visibleDrawables.size(); ++i) {
                curVis = (Vector)this.visibleDrawables.elementAt(i);
                for (j = 0; j < curVis.size(); ++j) {
                    se = (Drawable)curVis.elementAt(j);
                    if (!(se instanceof DrawableSetI)) continue;
                    DrawableSetI fset = (DrawableSetI)se;
                    for (int k = 0; k < fset.size(); ++k) {
                        Drawable se2 = fset.getDrawableAt(k);
                        if (!se2.intersects(rect, this.transformer, this.getTierManager())) continue;
                        matches.addElement(se2);
                    }
                }
            }
            if (matches.size() == 0) {
                for (i = 0; i < this.visibleDrawables.size(); ++i) {
                    curVis = (Vector)this.visibleDrawables.elementAt(i);
                    for (j = 0; j < curVis.size(); ++j) {
                        se = (Drawable)curVis.elementAt(j);
                        if (!se.intersects(rect, this.transformer, this.getTierManager())) continue;
                        matches.addElement(se);
                    }
                }
            }
        }
        return matches;
    }

    public DrawableSetI getDrawableSet() {
        return this.dfset;
    }

    public FeatureSetI getTopModel() {
        return this.dfset.getFeatureSet();
    }

    public void setDrawableSet(DrawableSetI dfset) {
        this.dfset = dfset;
        this.drawables.clear();
        if (this.dfset != null) {
            this.drawables.addElement(dfset);
            if (this.manager == null) {
                FeatureTierManager ftm = new FeatureTierManager(this.getController());
                ftm.setTransformer(this.transformer);
                this.setTierManager(ftm);
                this.setVisible(true);
            }
            this.manager.setTierData(this.drawables);
            this.setScrollValues();
            this.fireViewEvent(1);
        } else {
            System.out.println("Null fset in FeatureView");
        }
    }

    void setMatchingEdges(Selection selection, boolean state) {
        if (selection.size() == 0) {
            return;
        }
        int[] tmpEdges = this.getEdges(selection);
        if (tmpEdges.length > 0) {
            Arrays.sort(tmpEdges);
            int[] tmpEdges2 = new int[tmpEdges.length];
            int nEdge = 0;
            tmpEdges2[nEdge++] = tmpEdges[0];
            for (int i = 1; i < tmpEdges.length; ++i) {
                if (tmpEdges[i] == tmpEdges[i - 1]) continue;
                tmpEdges2[nEdge++] = tmpEdges[i];
            }
            this.edges = new int[nEdge];
            System.arraycopy(tmpEdges2, 0, this.edges, 0, nEdge);
            this.setMatchingEdges(this.edges, state);
        }
    }

    private int[] getEdges(Selection selection) {
        int[] allEdges = new int[]{};
        for (int i = 0; i < selection.size(); ++i) {
            SeqFeatureI feat = selection.getSelectedData(i);
            int[] selFeatEdges = this.getEdges(feat);
            int previousSize = allEdges.length;
            int[] tmpEdges = new int[previousSize];
            System.arraycopy(allEdges, 0, tmpEdges, 0, previousSize);
            int newArraySize = previousSize + selFeatEdges.length;
            allEdges = new int[newArraySize];
            System.arraycopy(tmpEdges, 0, allEdges, 0, tmpEdges.length);
            System.arraycopy(selFeatEdges, 0, allEdges, previousSize, selFeatEdges.length);
        }
        return allEdges;
    }

    private int[] getEdges(SeqFeatureI feat) {
        if (feat.hasKids()) {
            FeatureSetI fset = (FeatureSetI)feat;
            int[] allKidsEdges = new int[fset.getNumberOfDescendents() * 2];
            int allKidsEdgesIndex = 0;
            for (int i = 0; i < fset.size(); ++i) {
                int[] kidEdges = this.getEdges(fset.getFeatureAt(i));
                System.arraycopy(kidEdges, 0, allKidsEdges, allKidsEdgesIndex, kidEdges.length);
                allKidsEdgesIndex += kidEdges.length;
            }
            return allKidsEdges;
        }
        int[] edges = new int[]{feat.getStart(), feat.getEnd()};
        return edges;
    }

    public void setMatchingEdges(int[] edges, boolean state) {
        this.dfset.setEdgeHighlights(edges, state, this.transformer);
    }

    public void setXOrientation(int direction) {
        super.setXOrientation(direction);
        if (this.needsTextAvoidUpdate()) {
            this.manager.doLayoutTiers();
        }
        if (this.edges != null) {
            this.setMatchingEdges(this.edges, true);
        }
    }

    public void clearEdges() {
        if (this.edges != null) {
            if (this.dfset != null) {
                this.dfset.setEdgeHighlights(this.edges, false, this.transformer);
            }
            this.edges = null;
        }
    }

    public void clearHighlights() {
        if (this.dfset != null) {
            this.dfset.setHighlighted(false);
        }
    }

    public void select(Selection selection) {
        this.selectedDrawables = new Vector();
        for (int i = 0; i < selection.size(); ++i) {
            SelectionItem selItem = selection.getSelectionItem(i);
            SeqFeatureI modelFeature = selItem.getData();
            Drawable drawable = this.dfset.findDrawable(modelFeature);
            if (drawable == null) continue;
            drawable.setSelected(true);
            selItem.addSelectionListener(drawable);
            this.selectedDrawables.addElement(drawable);
        }
        this.verticalScrollToSelection();
    }

    public void verticalScrollToSelection() {
        this.verticalScrollToSelection(this.selectedDrawables);
    }

    public void verticalScrollToSelection(Vector selectedDrawables) {
        if (selectedDrawables == null || selectedDrawables.size() == 0) {
            return;
        }
        ((FeatureTierManagerI)this.manager).synchDrawablesWithTiers();
        int lowestY = 99999999;
        boolean allVisible = true;
        int selsize = selectedDrawables.size();
        for (int i = 0; i < selsize; ++i) {
            int y;
            Drawable dsf = (Drawable)selectedDrawables.elementAt(i);
            if (!this.isVerticallyVisible(dsf)) {
                allVisible = false;
            }
            if ((y = this.getTierYCentre(dsf)) >= lowestY) continue;
            lowestY = y;
        }
        if (allVisible) {
            return;
        }
        if (this.isUpOrientation()) {
            lowestY = this.getMaxScrollbarValue() - lowestY - this.vScroll.getVisibleAmount();
        }
        this.setScrollbarValue(lowestY);
    }

    protected int getTierYCentre(Drawable dsf) {
        return this.manager.getTier(dsf.getTierIndex(this.manager)).getDrawCentre();
    }

    private boolean isVerticallyVisible(Drawable dsf) {
        int y = this.getTierYCentre(dsf);
        if (this.isUpOrientation()) {
            y = this.getMaxScrollbarValue() - y;
        }
        return y > this.getScrollbarValue() && y < this.getScrollbarValue() + this.getVisibleScrollbarValue();
    }

    public void setCentre(int Position2) {
        super.setCentre(Position2);
        this.setInvalidity(true);
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        if (this.needsTextAvoidUpdate()) {
            this.manager.doLayoutTiers();
        }
        this.setInvalidity(true);
    }

    public void setZoomFactor(double factor) {
        super.setZoomFactor(factor);
        if (this.needsTextAvoidUpdate()) {
            this.manager.doLayoutTiers();
        }
        this.setInvalidity(true);
    }

    public Rectangle getPreferredSize() {
        int height = this.getDropSpaceSize() + this.getLeadSpaceSize();
        if (this.manager != null) {
            height += this.manager.getTotalHeight();
        }
        return new Rectangle(0, 0, 1, height);
    }

    public void finalize() {
    }

    public void clear() {
        this.clear(false);
    }

    public void clearFeatures() {
        this.clear(true);
    }

    protected void clear(boolean justFeatures) {
        this.dfset = null;
        this.drawables.clear();
        this.visibleDrawables = null;
        this.selectedDrawables = null;
        this.graphics = null;
        if (this.manager != null) {
            ((FeatureTierManagerI)this.manager).clearFeatures();
        }
        if (!justFeatures) {
            super.clear();
        }
    }

    public void setTextAvoidance(boolean state) {
        if (this.manager != null) {
            if (state) {
                ((FeatureTierManagerI)this.manager).setTextAvoidance(this.getTransform(), this.getGraphics());
            } else {
                ((FeatureTierManagerI)this.manager).unsetTextAvoidance();
            }
        }
    }

    protected boolean needsTextAvoidUpdate() {
        boolean flag = false;
        if (this.manager != null) {
            if (((FeatureTierManagerI)this.manager).isAvoidingTextOverlaps() && ((FeatureTierManagerI)this.manager).areAnyTiersLabeled()) {
                int textAvoidLim = Config.getTextAvoidLimit();
                if (this.transformer.getXCoordsPerPixel() < (double)textAvoidLim) {
                    flag = true;
                }
                if (this.lastBPP < (double)textAvoidLim && this.transformer.getXCoordsPerPixel() > (double)textAvoidLim) {
                    flag = true;
                }
            }
            this.lastBPP = this.transformer.getXCoordsPerPixel();
        }
        return flag;
    }

    protected abstract JPopupMenu createPopupMenu(ApolloPanelI var1, MouseEvent var2);

    public void showPopupMenu(MouseEvent evt) {
        ApolloPanelI ap = (ApolloPanelI)((Object)this.getComponent());
        JPopupMenu popup = this.createPopupMenu(ap, evt);
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = FeatureView.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this.getComponent());
        Point p = SwingUtilities.convertPoint((Component)evt.getSource(), evt.getX(), evt.getY(), frame);
        int xLoc = p.x;
        int yLoc = p.y;
        if (xLoc + popup.getPreferredSize().width > frame.getSize().width) {
            xLoc -= xLoc + popup.getPreferredSize().width - frame.getSize().width;
        }
        if (Config.verticallyMovePopups() && yLoc + popup.getPreferredSize().height > frame.getSize().height) {
            yLoc -= yLoc + popup.getPreferredSize().height - frame.getSize().height;
        }
        popup.show(frame, xLoc, yLoc);
    }

    public Selection getViewSelection(Selection selection) {
        return ((FeatureTierManagerI)this.manager).getViewSelection(selection);
    }

    protected void putScrollAtStart() {
        if (this.dfset != null) {
            super.putScrollAtStart();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

