/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropSchemeChangeEvent;
import apollo.config.PropSchemeChangeListener;
import apollo.config.PropertyScheme;
import apollo.config.TierProperty;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.Controller;
import apollo.gui.Selection;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.DrawableTierManager;
import apollo.gui.genomemap.FeatureTier;
import apollo.gui.genomemap.FeatureTierManagerI;
import apollo.gui.genomemap.FeatureView;
import apollo.util.QuickSort;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;

public class FeatureTierManager
extends DrawableTierManager
implements FeatureTierManagerI,
PropSchemeChangeListener {
    protected Vector tier_properties;
    protected boolean debug = false;
    static int maxOverlapping = 100;
    static Drawable[] feats = new DrawableSeqFeature[maxOverlapping];
    static double[] scores = new double[maxOverlapping];
    protected Transformer textTransform = null;
    protected FontMetrics fm = null;
    protected boolean textAvoidance = false;

    public FeatureTierManager(Controller c) {
        this.setController(c);
        this.tier_properties = Config.getPropertyScheme().getAllTiers();
    }

    public void setController(Controller c) {
        this.controller = c;
        if (this.controller != null) {
            this.controller.addListener(this);
        }
    }

    public boolean isExpanded(String type) {
        return Config.getPropertyScheme().getTierProperty(type).isExpanded();
    }

    public boolean isVisible(String type) {
        return Config.getPropertyScheme().getTierProperty(type).isVisible();
    }

    public int getIndexForType(String type) {
        for (int i = 0; i < this.getTiers().size(); ++i) {
            FeatureTier tier = (FeatureTier)this.getTiers().elementAt(i);
            if (!tier.getTierLabel().equalsIgnoreCase(type)) continue;
            return i;
        }
        return -1;
    }

    public void collapseTier(String tier_label) {
        Config.getPropertyScheme().getTierProperty(tier_label).setExpanded(false);
        this.doLayoutTiers();
    }

    public void expandTier(String type) {
        Config.getPropertyScheme().getTierProperty(type).setExpanded(true);
        this.doLayoutTiers();
    }

    public void setVisible(String type, boolean state) {
        Config.getPropertyScheme().getTierProperty(type).setVisible(state);
        this.doLayoutTiers();
    }

    public Vector getHiddenTiers() {
        Vector<String> hidden = new Vector<String>();
        Vector all_tiers = Config.getPropertyScheme().getAllTiers();
        for (int i = 0; i < all_tiers.size(); ++i) {
            TierProperty tp = (TierProperty)all_tiers.elementAt(i);
            if (tp.isVisible()) continue;
            hidden.addElement(tp.getLabel());
        }
        return hidden;
    }

    public boolean areAnyTiersLabeled() {
        boolean flag = false;
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tiersSize; ++i) {
            FeatureTier tier = (FeatureTier)this.tiers.elementAt(i);
            if (!tier.isLabeled()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public Vector getAllFeatures() {
        Vector<Drawable> allFeatures = new Vector<Drawable>();
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tiersSize; ++i) {
            Vector drawables = ((FeatureTier)this.tiers.elementAt(i)).getDrawables();
            int setSize = drawables.size();
            for (int j = 0; j < setSize; ++j) {
                Drawable dsf = (Drawable)drawables.elementAt(j);
                dsf.setTierIndex(i);
                allFeatures.addElement(dsf);
            }
        }
        return allFeatures;
    }

    public void synchDrawablesWithTiers() {
        int tiersSize = this.tiers.size();
        Vector<Drawable> parents = new Vector<Drawable>();
        for (int i = 0; i < tiersSize; ++i) {
            Vector drawables = ((FeatureTier)this.tiers.elementAt(i)).getDrawables();
            int setSize = drawables.size();
            for (int j = 0; j < setSize; ++j) {
                Drawable dsf = (Drawable)drawables.elementAt(j);
                dsf.setTierIndex(i);
                Drawable parent = dsf.getRefDrawable();
                if (parents.indexOf(parent) >= 0) continue;
                dsf.getRefDrawable().setTierIndex(i);
                parents.addElement(parent);
            }
        }
    }

    public void setDebug(boolean state) {
        this.debug = state;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean handlePropSchemeChangeEvent(PropSchemeChangeEvent evt) {
        this.tier_properties = evt.getPropertyScheme().getAllTiers();
        this.doLayoutTiers();
        return true;
    }

    public void fillTiers() {
        super.fillTiers();
        this.tiers = this.sortTiers();
        Vector<FeatureTier> expandedTiers = new Vector<FeatureTier>();
        int tiersSize = this.tiers.size();
        PropertyScheme scheme = Config.getPropertyScheme();
        for (int i = 0; i < tiersSize; ++i) {
            int j;
            FeatureTier feature_tier = (FeatureTier)this.tiers.elementAt(i);
            String feature_type = feature_tier.getTierLabel();
            TierProperty tp = scheme.getTierProperty(feature_type);
            if (!this.isVisible(feature_type)) continue;
            if (!tp.isExpanded()) {
                expandedTiers.addElement(feature_tier);
                continue;
            }
            Vector newTiers = new Vector();
            int tierDataSize = feature_tier.size();
            Drawable dsf = tierDataSize > 0 ? feature_tier.getDrawableAt(0) : null;
            FeatureTier new_tier = new FeatureTier();
            new_tier.setTierLabel(dsf);
            newTiers.addElement(new_tier);
            if (!tp.isSorted() && tp.isLabeled() && this.textAvoidance && this.textTransform.getXCoordsPerPixel() < (double)Config.getTextAvoidLimit()) {
                for (j = 0; j < tierDataSize; ++j) {
                    this._addWithAvoidance(feature_tier.getDrawableAt(j), 0, newTiers);
                }
            } else {
                for (j = 0; j < tierDataSize; ++j) {
                    this._add(feature_tier.getDrawableAt(j), 0, newTiers);
                }
            }
            if (tp.isSorted()) {
                Vector overlapEnds = new Vector(32);
                newTiers = this.sortTierByScore(newTiers, tp, overlapEnds);
                int[] overlapEndsArray = new int[overlapEnds.size()];
                int overlapEndsSize = overlapEnds.size();
                for (int j2 = 0; j2 < overlapEndsSize; ++j2) {
                    overlapEndsArray[j2] = (Integer)overlapEnds.elementAt(j2);
                }
                if (tp.isLabeled() && this.textAvoidance && this.textTransform.getXCoordsPerPixel() < (double)Config.getTextAvoidLimit()) {
                    newTiers = this.removeTextOverlapsFromSorted(newTiers, tp, overlapEndsArray);
                }
            }
            int newTiersSize = newTiers.size();
            for (int j3 = 0; j3 < newTiersSize; ++j3) {
                expandedTiers.addElement((FeatureTier)newTiers.elementAt(j3));
            }
        }
        this.tiers = expandedTiers;
        if (this.debug) {
            this.checkTiers();
        }
    }

    private boolean checkTiers() {
        boolean error = false;
        for (int i = 0; i < this.tiers.size(); ++i) {
            FeatureTier tier = (FeatureTier)this.tiers.elementAt(i);
            for (int j = 0; j < tier.size() - 1; ++j) {
                Drawable one = tier.getDrawableAt(j);
                for (int k = j + 1; k < tier.size(); ++k) {
                    Drawable two = tier.getDrawableAt(k);
                    if (!one.getFeature().overlaps(two.getFeature())) continue;
                    System.out.println("ERROR: Overlap in tier " + i);
                    System.out.println("\tone = " + one.getLow() + "-" + one.getHigh() + " two " + two.getLow() + " " + two.getHigh());
                    error = true;
                }
            }
        }
        return error;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.tiers.size(); ++i) {
            FeatureTier tier = (FeatureTier)this.tiers.elementAt(i);
            buff.append("Tier " + i + "\n");
            buff.append(tier);
        }
        return buff.toString();
    }

    public Vector sortTiers() {
        Vector<FeatureTier> sortedTiers = new Vector<FeatureTier>();
        int tierPropSize = this.tier_properties.size();
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tierPropSize; ++i) {
            TierProperty tier_prop = (TierProperty)this.tier_properties.elementAt(i);
            for (int j = 0; j < tiersSize; ++j) {
                FeatureTier ft = (FeatureTier)this.tiers.elementAt(j);
                FeatureProperty fp = ft.getFeatureProperty();
                if (!fp.getTier().getLabel().equalsIgnoreCase(tier_prop.getLabel())) continue;
                sortedTiers.addElement(ft);
            }
        }
        return sortedTiers;
    }

    protected void _add(Drawable dsf, int tierInd, Vector newTiers) {
        FeatureTier tier = (FeatureTier)newTiers.elementAt(tierInd);
        boolean overlaps = false;
        overlaps = this.drawableOverlaps(tier, dsf);
        if (overlaps) {
            if (++tierInd < newTiers.size()) {
                this._add(dsf, tierInd, newTiers);
            } else {
                FeatureTier t = new FeatureTier();
                t.setTierLabel(dsf);
                newTiers.addElement(t);
                t.addFeature(dsf, this.transformer);
                dsf.setTierIndex(tierInd + 1);
            }
        } else {
            tier.addFeature(dsf, this.transformer);
            dsf.setTierIndex(tierInd);
        }
    }

    protected Vector sortTierByScore(Vector oldTiers, TierProperty tp, Vector overlapEnds) {
        Vector overlap;
        int oldTiersSize = oldTiers.size();
        int[] startInds = new int[oldTiersSize];
        Vector[] oldTiersFeatures = new Vector[oldTiersSize];
        int[] oldTiersSizes = new int[oldTiersSize];
        Vector<FeatureTier> newTiers = new Vector<FeatureTier>();
        for (int i = 0; i < oldTiersSize; ++i) {
            newTiers.addElement(new FeatureTier());
            oldTiersFeatures[i] = ((FeatureTier)oldTiers.elementAt(i)).getDrawables();
            oldTiersSizes[i] = oldTiersFeatures[i].size();
        }
        while ((overlap = this.getNextOverlap(oldTiers, oldTiersSize, startInds, oldTiersFeatures, oldTiersSizes, overlapEnds)) != null) {
            this.sortOverlap(newTiers, overlap);
        }
        int maxRow = tp.getMaxRow();
        if (maxRow > 0 && newTiers.size() > maxRow) {
            newTiers.setSize(maxRow);
        }
        return newTiers;
    }

    protected Vector getNextOverlap(Vector typeTiers, int typeTiersSize, int[] startInds, Vector[] typeTiersFeatures, int[] typeTiersSizes, Vector overlapEnds) {
        Vector<Drawable> overlapFeatures = null;
        boolean hadOverlap = true;
        boolean first = true;
        int high = -1;
        while (hadOverlap) {
            hadOverlap = false;
            for (int i = 0; i < typeTiersSize; ++i) {
                Vector features = typeTiersFeatures[i];
                if (startInds[i] >= typeTiersSizes[i]) continue;
                Drawable sf = (Drawable)features.elementAt(startInds[i]);
                if (first) {
                    high = sf.getHigh();
                    first = false;
                    overlapFeatures = new Vector<Drawable>(32);
                }
                if (sf.getLow() > high) continue;
                hadOverlap = true;
                overlapFeatures.addElement(sf);
                int n = i;
                startInds[n] = startInds[n] + 1;
                int sfHigh = sf.getHigh();
                if (sfHigh <= high) continue;
                high = sfHigh;
            }
        }
        if (high > -1) {
            overlapEnds.addElement(new Integer(high));
        }
        return overlapFeatures;
    }

    protected void sortOverlap(Vector newTiers, Vector overlap) {
        int i;
        int nTier = newTiers.size();
        int nOverlapping = overlap.size();
        if (nOverlapping > maxOverlapping) {
            maxOverlapping = nOverlapping;
            feats = new DrawableSeqFeature[maxOverlapping];
            scores = new double[maxOverlapping];
        }
        overlap.copyInto(feats);
        for (int i2 = 0; i2 < nOverlapping; ++i2) {
            FeatureTierManager.scores[i2] = feats[i2].getFeature().getScore();
        }
        QuickSort.sort(scores, feats, nOverlapping);
        int nOverlappingDiv2 = nOverlapping / 2;
        for (i = 0; i < nOverlappingDiv2; ++i) {
            Drawable tmp = feats[i];
            FeatureTierManager.feats[i] = feats[nOverlapping - i - 1];
            FeatureTierManager.feats[nOverlapping - i - 1] = tmp;
        }
        for (i = nTier; i < nOverlapping; ++i) {
            newTiers.addElement(new FeatureTier());
        }
        for (i = 0; i < nOverlapping; ++i) {
            ((FeatureTier)newTiers.elementAt(i)).addFeature(feats[i], this.transformer);
        }
    }

    public void setTextAvoidance(Transformer trans, Graphics g) {
        this.fm = g.getFontMetrics();
        this.textTransform = trans;
        this.textAvoidance = true;
        this.doLayoutTiers();
    }

    public void unsetTextAvoidance() {
        this.textAvoidance = false;
        this.doLayoutTiers();
    }

    public boolean isAvoidingTextOverlaps() {
        return this.textAvoidance;
    }

    public int getTextStart(Drawable dsf) {
        int start = this.textTransform.toPixelX(dsf.getLeft(this.textTransform));
        return start;
    }

    public int getTextEnd(Drawable dsf, int start) {
        int end = start;
        String name = dsf.getDisplayLabel();
        if (name != null) {
            end += this.fm.stringWidth(name);
        }
        return end;
    }

    protected Vector removeTextOverlapsFromSorted(Vector sortedTiers, TierProperty tp, int[] overlapEnds) {
        int i;
        Vector<FeatureTier> newTiers = new Vector<FeatureTier>();
        newTiers.addElement(new FeatureTier());
        int sortedTiersSize = sortedTiers.size();
        int[] tierInds = new int[sortedTiersSize];
        int[] tierSizes = new int[sortedTiersSize];
        for (i = 0; i < sortedTiersSize; ++i) {
            tierSizes[i] = ((FeatureTier)sortedTiers.elementAt(i)).size();
        }
        for (i = 0; i < overlapEnds.length; ++i) {
            Vector<Drawable> overlapFeatures = new Vector<Drawable>();
            for (int j = 0; j < sortedTiersSize; ++j) {
                FeatureTier origTier = (FeatureTier)sortedTiers.elementAt(j);
                if (tierInds[j] >= tierSizes[j]) continue;
                Drawable dsf = origTier.getDrawableAt(tierInds[j]);
                if (dsf.getHigh() > overlapEnds[i]) break;
                overlapFeatures.addElement(dsf);
                int n = j;
                tierInds[n] = tierInds[n] + 1;
            }
            int overlapFeaturesSize = overlapFeatures.size();
            int minTier = 0;
            for (int j = 0; j < overlapFeaturesSize; ++j) {
                minTier = this._addWithAvoidance((Drawable)overlapFeatures.elementAt(j), minTier, newTiers);
                if (++minTier != newTiers.size()) continue;
                newTiers.addElement(new FeatureTier());
            }
        }
        return newTiers;
    }

    protected boolean drawableOverlaps(FeatureTier tier, Drawable dsf) {
        boolean overlaps = tier.getHigh() >= dsf.getLow();
        return overlaps;
    }

    protected int _addWithAvoidance(Drawable dsf, int tierInd, Vector newTiers) {
        FeatureTier tier = (FeatureTier)newTiers.elementAt(tierInd);
        int textStart = 0;
        int textEnd = 0;
        int tierTextEnd = 0;
        boolean overlaps = this.drawableOverlaps(tier, dsf);
        if (this.textAvoidance) {
            textStart = this.getTextStart(dsf);
            textEnd = this.getTextEnd(dsf, textStart);
            if (this.textTransform.getXOrientation() == 1) {
                if (tier.size() != 0 && tier.getTextEnd() >= textStart) {
                    overlaps = true;
                }
                tierTextEnd = textEnd;
            } else {
                if (tier.size() != 0 && tier.getTextEnd() <= textEnd) {
                    overlaps = true;
                }
                tierTextEnd = textStart;
            }
        }
        if (overlaps) {
            if (++tierInd < newTiers.size()) {
                tierInd = this._addWithAvoidance(dsf, tierInd, newTiers);
            } else {
                FeatureTier t = new FeatureTier();
                newTiers.addElement(t);
                t.addFeature(dsf, this.transformer);
                if (this.textAvoidance) {
                    t.setTextEnd(tierTextEnd);
                }
                dsf.setTierIndex(tierInd + 1);
            }
        } else {
            tier.addFeature(dsf, this.transformer);
            if (this.textAvoidance) {
                tier.setTextEnd(tierTextEnd);
            }
            dsf.setTierIndex(tierInd);
        }
        return tierInd;
    }

    public void moveTier(int from, int to) {
        Vector<TierProperty> tierTypes = new Vector<TierProperty>();
        for (int j = 0; j < this.tiers.size(); ++j) {
            FeatureTier ft = (FeatureTier)this.tiers.elementAt(j);
            FeatureProperty fp = ft.getFeatureProperty();
            tierTypes.addElement(fp.getTier());
        }
        if (from >= tierTypes.size()) {
            System.out.println("ERROR: Invalid Tier Index: " + from);
        }
        TierProperty fromFP = (TierProperty)tierTypes.elementAt(from);
        if (to >= this.tier_properties.size()) {
            System.out.println("ERROR: Invalid Tier Index: " + to);
        }
        TierProperty toFP = (TierProperty)tierTypes.elementAt(to);
        int index = this.tier_properties.indexOf(fromFP);
        if (index >= 0) {
            this.tier_properties.removeElementAt(index);
        } else {
            System.out.println("ERROR: Failed looking for from index in order");
        }
        index = this.tier_properties.indexOf(toFP);
        if (index >= 0) {
            this.tier_properties.insertElementAt(fromFP, index);
        } else {
            System.out.println("ERROR: Failed looking for to index in order");
        }
        this.doLayoutTiers();
    }

    public Selection getViewSelection(Selection selection) {
        Selection view_selection = new Selection();
        if (selection.size() > 0) {
            int tier_count = this.tiers.size();
            for (int i = 0; i < tier_count; ++i) {
                Vector drawables = ((FeatureTier)this.tiers.elementAt(i)).getDrawables();
                int featSize = drawables.size();
                for (int j = 0; j < featSize; ++j) {
                    Drawable dsf = (Drawable)drawables.elementAt(j);
                    Selection sfSel = selection.getSelectionDescendedFromModel(dsf.getFeature(), true);
                    if (selection.size() <= 0) continue;
                    view_selection.add(sfSel);
                }
            }
        }
        return view_selection;
    }

    public void collapseTier(FeatureView fv, ApolloPanelI ap) {
        Vector tier_labels = this.findTiersForTypes(fv, ap);
        for (int i = 0; i < tier_labels.size(); ++i) {
            this.collapseTier((String)tier_labels.elementAt(i));
        }
    }

    public void expandTier(FeatureView fv, ApolloPanelI ap) {
        Vector tier_labels = this.findTiersForTypes(fv, ap);
        for (int i = 0; i < tier_labels.size(); ++i) {
            this.expandTier((String)tier_labels.elementAt(i));
        }
    }

    public void hideTier(FeatureView fv, ApolloPanelI ap) {
        Vector tier_labels = this.findTiersForTypes(fv, ap);
        for (int i = 0; i < tier_labels.size(); ++i) {
            this.setVisible((String)tier_labels.elementAt(i), false);
        }
    }

    public void changeTypeColor(FeatureView view, Selection f) {
        Color color;
        SeqFeatureI sf = f.getSelectedData(f.size() - 1);
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(sf.getTopLevelType());
        if (Config.getStyle().internalMode() && Config.doUserTranscriptColouring() && fp.getDisplayType().equalsIgnoreCase("gene")) {
            String message = "Since you have UserTranscriptColoring turned on, genes are colored by owner,\nso changing the (default) gene color won't have any visible effect.";
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
        }
        if ((color = JColorChooser.showDialog(null, "Choose color for " + fp.getDisplayType() + " features", fp.getColour())) != null) {
            fp.setColour(color);
            String message = "Color changed for " + fp.getDisplayType() + "--to save this change, use 'Save type preferences' in the File menu.";
            if (Config.getConfirmOverwrite()) {
                JOptionPane.showMessageDialog(null, message, "Reminder", 2);
            } else {
                System.out.println(message);
            }
        }
    }

    public Vector findTiersForTypes(FeatureView view, ApolloPanelI ap) {
        Vector<String> tier_labels = new Vector<String>();
        FeatureSetI top = view.getTopModel();
        Selection f = ap.getSelection().getSelectionDescendedFromModel(top, false);
        PropertyScheme ps = Config.getPropertyScheme();
        for (int i = 0; i < f.size(); ++i) {
            SeqFeatureI sf = f.getSelectedData(i);
            String tier_label = ps.getTierProperty(sf.getFeatureType()).getLabel();
            if (tier_labels.contains(tier_label)) continue;
            tier_labels.addElement(tier_label);
        }
        return tier_labels;
    }

    public Vector getTierProperties() {
        return this.tier_properties;
    }
}

