/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.Selection;
import apollo.gui.genomemap.ContainerViewI;
import apollo.gui.genomemap.LinearView;
import apollo.gui.genomemap.PickViewI;
import apollo.gui.genomemap.ViewI;
import apollo.util.SwingMissingUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class ContainerView
extends LinearView
implements ContainerViewI,
PickViewI {
    protected Controller controller;
    protected Vector views = new Vector();

    public ContainerView(JComponent ap, String name, boolean visible) {
        super(ap, name, visible);
    }

    public void setController(Controller c) {
        this.controller = c;
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (!(v instanceof ControlledObjectI)) continue;
            ((ControlledObjectI)((Object)v)).setController(c);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public Object getControllerWindow() {
        return SwingMissingUtil.getWindowAncestor(this.getComponent());
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    public void paintView() {
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (!v.isVisible()) continue;
            v.paintView();
        }
    }

    public Vector getViews() {
        return this.views;
    }

    public Vector getViewsOfClass(Class c) {
        Vector<ViewI> matches = new Vector<ViewI>();
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (v instanceof ContainerViewI) {
                matches.addAll(((ContainerViewI)((Object)v)).getViewsOfClass(c));
                continue;
            }
            if (!c.isInstance(v)) continue;
            matches.addElement(v);
        }
        return matches;
    }

    public ViewI getContainedViewAt(Point p) {
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (!v.getBounds().contains(p)) continue;
            if (v instanceof ContainerViewI) {
                return ((ContainerViewI)((Object)v)).getContainedViewAt(p);
            }
            return v;
        }
        return null;
    }

    public void setInvalidity(boolean state) {
        super.setInvalidity(state);
        int view_count = this.views == null ? 0 : this.views.size();
        for (int i = 0; i < view_count; ++i) {
            ((ViewI)this.views.elementAt(i)).setInvalidity(state);
        }
    }

    public void setLimits(int[] limits) {
        super.setLimits(limits);
        for (int i = 0; i < this.views.size(); ++i) {
            ((ViewI)this.views.elementAt(i)).setLimits(limits);
        }
    }

    public void setMinimum(int min) {
        super.setMinimum(min);
        for (int i = 0; i < this.views.size(); ++i) {
            ((ViewI)this.views.elementAt(i)).setMinimum(min);
        }
    }

    public void setMaximum(int max) {
        super.setMaximum(max);
        for (int i = 0; i < this.views.size(); ++i) {
            ((ViewI)this.views.elementAt(i)).setMaximum(max);
        }
    }

    public void setDrawBounds(Rectangle rect) {
        rect = this.setScrollSpace(1);
        super.setDrawBounds(rect);
    }

    public abstract Rectangle setScrollSpace(int var1);

    public void setGraphics(Graphics g) {
        super.setGraphics(g);
        for (int i = 0; i < this.views.size(); ++i) {
            ((ViewI)this.views.elementAt(i)).setGraphics(g);
        }
    }

    public void setComponent(JComponent ap) {
        super.setComponent(ap);
        int view_count = this.views == null ? 0 : this.views.size();
        for (int i = 0; i < view_count; ++i) {
            ((ViewI)this.views.elementAt(i)).setComponent(ap);
        }
    }

    public void setCentre(int centre) {
        super.setCentre(centre);
        for (int i = 0; i < this.views.size(); ++i) {
            ((ViewI)this.views.elementAt(i)).setCentre(centre);
        }
    }

    public void setZoomFactor(double factor) {
        super.setZoomFactor(factor);
        for (int i = 0; i < this.views.size(); ++i) {
            ((ViewI)this.views.elementAt(i)).setZoomFactor(factor);
        }
    }

    public void setLimitsSet(boolean state) {
        super.setLimitsSet(state);
        for (int i = 0; i < this.views.size(); ++i) {
            ((ViewI)this.views.elementAt(i)).setLimitsSet(state);
        }
    }

    public Selection findFeaturesForSelection(Point p, boolean selectParents) {
        Selection compSel = new Selection();
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (!(v instanceof PickViewI)) continue;
            compSel.add(((PickViewI)v).findFeaturesForSelection(p, selectParents));
        }
        return compSel;
    }

    public Selection findFeaturesForSelection(Rectangle rect) {
        Selection compSel = new Selection();
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (!(v instanceof PickViewI)) continue;
            compSel.add(((PickViewI)v).findFeaturesForSelection(rect));
        }
        return compSel;
    }
}

