/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.featuretree;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Evidence;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.gui.FeatureNavigationI;
import apollo.gui.event.MouseButtonEvent;
import apollo.gui.featuretree.FeatureTreeFrame;
import apollo.gui.menus.TreeMenu;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.SeqFeatureUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FeatureTreePanel
extends JScrollPane
implements MouseListener {
    protected JTree tree = null;
    protected FeatureSetI feature_set;
    protected FeatureNavigationI parent;
    protected boolean remote_update = false;
    protected Hashtable treeHash;
    protected boolean endToggle = true;
    private GuiCurationState curationState;

    public FeatureTreePanel(FeatureNavigationI parent, GuiCurationState curationState) {
        this.parent = parent;
        this.curationState = curationState;
    }

    public FeatureTreeFrame getFeatureTreeFrame() {
        if (this.parent instanceof FeatureTreeFrame) {
            return (FeatureTreeFrame)this.parent;
        }
        return null;
    }

    public void setFeatureSet(FeatureSetI fs) {
        this.feature_set = fs;
        this.updateFeatureSet();
    }

    protected void updateFeatureSet() {
        DefaultTreeModel model;
        if (this.tree != null) {
            this.tree.clearSelection();
            this.tree.setModel(null);
            this.tree.setUI(null);
            this.getViewport().remove(this.tree);
        }
        this.tree = null;
        if (this.feature_set != null) {
            this.makeTree(this.feature_set, null);
        }
        this.treeHash = new Hashtable();
        if (this.tree == null) {
            this.initTree("No annotations");
        } else {
            model = (DefaultTreeModel)this.tree.getModel();
            Enumeration<TreeNode> df = ((DefaultMutableTreeNode)model.getRoot()).depthFirstEnumeration();
            while (df.hasMoreElements()) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)df.nextElement();
                this.treeHash.put(dmtn.getUserObject(), dmtn);
            }
        }
        model = (DefaultTreeModel)this.tree.getModel();
        TreePath rootp = new TreePath(model.getRoot());
        this.tree.expandPath(rootp);
    }

    public void mouseClicked(MouseEvent evt) {
        TreePath selPath;
        if (MouseButtonEvent.isRightMouseClick(evt) && this.getFeatureTreeFrame() != null) {
            TreeMenu popup = new TreeMenu(this, evt.getPoint(), this.curationState);
            popup.show((Component)evt.getSource(), evt.getX(), evt.getY());
        } else if (MouseButtonEvent.isLeftMouseClick(evt) && (selPath = this.tree.getPathForLocation(evt.getX(), evt.getY())) != null && evt.getClickCount() == 2) {
            this.doubleClick(selPath);
        }
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void selectionInit() {
        TreeSelectionListener listen = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FeatureTreePanel.this.singleClick(e.getPath());
                FeatureTreePanel.this.endToggle = true;
            }
        };
        this.tree.addTreeSelectionListener(listen);
    }

    private void singleClick(TreePath path) {
        if (!this.remote_update) {
            SeqFeatureI sf = this.getSelectedFeature();
            if (sf != null) {
                this.parent.featureSelected(sf);
            }
            this.endToggle = !this.endToggle;
        }
    }

    protected boolean endToggling() {
        return this.endToggle;
    }

    protected boolean remoteUpdate() {
        return this.remote_update;
    }

    private void doubleClick(TreePath path) {
        this.singleClick(path);
    }

    private void makeTree(SeqFeatureI sf, DefaultMutableTreeNode parent_node) {
        block4: {
            AnnotatedFeatureI gi;
            block3: {
                if (!sf.hasKids()) break block3;
                if (sf.getNumberOfChildren() <= 0) break block4;
                Vector sorted_set = SeqFeatureUtil.getSortedKids(sf);
                DefaultMutableTreeNode newnode = this.addFeatureNode(sf, parent_node, "Annotations");
                for (int i = sorted_set.size() - 1; i >= 0; --i) {
                    SeqFeatureI sf2 = (SeqFeatureI)sorted_set.elementAt(i);
                    this.makeTree(sf2, newnode);
                }
                break block4;
            }
            DefaultMutableTreeNode newnode = this.addFeatureNode(sf, parent_node, "Annotations (a feature - shouldn't happen!)");
            if (parent_node != null && sf instanceof AnnotatedFeatureI && (gi = (AnnotatedFeatureI)sf).getEvidenceFinder() != null) {
                Vector evidence = gi.getEvidence();
                for (int i = 0; i < evidence.size(); ++i) {
                    String evidenceId = ((Evidence)evidence.elementAt(i)).getFeatureId();
                    SeqFeatureI evidenceSF = gi.getEvidenceFinder().findEvidence(evidenceId);
                    if (evidenceSF == null) continue;
                    String label = this.getEvidenceLabel(evidenceSF);
                    DefaultMutableTreeNode evidence_node = new DefaultMutableTreeNode(label);
                    newnode.add(evidence_node);
                }
            }
        }
    }

    private DefaultMutableTreeNode addFeatureNode(SeqFeatureI sf, DefaultMutableTreeNode parent_node, String title) {
        DefaultMutableTreeNode newnode;
        if (parent_node == null) {
            newnode = this.initTree(title);
        } else {
            newnode = new DefaultMutableTreeNode(sf);
            parent_node.add(newnode);
        }
        return newnode;
    }

    private DefaultMutableTreeNode initTree(String topName) {
        DefaultMutableTreeNode newnode = new DefaultMutableTreeNode(topName);
        this.tree = new JTree(newnode);
        int placeholderHeight = this.tree.getFontMetrics(this.tree.getFont()).getHeight();
        BlankIcon blank = new BlankIcon(1, placeholderHeight);
        DefaultTreeCellRenderer rend = new DefaultTreeCellRenderer();
        rend.setClosedIcon(blank);
        rend.setOpenIcon(blank);
        rend.setLeafIcon(blank);
        this.tree.setCellRenderer(rend);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        TreeUI ui = this.tree.getUI();
        if (ui instanceof BasicTreeUI) {
            BasicTreeUI treeUI = (BasicTreeUI)ui;
            Color iconColor = Color.gray;
            treeUI.setExpandedIcon(new TreeIcon(2, iconColor));
            treeUI.setCollapsedIcon(new TreeIcon(1, iconColor));
        } else {
            System.out.println("Icons not set because BasicTreeUI unsupported");
        }
        this.getViewport().add(this.tree);
        this.tree.addMouseListener(this);
        this.selectionInit();
        return newnode;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath selPath = this.tree.getSelectionPath();
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    public SeqFeatureI getSelectedFeature() {
        TreePath path = this.tree.getSelectionPath();
        return this.getSelectedFeature(path);
    }

    protected SeqFeatureI getSelectedFeature(TreePath path) {
        DefaultMutableTreeNode dmtn;
        Object selected;
        SeqFeatureI sf = null;
        if (path != null && (selected = (dmtn = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof SeqFeatureI) {
            sf = (SeqFeatureI)selected;
        }
        return sf;
    }

    private String getEvidenceLabel(SeqFeatureI sf) {
        String label = "";
        FeatureSetI fs = (FeatureSetI)sf.getRefFeature();
        if (fs != null && fs instanceof FeaturePair) {
            SequenceI seq = fs.getHitSequence();
            SeqFeatureI hit = ((FeaturePair)((Object)fs)).getHitFeature();
            if (seq == null) {
                seq = hit.getRefSequence();
            }
            label = seq != null ? sf.getFeatureType() + (seq.getName() != null ? ": " + seq.getName() : "") : sf.getFeatureType() + (hit.getName() != null ? ": " + hit.getName() : "");
        } else {
            label = sf.getFeatureType() + (sf.getName() != null ? ":  " + sf.getName() : "");
        }
        return label;
    }

    protected DefaultMutableTreeNode findTreeNode(Object obj) {
        return this.treeHash == null || obj == null ? null : (DefaultMutableTreeNode)this.treeHash.get(obj);
    }

    public DefaultMutableTreeNode findObject(Object obj) {
        this.remote_update = true;
        DefaultMutableTreeNode dmtn = null;
        if (obj != null) {
            dmtn = this.findTreeNode(obj);
            if (dmtn != null) {
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                this.collapseAll();
                Object[] objs = model.getPathToRoot(dmtn);
                TreePath treep = new TreePath(objs);
                this.tree.paintImmediately(0, 0, this.tree.getSize().width, this.tree.getSize().height);
                TreeSelectionModel selModel = this.tree.getSelectionModel();
                selModel.addSelectionPath(treep);
                this.tree.scrollPathToVisible(treep);
            }
        } else {
            this.tree.setSelectionPath(null);
        }
        this.remote_update = false;
        return dmtn;
    }

    public void collapseAll() {
        Enumeration<TreePath> expanded;
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        TreePath rootp = new TreePath(model.getRoot());
        while ((expanded = this.tree.getExpandedDescendants(rootp)) != null) {
            while (expanded.hasMoreElements()) {
                TreePath expp = expanded.nextElement();
                this.tree.collapsePath(expp);
            }
        }
    }

    class BlankIcon
    implements Icon {
        private int width;
        private int height;

        public BlankIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    class TreeIcon
    implements Icon {
        public static final int PLUS = 1;
        public static final int MINUS = 2;
        private static final int width = 8;
        private static final int height = 8;
        private int type;
        private Color foreground;
        private Color background;

        public TreeIcon(int type, Color foreground) {
            this.type = type;
            this.background = Color.white;
            this.foreground = foreground;
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.white);
            g.fillRect(x, y, 8, 8);
            g.setColor(this.foreground);
            g.drawRect(x, y, 8, 8);
            g.drawLine(x + 2, y + 4, x + 6, y + 4);
            if (this.type == 1) {
                g.drawLine(x + 4, y + 2, x + 4, y + 6);
            }
        }
    }
}

