/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.featuretree;

import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.FeatureNavigationI;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.event.BaseFocusListener;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.featuretree.FeatureTreePanel;
import apollo.gui.menus.ViewMenu;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.FeatureList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;

public class FeatureTreeFrame
extends JFrame
implements BaseFocusListener,
ControlledObjectI,
FeatureSelectionListener,
AnnotationChangeListener,
DataLoadListener,
FeatureNavigationI {
    protected FeatureTreePanel panel = null;
    private GuiCurationState curationState;

    public FeatureTreeFrame(FeatureSetI feature_set, GuiCurationState curationState) {
        this.setController(curationState.getController());
        this.setTitle("Annotation Tree");
        this.getContentPane().setLayout(new BorderLayout());
        this.curationState = curationState;
        this.panel = new FeatureTreePanel(this, curationState);
        this.panel.setFeatureSet(feature_set);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setSize(new Dimension(400, 300));
    }

    public void setFeatureSet(FeatureSetI fs) {
        this.panel.setFeatureSet(fs);
    }

    public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
        if (evt.isEndOfEditSession()) {
            this.panel.updateFeatureSet();
            this.panel.findObject(evt.getAnnotTop());
        }
        return true;
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
        if (this.isVisible() && evt.getSource() != this) {
            this.selectFeatures(evt.getFeatures());
        }
        return false;
    }

    private void selectFeatures(FeatureList features) {
        if (features.size() != 0) {
            for (int i = 0; i < features.size(); ++i) {
                SeqFeatureI sf = features.getFeature(i);
                this.panel.findObject(sf);
            }
        } else {
            this.panel.findObject(null);
        }
    }

    public void featureSelected(SeqFeatureI sf) {
        this.fireFeatureSelectionEvent(sf);
    }

    public void fireBaseFocusEvent(int position, SeqFeatureI sf) {
        BaseFocusEvent evt = new BaseFocusEvent(this, position, sf);
        this.getController().handleBaseFocusEvent(evt);
    }

    public void fireFeatureSelectionEvent(SeqFeatureI sf) {
        if (!this.panel.remoteUpdate()) {
            if (this.panel.endToggling()) {
                this.fireBaseFocusEvent(sf.getLow(), sf);
            } else {
                this.fireBaseFocusEvent(sf.getHigh(), sf);
            }
        }
        this.curationState.getSelectionManager().select(sf, (Object)this);
    }

    public void setController(Controller controller) {
        controller.addListener(this);
    }

    public Controller getController() {
        return this.curationState.getController();
    }

    public Object getControllerWindow() {
        return this;
    }

    public boolean needsAutoRemoval() {
        return false;
    }

    public boolean handleBaseFocusEvent(BaseFocusEvent evt) {
        this.repaint();
        return false;
    }

    public void addNotify() {
        super.addNotify();
        this.setController(this.getController());
    }

    public boolean handleDataLoadEvent(DataLoadEvent e) {
        if (!e.dataRetrievalBeginning()) {
            return false;
        }
        this.getController().removeListener(this);
        this.setFeatureSet(null);
        this.setVisible(false);
        this.hide();
        this.dispose();
        ViewMenu.tree.setState(false);
        return true;
    }
}

