/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.event;

import apollo.config.Config;
import apollo.util.IOUtil;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.SwingUtilities;

public class MouseButtonEvent {
    static boolean DEBUG = false;

    public static boolean isLeftMouseClick(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt)) {
            if (DEBUG) {
                System.out.println(new Date().toString() + " MouseButtonEvent: got left mouse click");
            }
            if (IOUtil.isMac() && SwingUtilities.isRightMouseButton(evt)) {
                if (DEBUG) {
                    System.out.println(new Date().toString() + " MouseButtonEvent: hey, this isn't a left mouse click, it's a *right* mouse click!");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isMiddleMouseClick(MouseEvent evt) {
        if (DEBUG) {
            System.out.println("\n" + new Date().toString() + " MouseButtonEvent: checking for middle mouse event.\nJVM = " + Config.getJVM() + "\n  isRightMouseButton = " + SwingUtilities.isRightMouseButton(evt) + ", isMiddleMouseButton = " + SwingUtilities.isMiddleMouseButton(evt) + ", isLeftMouseButton = " + SwingUtilities.isLeftMouseButton(evt) + ", apollo.util.IOUtil.isMac = " + IOUtil.isMac() + ", evt.isAltDown() = " + evt.isAltDown() + "; evt.isControlDown() = " + evt.isControlDown());
        }
        if (!MouseButtonEvent.macJDK1_3() && SwingUtilities.isMiddleMouseButton(evt) || MouseButtonEvent.macJDK1_3() && SwingUtilities.isRightMouseButton(evt)) {
            if (DEBUG) {
                System.out.println(new Date().toString() + " MouseButtonEvent: got middle mouse event");
            }
            return true;
        }
        if (MouseButtonEvent.macJDK1_3() && !SwingUtilities.isLeftMouseButton(evt) && !SwingUtilities.isMiddleMouseButton(evt) && !SwingUtilities.isRightMouseButton(evt)) {
            if (DEBUG) {
                System.out.println("MouseButtonEvent: got middle mouse click on five-button Mac mouse");
            }
            return true;
        }
        return false;
    }

    public static boolean isMiddleMouseClickNoShift(MouseEvent evt) {
        return MouseButtonEvent.isMiddleMouseClick(evt) && !MouseButtonEvent.isShift(evt);
    }

    public static boolean isRightMouseClick(MouseEvent evt) {
        if (!MouseButtonEvent.macJDK1_3() && SwingUtilities.isRightMouseButton(evt) || MouseButtonEvent.macJDK1_3() && SwingUtilities.isMiddleMouseButton(evt)) {
            if (DEBUG) {
                System.out.println("MouseButtonEvent: got right mouse event.");
            }
            return true;
        }
        return false;
    }

    public static boolean isRightMouseClickNoShift(MouseEvent evt) {
        return MouseButtonEvent.isRightMouseClick(evt) && !MouseButtonEvent.isShift(evt);
    }

    public static boolean isRightMouseClickWithShift(MouseEvent evt) {
        return MouseButtonEvent.isRightMouseClick(evt) && MouseButtonEvent.isShift(evt);
    }

    public static boolean isShift(MouseEvent evt) {
        return (evt.getModifiers() & 1) != 0;
    }

    private static boolean macJDK1_3() {
        return IOUtil.isMac() && Config.getJVM().startsWith("1.3");
    }
}

