/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.datamodel.SeqFeatureI;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.DrawableSeqFeature;
import java.awt.Graphics;
import java.awt.Rectangle;

public class PromoterGlyph
extends DrawableSeqFeature {
    public PromoterGlyph() {
        super(true);
    }

    public PromoterGlyph(SeqFeatureI feature) {
        super(feature, true);
    }

    public void drawUnselected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        if (boxBounds.width < 3) {
            super.drawUnselected(g, boxBounds, transformer, manager);
        } else {
            int arrow_bot;
            int arrow_tip = boxBounds.x;
            int y = this.getYCentre(boxBounds);
            int transcription_start_x = boxBounds.x;
            int transcription_start_y = boxBounds.y;
            if (this.getStrand() >= 0 && transformer.getXOrientation() == 1 || this.getStrand() < 0 && transformer.getXOrientation() == -1) {
                arrow_bot = (arrow_tip += boxBounds.width) - Math.min(8, boxBounds.width);
                transcription_start_y += boxBounds.height;
            } else {
                arrow_bot = arrow_tip + Math.min(8, boxBounds.width);
                transcription_start_x += boxBounds.width;
            }
            g.setColor(this.getDrawableColor());
            g.drawLine(boxBounds.x, y, boxBounds.x + boxBounds.width, y);
            g.drawLine(transcription_start_x, y, transcription_start_x, transcription_start_y);
            g.drawLine(arrow_tip, y, arrow_bot, boxBounds.y);
            g.drawLine(arrow_tip, y, arrow_bot, boxBounds.y + boxBounds.height);
        }
    }
}

