/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.config.Config;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import apollo.gui.detailviewers.exonviewer.BaseEditorPanel;
import apollo.gui.detailviewers.exonviewer.DefaultBaseRenderer;
import apollo.gui.detailviewers.exonviewer.SeqAlignPanel;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.gui.drawable.DrawableUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;

public class SelectableDNARenderer
extends DefaultBaseRenderer {
    protected final Color[][] transcriptColorList;
    protected int transcriptColorIndex = 0;
    protected int exonColorIndex = 0;
    SeqAlignPanel baseEditor;
    double[] currentRange = new double[2];
    double[] transcriptRange = new double[2];
    double[] oldRange = new double[2];
    SeqFeatureI currentFeature;
    FeatureSetI currentFeatureSet;
    int type;
    boolean isIntron;
    boolean isExon;
    int targetNucleotide = -1;
    int targetTier = -1;
    int hitIndex;
    Color targetColor;
    Color seqSelectColor;
    Color hatchColor;
    Color shiftColor = Config.getStyle().getSeqErrorColor();

    public SelectableDNARenderer(SeqAlignPanel baseEditor, int width, int height) {
        super(width, height);
        this.baseEditor = baseEditor;
        if (baseEditor instanceof BaseEditorPanel) {
            this.transcriptColorList = ((BaseEditorPanel)baseEditor).getColorArray();
            this.setSeqSelectColor(((BaseEditorPanel)baseEditor).getSeqSelectColor());
        } else {
            this.transcriptColorList = new Color[1][1];
            this.transcriptColorList[0][0] = Color.blue;
            this.setSeqSelectColor(Color.pink);
        }
        this.setTargetColor(this.shiftColor);
    }

    public void setTargetPos(int pos, int tier) {
        this.targetNucleotide = pos;
        this.targetTier = tier;
    }

    public void setTargetColor(Color in) {
        this.targetColor = in;
    }

    public void setSeqSelectColor(Color in) {
        this.seqSelectColor = in;
    }

    public void paintNotify() {
        this.currentRange[0] = Double.POSITIVE_INFINITY;
        this.currentRange[1] = Double.NEGATIVE_INFINITY;
        this.transcriptRange[0] = Double.POSITIVE_INFINITY;
        this.transcriptRange[1] = Double.NEGATIVE_INFINITY;
        this.currentFeature = null;
        this.transcriptColorIndex = 0;
        this.exonColorIndex = 0;
        this.hitIndex = 0;
    }

    public Component getBaseRendererComponent(char base, int pos, int tier, SequenceI seq) {
        this.init(base, pos, tier, seq);
        this.hatchColor = null;
        if (((BaseEditorPanel)this.baseEditor).getShowHitZones()) {
            Vector hitZones = ((BaseEditorPanel)this.baseEditor).hitZones;
            for (int hitIndex = 0; hitIndex < hitZones.size(); ++hitIndex) {
                int[] hitZone = (int[])hitZones.elementAt(hitIndex);
                if (pos < hitZone[0] || pos >= hitZone[1]) continue;
                this.hatchColor = Color.yellow;
                break;
            }
        }
        this.currentFeature = this.baseEditor.getFeatureAtPosition(pos, tier);
        double[] range = this.establishRange(this.currentFeature, pos, tier, false);
        if (range[1] != this.currentRange[1] || range[0] != this.currentRange[0]) {
            this.currentRange[0] = range[0];
            this.currentRange[1] = range[1];
            this.currentFeatureSet = this.baseEditor.getFeatureSetAtPosition(pos, tier);
            range = this.establishRange(this.currentFeatureSet, pos, tier, true);
            this.transcriptRange[0] = range[0];
            this.transcriptRange[1] = range[1];
            if (this.currentFeature != null) {
                this.transcriptColorIndex = this.baseEditor.getRangeIndex(tier, (int)this.currentRange[0], (int)this.currentRange[1]) % this.transcriptColorList.length;
                this.exonColorIndex = this.baseEditor.getExonRangeIndex(tier, (int)this.currentRange[0], (int)this.currentRange[1]) % this.transcriptColorList[this.transcriptColorIndex].length;
            }
            if (this.currentFeature == null) {
                this.isExon = false;
                this.isIntron = false;
            } else if (this.currentFeature.hasKids()) {
                this.isExon = false;
                this.isIntron = true;
            } else {
                this.isExon = true;
                this.isIntron = false;
            }
        }
        return this;
    }

    public double[] establishRange(SeqFeatureI sf, int pos, int tier, boolean use_set) {
        double[] range = sf == null || !use_set && sf.canHaveChildren() ? this.baseEditor.getRangeAtPosition(tier, pos) : new double[]{this.baseEditor.basePairToPos(sf.getLow()), this.baseEditor.basePairToPos(sf.getHigh())};
        return range;
    }

    public Color getHatchColor() {
        return this.hatchColor;
    }

    public Color getBackgroundBoxColor() {
        int highSeqSelect;
        int lowSeqSelect;
        if (this.pos == this.targetNucleotide && this.tier == this.targetTier) {
            return this.targetColor;
        }
        if (this.baseEditor instanceof BaseEditorPanel) {
            lowSeqSelect = ((BaseEditorPanel)this.baseEditor).selectLowPos();
            highSeqSelect = ((BaseEditorPanel)this.baseEditor).selectHighPos();
        } else {
            lowSeqSelect = -1;
            highSeqSelect = -1;
        }
        if (lowSeqSelect != -1 && highSeqSelect != -1 && this.pos >= lowSeqSelect && this.pos <= highSeqSelect) {
            return this.seqSelectColor;
        }
        int basePos = this.baseEditor.posToBasePair(this.pos);
        if (((BaseEditorPanel)this.baseEditor).isSequencingErrorPosition(basePos)) {
            return this.shiftColor;
        }
        if (this.isExon) {
            ExonI exon = null;
            if (this.currentFeature instanceof ExonI) {
                exon = (ExonI)this.currentFeature;
            } else if (this.currentFeature instanceof DrawableSeqFeature) {
                exon = (ExonI)((DrawableSeqFeature)((Object)this.currentFeature)).getFeature();
            }
            if (exon != null && exon.getTranscript() != null) {
                Transcript transcript = exon.getTranscript();
                int tss = exon.getTranscript().getTranslationStart();
                if (basePos == tss || basePos == tss + exon.getStrand() || basePos == tss + 2 * exon.getStrand()) {
                    return DrawableUtil.getStartCodonColor(transcript);
                }
                int tes = transcript.getTranslationEnd();
                if (basePos == tes || basePos == tes + exon.getStrand() || basePos == tes + 2 * exon.getStrand()) {
                    return Color.red;
                }
                int shift_pos = transcript.plus1FrameShiftPosition();
                if (basePos == shift_pos) {
                    return this.shiftColor;
                }
                shift_pos = transcript.minus1FrameShiftPosition();
                if (basePos == shift_pos) {
                    return this.shiftColor;
                }
                int stop_pos = transcript.readThroughStopPosition();
                if (basePos == stop_pos || basePos == stop_pos + exon.getStrand() || basePos == stop_pos + 2 * exon.getStrand()) {
                    return Color.pink;
                }
            }
            return this.transcriptColorList[this.transcriptColorIndex][this.exonColorIndex];
        }
        return null;
    }

    public Color getBackgroundLineColor() {
        if (this.pos == this.targetNucleotide && this.tier == this.targetTier) {
            return null;
        }
        if (this.isIntron) {
            return this.transcriptColorList[this.transcriptColorIndex][0];
        }
        return null;
    }

    public Color getTextColor() {
        return Color.white;
    }

    public void paint(Graphics g) {
        g.setFont(this.getFont());
        Color boxColor = this.getBackgroundBoxColor();
        Color hatchColor = this.getHatchColor();
        Color backgroundLineColor = this.getBackgroundLineColor();
        int outlineType = this.getOutlineType();
        Color outlineColor = this.getOutlineColor();
        if (backgroundLineColor != null) {
            g.setColor(backgroundLineColor);
            g.fillRect(0, this.getSize().height / 2 - 1, this.getSize().width, 2);
        }
        if (boxColor != null) {
            g.setColor(boxColor);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        if (hatchColor != null) {
            g.setColor(hatchColor);
            g.drawLine(0, this.getSize().height, this.getSize().width, this.getSize().height);
            g.drawLine(0, 0, this.getSize().width, 0);
        }
        if (outlineType != 0 && outlineColor != null) {
            g.setColor(outlineColor);
            g.drawLine(0, 0, this.getSize().width - 1, 0);
            g.drawLine(0, this.getSize().height - 1, this.getSize().width - 1, this.getSize().height - 1);
            if (outlineType == 1) {
                g.drawLine(0, 0, 0, this.getSize().height - 1);
            } else if (outlineType == 3) {
                g.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height - 1);
            }
        }
        if (this.getTextColor() != null) {
            int leadDistance = (this.getSize().width - this.metrics.charWidth(this.c)) / 2;
            g.setColor(this.getTextColor());
            g.drawString(this.c + "", leadDistance, this.getSize().height - 2);
        }
    }

    public int getOutlineType() {
        SeqFeatureI selected = null;
        if (this.baseEditor instanceof BaseEditorPanel) {
            selected = ((BaseEditorPanel)this.baseEditor).getSelectedFeature();
        }
        if (this.featSetContainsFeat(this.currentFeatureSet, selected)) {
            if ((double)this.pos == this.transcriptRange[0]) {
                return 1;
            }
            if ((double)this.pos == this.transcriptRange[1]) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public Color getOutlineColor() {
        FeatureSetI featureSet;
        SeqFeatureI selected = null;
        if (this.baseEditor instanceof BaseEditorPanel) {
            selected = ((BaseEditorPanel)this.baseEditor).getSelectedFeature();
        }
        if (this.featSetContainsFeat(featureSet = this.baseEditor.getFeatureSetAtPosition(this.pos, this.tier), selected)) {
            return Color.magenta;
        }
        return null;
    }

    private boolean featSetContainsFeat(FeatureSetI fs, SeqFeatureI feat) {
        if (fs == null || feat == null) {
            return false;
        }
        if (fs == feat) {
            return true;
        }
        return fs == feat.getRefFeature();
    }

    public void setTier(int tier) {
        this.tier = tier;
    }
}

