/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.config.Config;
import apollo.datamodel.SequenceI;
import apollo.gui.detailviewers.exonviewer.BaseRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;

public class DefaultBaseRenderer
extends JComponent
implements BaseRenderer {
    protected char c;
    protected int pos;
    protected int tier;
    protected SequenceI seq;
    protected FontMetrics metrics;
    public static final int NO_OUTLINE = 0;
    public static final int LEFT_OUTLINE = 1;
    public static final int CENTER_OUTLINE = 2;
    public static final int RIGHT_OUTLINE = 3;

    public DefaultBaseRenderer(int width, int height) {
        this.setFont(Config.getExonDetailEditorSequenceFont());
        this.setBorder(null);
        this.setForeground(Color.white);
        this.setBackground(Color.blue);
        this.setSize(width, height);
        this.setOpaque(false);
    }

    public void setFont(Font in) {
        this.metrics = this.getFontMetrics(in);
        super.setFont(in);
    }

    public Color getBrokenEdgeColor() {
        return null;
    }

    public void paintNotify() {
    }

    public Component getBaseRendererComponent(char base, int pos, int tier, SequenceI seq) {
        this.init(base, pos, tier, seq);
        return this;
    }

    protected void init(char base, int pos, int tier, SequenceI seq) {
        this.c = base;
        this.pos = pos;
        this.tier = tier;
        this.seq = seq;
    }

    public Color getTextColor() {
        return this.getForeground();
    }

    public Color getBackgroundBoxColor() {
        return null;
    }

    public Color getBackgroundLineColor() {
        return null;
    }

    public Color getHatchColor() {
        return null;
    }

    public int getOutlineType() {
        return 0;
    }

    public Color getOutlineColor() {
        return null;
    }

    public void paint(Graphics g) {
        g.setFont(this.getFont());
        Color boxColor = this.getBackgroundBoxColor();
        Color hatchColor = this.getHatchColor();
        Color backgroundLineColor = this.getBackgroundLineColor();
        int outlineType = this.getOutlineType();
        Color outlineColor = this.getOutlineColor();
        Color brokenEdgeColor = this.getBrokenEdgeColor();
        if (backgroundLineColor != null) {
            g.setColor(backgroundLineColor);
            g.fillRect(0, this.getSize().height / 2 - 1, this.getSize().width, 2);
        }
        if (boxColor != null) {
            g.setColor(boxColor);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        if (hatchColor != null) {
            g.setColor(hatchColor);
            g.drawLine(0, this.getSize().height, this.getSize().width, this.getSize().height);
            g.drawLine(0, 0, this.getSize().width, 0);
            g.drawLine(0, 0, 0, this.getSize().height);
            g.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height);
        }
        if (brokenEdgeColor != null) {
            int squiggleCount = 4;
            int triangleHeight = 1 + this.getSize().height / 4;
            int triangleWidth = 1 + this.getSize().width / 5;
            for (int i = 0; i < 3; ++i) {
                g.setColor(brokenEdgeColor);
                g.drawLine(0, i * triangleHeight, triangleWidth, i * triangleHeight + triangleHeight / 2);
                g.drawLine(triangleWidth, i * triangleHeight + triangleHeight / 2, 0, (i + 1) * triangleHeight);
            }
        }
        if (outlineType != 0 && outlineColor != null) {
            g.setColor(outlineColor);
            g.drawLine(0, 0, this.getSize().width - 1, 0);
            g.drawLine(0, this.getSize().height - 1, this.getSize().width - 1, this.getSize().height - 1);
            if (outlineType == 1) {
                g.drawLine(0, 0, 0, this.getSize().height);
            } else if (outlineType == 3) {
                g.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height);
            }
        }
        if (this.getTextColor() != null) {
            int leadDistance = (this.getSize().width - this.metrics.charWidth(this.c)) / 2;
            g.setColor(this.getTextColor());
            g.drawString(this.c + "", leadDistance, this.getSize().height - 2);
        }
    }
}

