/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.blixem;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.seq.io.FastaFile;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Vector;

public class BlixemRunner {
    private int genomicPlusMinus = 10000;
    private CurationSet curationSet;
    private Vector typeStrings;
    private int centre;
    private int resType;
    private boolean is_tblastx = false;
    public static final int DNA = 1;
    public static final int PROTEIN = 2;

    public BlixemRunner(CurationSet set, Vector types, int centre, int resType) {
        this.curationSet = set;
        this.typeStrings = types;
        this.centre = centre;
        this.resType = resType;
    }

    public void setGenomicPlusMinus(int gpm) {
        this.genomicPlusMinus = gpm;
    }

    public void run() {
        try {
            File exblxFile = File.createTempFile("blx", ".exblx");
            File fastaFile = File.createTempFile("blx", ".fa");
            exblxFile.deleteOnExit();
            fastaFile.deleteOnExit();
            FileOutputStream exblxFos = new FileOutputStream(exblxFile);
            FileOutputStream fastaFos = new FileOutputStream(fastaFile);
            DataOutputStream exblxDos = new DataOutputStream(exblxFos);
            DataOutputStream fastaDos = new DataOutputStream(fastaFos);
            SequenceI seq = this.curationSet.getRefSequence();
            int min = this.centre - this.genomicPlusMinus;
            int max = this.centre + this.genomicPlusMinus;
            if (seq.usesGenomicCoords()) {
                RangeI range = seq.getRange();
                if (min < range.getLow()) {
                    min = range.getLow();
                }
                if (max > range.getHigh()) {
                    max = range.getHigh();
                }
            } else {
                if (min < 1) {
                    min = 1;
                }
                if (max > seq.getLength()) {
                    max = seq.getLength();
                }
            }
            exblxDos.writeBytes("# exblx\n");
            if (this.resType == 1) {
                for (int i = 0; i < this.typeStrings.size(); ++i) {
                    String type = (String)this.typeStrings.elementAt(i);
                    if (type.indexOf("tblastx") < 0) continue;
                    this.is_tblastx = true;
                }
                if (this.is_tblastx) {
                    exblxDos.writeBytes("# tblastx\n");
                } else {
                    exblxDos.writeBytes("# blastN\n");
                }
            } else {
                exblxDos.writeBytes("# blastx\n");
            }
            StringBuffer exblxOut = new StringBuffer();
            StringBuffer seqblOut = new StringBuffer();
            StringBuffer[] strs = new StringBuffer[]{exblxOut, seqblOut};
            this.generateSeqblExblxData(this.curationSet.getAnnots(), min, max, strs);
            if (strs[1].length() > 0) {
                System.out.println("Shouldn't get seqbl data in annotations\n");
            }
            exblxDos.writeBytes(strs[0].toString());
            strs[0].setLength(0);
            strs[1].setLength(0);
            System.out.println("Calling generateSeqblExblxData on " + this.curationSet.getResults().size() + " total results, range " + min + "-" + max + ", typeStrings = " + this.typeStrings + ", is_tblastx = " + this.is_tblastx + ", resType = " + this.resType + ", strs = " + strs);
            this.generateSeqblExblxData(this.curationSet.getResults(), min, max, strs);
            exblxDos.writeBytes(strs[0].toString());
            exblxDos.close();
            File seqblFile = null;
            if (strs[1].length() > 0) {
                seqblFile = File.createTempFile("blx", ".seqbl");
                seqblFile.deleteOnExit();
                FileOutputStream seqblFos = new FileOutputStream(seqblFile);
                DataOutputStream seqblDos = new DataOutputStream(seqblFos);
                seqblDos.writeBytes("# seqbl\n");
                if (this.resType == 1) {
                    if (this.is_tblastx) {
                        seqblDos.writeBytes("# tblastx\n");
                    } else {
                        seqblDos.writeBytes("# blastN\n");
                    }
                } else {
                    seqblDos.writeBytes("# blastx\n");
                }
                seqblDos.writeBytes(strs[1].toString());
                seqblDos.close();
            }
            fastaDos.writeBytes(FastaFile.format(">\n", seq.getResidues(min, max), 60));
            fastaDos.close();
            String comStr = Config.getBlixemLocation() + " -O " + min + " " + (seqblFile == null ? "" : "-x " + seqblFile.getAbsolutePath() + " ") + fastaFile.getAbsolutePath() + " " + exblxFile.getAbsolutePath();
            System.out.println("Blixem command string: " + comStr);
            Runtime.getRuntime().exec(comStr);
        }
        catch (Exception e) {
            System.err.println("Failed to run blixem");
            e.printStackTrace();
        }
    }

    private void generateSeqblExblxData(FeatureSetI set, int min, int max, StringBuffer[] strs) {
        StringBuffer exblxOut = strs[0];
        StringBuffer seqblOut = strs[1];
        for (int i = 0; i < set.size(); ++i) {
            SeqFeatureI sf = set.getFeatureAt(i);
            if (sf.canHaveChildren()) {
                FeatureSetI fs = (FeatureSetI)sf;
                this.generateSeqblExblxData(fs, min, max, strs);
                continue;
            }
            if (sf instanceof FeaturePair) {
                StringBuffer out;
                String frameStr;
                FeaturePair fp = (FeaturePair)sf;
                boolean isCorrectResType = false;
                SeqFeatureI query = fp.getQueryFeature();
                SeqFeatureI hit = fp.getHitFeature();
                double qToh = (double)query.length() / (double)hit.length();
                if (qToh > 2.5 && 2 == this.resType) {
                    isCorrectResType = true;
                } else if (qToh < 1.2 && 1 == this.resType) {
                    isCorrectResType = true;
                }
                if (!isCorrectResType || !this.typeStrings.contains(sf.getFeatureType()) || sf.getHigh() > max || sf.getLow() < min) continue;
                if (this.resType == 2) {
                    int frame = fp.getStrand() == 1 ? (fp.getLow() - min + 1) % 3 : (max - fp.getHigh() + 1) % 3;
                    if (frame == 0) {
                        frame = 3;
                    }
                    frameStr = fp.getStrand() == 1 ? "+" + frame : "-" + frame;
                } else {
                    frameStr = fp.getStrand() == 1 ? "+1" : "-1";
                }
                SequenceI hitSeq = fp.getHitFeature().getRefSequence();
                String gameAlignSeqString = null;
                if (hitSeq == null || hitSeq.getLength() == 0) {
                    gameAlignSeqString = fp.getHitFeature().getProperty("subject_alignment");
                }
                if (hitSeq != null && hitSeq.getLength() > 1 || gameAlignSeqString != null) {
                    System.out.println("For feature " + fp + ", hitSeq = " + hitSeq + "--writing to " + seqblOut);
                    out = seqblOut;
                } else {
                    System.out.println("Hit " + hit);
                    System.out.println("Hitref " + hit.getRefSequence());
                    if (hit.getRefSequence() != null) {
                        hitSeq = this.curationSet.getSequence(hit.getRefSequence().getName());
                        System.out.println("\nFor feature " + fp + ", hitSeq = null--trying to get sequence for " + hit.getRefSequence().getName());
                    }
                    if (hitSeq != null) {
                        out = seqblOut;
                    } else {
                        System.out.println("For feature " + fp + ", couldn't get hitSeq--writing to exblxOut");
                        out = exblxOut;
                    }
                }
                int hitstart = fp.getHstart();
                int hitend = fp.getHend();
                if (this.is_tblastx && hitstart > hitend) {
                    hitstart = hitstart - hitend + 1;
                    hitend = 1;
                }
                String line = "100 (" + frameStr + ")\t" + (fp.getStart() - min + 1) + "\t" + (fp.getEnd() - min + 1) + "\t" + hitstart + "\t" + hitend + " " + fp.getHname();
                if (out == seqblOut) {
                    String subseq = hitSeq.getResidues(fp.getHstart(), fp.getHend());
                    if (gameAlignSeqString != null) {
                        subseq = gameAlignSeqString;
                    }
                    if (subseq == null || subseq.length() <= 1) {
                        subseq = hit.getFeatureSequence().getResidues();
                    }
                    if (subseq == null || subseq.length() <= 1) continue;
                    out.append(line + " " + subseq + "\n");
                    continue;
                }
                out.append(line + "\n");
                continue;
            }
            if (!(sf instanceof AnnotatedFeatureI) || sf.getHigh() > max || sf.getLow() < min) continue;
            exblxOut.append("-2 (" + sf.getStrand() + ")\t" + (sf.getStart() - min + 1) + "\t" + (sf.getEnd() - min + 1) + "\t0\t0");
            if (sf.getRefFeature() != null) {
                exblxOut.append(" " + sf.getRefFeature().getId() + "\n");
                continue;
            }
            exblxOut.append(" " + sf.getId() + "\n");
        }
    }
}

