/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.annotinfo;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.Style;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Synonym;
import apollo.editor.AddTransaction;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationUpdateEvent;
import apollo.editor.ChangeList;
import apollo.editor.DeleteTransaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.TransactionUtil;
import apollo.editor.UserName;
import apollo.gui.annotinfo.FeatureEditorDialog;
import apollo.gui.annotinfo.ReadWriteField;
import apollo.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class FeatureEditPanel
extends JPanel {
    private AnnotatedFeatureI originalFeature;
    protected FeatureEditorDialog featureEditorDialog;
    Box featureBox = new Box(1);
    JCheckBox isProblematicCheckbox = new JCheckBox();
    JPanel fieldsPanel = new JPanel();
    Color bgColor = new Color(176, 236, 248);
    TitledBorder border;
    ReadWriteField featureNameField = new ReadWriteField();
    ReadWriteField featureIDField = new ReadWriteField();
    ReadWriteField featureSynonymField = new ReadWriteField();
    private static final boolean doSynList = true;
    private JList synGuiList = new JList();
    private DefaultListModel guiListModel = new DefaultListModel();
    private JScrollPane synScrollPane = new JScrollPane(this.synGuiList);
    private JButton delSynButton = new JButton("delete");
    private JButton addSynButton = new JButton("add");
    boolean lockFocus = false;
    protected boolean isReadOnly;
    protected int row;
    private SynonymEditor synonymEditor;
    private final TransactionSubpart SYN_SUBPART = TransactionSubpart.SYNONYM;

    FeatureEditPanel(FeatureEditorDialog featureEditorDialog, boolean isReadOnly) {
        this.featureEditorDialog = featureEditorDialog;
        this.isReadOnly = isReadOnly;
    }

    protected FeatureEditorDialog getFeatureEditorDialog() {
        return this.featureEditorDialog;
    }

    protected void loadAnnotation(AnnotatedFeatureI feature) {
        if (this.originalFeature != null && !this.getFeatureEditorDialog().isUndoing()) {
            this.checkFocusDrivenEdits();
        }
        this.originalFeature = feature;
        this.loadSelectedFeature();
    }

    protected void checkFocusDrivenEdits() {
        this.synonymEditor.processSynonymChanges();
    }

    protected AnnotatedFeatureI getEditedFeature() {
        return this.originalFeature;
    }

    protected ApolloNameAdapterI getNameAdapter() {
        return this.getFeatureEditorDialog().getNameAdapter(this.getEditedFeature());
    }

    protected void jbInit() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(this.bgColor);
        this.setForeground(Color.black);
        this.fieldsPanel.setBackground(this.bgColor);
        this.fieldsPanel.setLayout(new GridBagLayout());
        this.row = 0;
        this.addField("Symbol", (Component)this.featureNameField.getComponent());
        this.featureBox.setBackground(this.bgColor);
        this.featureBox.setForeground(Color.black);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.featureBox);
        this.add(Box.createHorizontalStrut(8));
        this.add(Box.createHorizontalGlue());
        this.addListeners();
    }

    protected Box getFeatureBox() {
        return this.featureBox;
    }

    protected void addIsProblematicCheckbox() {
        if (!Config.getStyle().showIsProbCheckbox()) {
            return;
        }
        this.addField("Is problematic?", (Component)this.isProblematicCheckbox);
        this.isProblematicCheckbox.setBackground(this.bgColor);
        this.isProblematicCheckbox.setEnabled(!this.isReadOnly);
    }

    protected JPanel getFieldsPanel() {
        return this.fieldsPanel;
    }

    protected void addFieldsPanelBottomGlue() {
        Component glue = Box.createVerticalGlue();
        int fill = 3;
        this.fieldsPanel.add(glue, GuiUtil.makeConstraint(0, this.row, 1, 1, 1.0, 0, fill));
    }

    protected void addField(String label_text, Component c) {
        this.addField(this.initLabel(label_text), c);
    }

    protected void addField(JComponent left, Component right) {
        this.addLeftField(left);
        this.fieldsPanel.add(right, GuiUtil.makeWeightConst(1, this.row++, 0, true));
    }

    private void addLeftField(Component leftComp) {
        this.fieldsPanel.add(leftComp, GuiUtil.makeWeightConst(0, this.row, 3, false));
    }

    protected ReadWriteField getNameField() {
        return this.featureNameField;
    }

    protected String getGuiName() {
        return this.getNameField().getValue().trim();
    }

    protected void setGuiName(String name) {
        this.getNameField().setValue(name);
    }

    protected String getModelName() {
        return this.getEditedFeature().getName();
    }

    protected void setGuiNameFromModel() {
        this.setGuiName(this.getEditedFeature().getName());
    }

    protected boolean nameHasChanged() {
        String guiName = this.getGuiName();
        return guiName != null && !guiName.equals("") && !guiName.equals(this.getEditedFeature().getName());
    }

    void clearFields() {
        this.featureNameField.setValue("");
        this.featureIDField.setValue("");
        this.featureSynonymField.setValue("");
        this.isProblematicCheckbox.setSelected(false);
        this.guiListModel.clear();
    }

    private static List tokenizeListing(String in) {
        int i = 0;
        int endIndex = -1;
        int len = in.length();
        Vector<String> out = new Vector<String>();
        while (true) {
            if (i < len && Character.isWhitespace(in.charAt(i))) {
                ++i;
                continue;
            }
            endIndex = in.indexOf(44, i);
            if (endIndex == -1) {
                if (i == len) break;
                out.addElement(in.substring(i, len));
                break;
            }
            out.addElement(in.substring(i, endIndex));
            i = endIndex + 1;
            if (i >= len) break;
        }
        return out;
    }

    protected JLabel initLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(new Font("Dialog", 0, 12));
        label.setBackground(this.bgColor);
        label.setForeground(Color.black);
        return label;
    }

    protected static String trimFirstAndLast(String in) {
        if ((in = in.substring(1, in.length() - 1)).startsWith(", ")) {
            in.replace(',', ' ');
        }
        return in.trim();
    }

    protected Color getBackgroundColor() {
        return this.bgColor;
    }

    protected abstract void loadSelectedFeature();

    protected void fireAnnotEvent(AnnotationChangeEvent ace) {
        this.getFeatureEditorDialog().fireAnnotEvent(ace);
    }

    protected void setBooleanSubpart(boolean guiState, TransactionSubpart ts) {
        boolean modelState = TransactionUtil.getBoolean(this.getEditedFeature(), ts);
        if (guiState == modelState) {
            return;
        }
        TransactionUtil.flipBoolean(this.getEditedFeature(), ts);
        AnnotationUpdateEvent aue = this.makeUpdateEvent(ts);
        this.fireAnnotEvent(aue);
    }

    protected AnnotationUpdateEvent makeUpdateEvent(TransactionSubpart ts) {
        return this.makeUpdateEvent(this.getEditedFeature(), ts);
    }

    protected AnnotationUpdateEvent makeUpdateEvent(AnnotatedFeatureI a, TransactionSubpart ts) {
        return new AnnotationUpdateEvent((Object)this.getFeatureEditorDialog(), a, ts);
    }

    protected void errorPopup(String err) {
        err = err + "\nYou must fix this problem before changes can be committed.";
        System.err.println(err);
        JOptionPane.showMessageDialog(null, err, "Name or ID problem", 2);
    }

    protected ChangeList createChangeList() {
        return new ChangeList(this.getFeatureEditorDialog().getController());
    }

    protected Style getStyle() {
        return this.getFeatureEditorDialog().getStyle();
    }

    protected void addSynonymGui() {
        Box synonymBox = new Box(0);
        Border line = BorderFactory.createLineBorder(Color.gray);
        synonymBox.setBorder(BorderFactory.createTitledBorder(line, "Synonyms"));
        if (!this.isReadOnly) {
            synonymBox.add(this.makeSynButBox());
        }
        synonymBox.add(Box.createHorizontalStrut(51));
        synonymBox.add(this.synScrollPane);
        synonymBox.setPreferredSize(new Dimension(80, 50));
        synonymBox.setMaximumSize(new Dimension(150, 100));
        int fill = 1;
        this.fieldsPanel.add((Component)synonymBox, GuiUtil.makeConstraint(0, this.row, 2, 2, 1.0, 0, fill));
        this.row += 2;
        this.synGuiList.setVisibleRowCount(2);
        this.synScrollPane.setHorizontalScrollBarPolicy(31);
    }

    private Box makeSynButBox() {
        this.setupSynButton(this.delSynButton);
        this.setupSynButton(this.addSynButton);
        Box box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(this.addSynButton);
        box.add(Box.createHorizontalGlue());
        box.add(this.delSynButton);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void setupSynButton(JButton synBut) {
        synBut.setPreferredSize(new Dimension(50, 20));
        synBut.setFont(new Font("Dialog", 0, 10));
        synBut.setMargin(new Insets(0, 0, 0, 0));
    }

    protected void loadSynonymGui() {
        boolean notInternal = !Config.internalMode();
        Vector syns = this.getEditedFeature().getSynonyms(notInternal);
        this.featureSynonymField.setValue(FeatureEditPanel.trimFirstAndLast(syns.toString()));
        this.guiListModel.clear();
        for (int i = 0; i < syns.size(); ++i) {
            this.guiListModel.addElement(syns.get(i));
        }
        this.synGuiList.setModel(this.guiListModel);
    }

    private void addListeners() {
        this.isProblematicCheckbox.addActionListener(new IsProbCheckBoxListener());
        this.synonymEditor = new SynonymEditor();
        this.featureSynonymField.addFocusListener(this.synonymEditor);
        this.addSynButton.addActionListener(new AddSynListener());
        this.delSynButton.addActionListener(new DelSynListener());
    }

    private Object evtSrc() {
        return this.getFeatureEditorDialog();
    }

    private class DelSynListener
    implements ActionListener {
        private DelSynListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.synSelected()) {
                return;
            }
            this.deleteSelSynFromModel();
            this.removeSynFromGui();
        }

        private boolean synSelected() {
            return this.getSelectedSynonym() != null;
        }

        private Synonym getSelectedSynonym() {
            return (Synonym)FeatureEditPanel.this.synGuiList.getSelectedValue();
        }

        private void deleteSelSynFromModel() {
            Synonym syn = this.getSelectedSynonym();
            int i = FeatureEditPanel.this.synGuiList.getSelectedIndex();
            DeleteTransaction dt = new DeleteTransaction(FeatureEditPanel.this.evtSrc(), FeatureEditPanel.this.getEditedFeature(), FeatureEditPanel.this.SYN_SUBPART, syn, i);
            dt.editModel();
            FeatureEditPanel.this.fireAnnotEvent(dt.generateAnnotationChangeEvent());
        }

        private void removeSynFromGui() {
            FeatureEditPanel.this.guiListModel.remove(FeatureEditPanel.this.synGuiList.getSelectedIndex());
        }
    }

    private class AddSynListener
    implements ActionListener {
        private AddSynListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String newSynString = this.getUserInput();
            if (newSynString == null) {
                return;
            }
            Synonym newSyn = this.makeNewSyn(newSynString);
            this.addSynToModel(newSyn);
            this.addSynToGui(newSyn);
        }

        private String getUserInput() {
            String featName = FeatureEditPanel.this.getEditedFeature().getName();
            return JOptionPane.showInputDialog("Enter new synonym for " + featName);
        }

        private Synonym makeNewSyn(String name) {
            Synonym syn = new Synonym(name);
            syn.setOwner(UserName.getUserName());
            return syn;
        }

        private void addSynToModel(Synonym syn) {
            AnnotatedFeatureI an = FeatureEditPanel.this.getEditedFeature();
            int i = an.getSynonymSize();
            AddTransaction at = new AddTransaction(FeatureEditPanel.this.evtSrc(), an, FeatureEditPanel.this.SYN_SUBPART, syn, i);
            at.editModel();
            FeatureEditPanel.this.fireAnnotEvent(at.generateAnnotationChangeEvent());
        }

        private void addSynToGui(Synonym syn) {
            FeatureEditPanel.this.guiListModel.addElement(syn);
        }
    }

    private class SynonymEditor
    implements FocusListener {
        private List oldSyns;
        private List newSyns;
        private boolean modelUpdated = false;
        private boolean synonymGuiEdited = false;

        private SynonymEditor() {
        }

        public void focusGained(FocusEvent e) {
            this.synonymGuiEdited = true;
        }

        public void focusLost(FocusEvent e) {
            this.processSynonymChanges();
            this.synonymGuiEdited = false;
        }

        private List getNewSyns() {
            if (this.newSyns == null) {
                this.newSyns = FeatureEditPanel.tokenizeListing(FeatureEditPanel.this.featureSynonymField.getValue());
            }
            return this.newSyns;
        }

        private String getNewSyn(int i) {
            return (String)this.getNewSyns().get(i);
        }

        private List getOldSyns() {
            if (this.oldSyns == null && FeatureEditPanel.this.getEditedFeature() != null) {
                boolean excludeInternal = !Config.getStyle().internalMode();
                this.oldSyns = (List)FeatureEditPanel.this.getEditedFeature().getSynonyms(excludeInternal).clone();
            }
            return this.oldSyns;
        }

        private Synonym getOldSyn(int i) {
            return (Synonym)this.getOldSyns().get(i);
        }

        private void processSynonymChanges() {
            int i;
            if (!this.synonymGuiEdited) {
                return;
            }
            this.newSyns = null;
            this.oldSyns = null;
            FeatureEditorDialog src = FeatureEditPanel.this.getFeatureEditorDialog();
            AnnotatedFeatureI ann = FeatureEditPanel.this.getEditedFeature();
            if (ann == null) {
                return;
            }
            for (i = 0; i < this.getOldSyns().size(); ++i) {
                if (this.getNewSyns().contains(this.getOldSyn(i).getName())) continue;
                DeleteTransaction dt = new DeleteTransaction(src, ann, FeatureEditPanel.this.SYN_SUBPART, this.getOldSyn(i), i);
                dt.setSubpartRank(i);
                this.updateModel();
                FeatureEditPanel.this.fireAnnotEvent(dt.generateAnnotationChangeEvent());
            }
            for (i = 0; i < this.getNewSyns().size(); ++i) {
                if (this.findSynonym(this.getNewSyn(i), false) != null) continue;
                this.updateModel();
                Synonym addedSyn = ann.getSynonym(i);
                AddTransaction at = new AddTransaction(src, ann, FeatureEditPanel.this.SYN_SUBPART, addedSyn, i);
                FeatureEditPanel.this.fireAnnotEvent(at.generateAnnotationChangeEvent());
            }
            this.modelUpdated = false;
        }

        private void updateModel() {
            if (this.modelUpdated) {
                return;
            }
            AnnotatedFeatureI feat = FeatureEditPanel.this.getEditedFeature();
            feat.clearSynonyms();
            for (int i = 0; i < this.getNewSyns().size(); ++i) {
                feat.addSynonym(this.findSynonym(this.getNewSyn(i), true));
            }
            this.modelUpdated = true;
        }

        private Synonym findSynonym(String name, boolean createIfMissing) {
            for (int i = 0; i < this.getOldSyns().size(); ++i) {
                Synonym syn = this.getOldSyn(i);
                if (!syn.getName().equals(name)) continue;
                return syn;
            }
            if (createIfMissing) {
                Synonym syn = new Synonym(name);
                syn.addProperty("synonym_sgml", name);
                syn.addProperty("author", UserName.getUserName());
                return syn;
            }
            return null;
        }
    }

    private class IsProbCheckBoxListener
    implements ActionListener {
        private IsProbCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean b = FeatureEditPanel.this.isProblematicCheckbox.isSelected();
            FeatureEditPanel.this.setBooleanSubpart(b, TransactionSubpart.IS_PROBLEMATIC);
        }
    }
}

