/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.config.Config;
import apollo.config.PropSchemeChangeEvent;
import apollo.config.PropSchemeChangeListener;
import apollo.config.PropertyScheme;
import apollo.config.TierProperty;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.gui.ControlledObjectI;
import apollo.gui.ControlledPanel;
import apollo.gui.Controller;
import apollo.gui.PropertyPanel;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.genomemap.ApolloPanel;
import apollo.gui.menus.TiersMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TypePanel
extends ControlledPanel
implements ControlledObjectI,
FeatureSelectionListener,
ActionListener,
DataLoadListener,
PropSchemeChangeListener {
    PropertyScheme properties;
    Vector panels;
    ApolloPanel ap;
    Controller controller;
    JScrollPane sp;
    JPanel mainP;
    boolean autoRaise = false;
    JCheckBox autoBox;
    boolean doneInit = false;
    JFrame frame;
    String styleFileName;
    private static TypePanel typePanelSingleton;

    public static TypePanel getTypePanelInstance() {
        if (typePanelSingleton == null) {
            typePanelSingleton = new TypePanel(Controller.getMasterController(), Config.getPropertyScheme());
        }
        return typePanelSingleton;
    }

    private TypePanel(Controller c, PropertyScheme properties) {
        this.setVisible(false);
        this.init(Controller.getMasterController(), properties);
    }

    private void init(Controller c, PropertyScheme properties) {
        this.properties = properties;
        this.panels = new Vector();
        this.setController(c);
        this.jbInit();
        this.styleFileName = Config.getStyle().getFileName();
        this.frame = new JFrame("Types");
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.getScrollPane().setPreferredSize(new Dimension(300, 400));
        this.frame.getContentPane().add((Component)this.getScrollPane(), "Center");
        this.frame.pack();
    }

    public void setLocationRelativeToFrame(Dimension frameDim) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - frameDim.width) / 2 + 20;
        int y = (screenSize.height - frameDim.height) / 2 + 30;
        this.getFrame().setLocation(x, y);
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (this.getFrame() == null) {
            return;
        }
        this.getFrame().setVisible(vis);
        if (!vis) {
            this.getFrame().removeNotify();
        } else if (this.getFrame().getState() == 1) {
            this.getFrame().setState(0);
        }
    }

    public void addWindowListener(WindowListener wl) {
        this.getFrame().addWindowListener(wl);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setController(Controller c) {
        this.controller = c;
        this.controller.addListener(this);
    }

    public Controller getController() {
        return this.controller;
    }

    public boolean needsAutoRemoval() {
        return false;
    }

    public void repaint() {
        if (this.frame != null && this.frame.isVisible() && this.autoRaise) {
            this.frame.toFront();
        }
        super.repaint();
    }

    public boolean handlePropSchemeChangeEvent(PropSchemeChangeEvent evt) {
        int oldsize;
        for (int i = 0; i < this.panels.size(); ++i) {
            PropertyPanel pp = (PropertyPanel)this.panels.elementAt(i);
            pp.updateValues();
        }
        if (this.properties.size() > this.panels.size() && this.doneInit) {
            oldsize = this.panels.size();
            Vector tier_properties = this.properties.getAllTiers();
            for (int i = 0; i < tier_properties.size(); ++i) {
                boolean found = false;
                TierProperty tp = (TierProperty)tier_properties.elementAt(i);
                for (int j = 0; j < oldsize && !found; ++j) {
                    PropertyPanel pp = (PropertyPanel)this.panels.elementAt(j);
                    found = pp.getProperty() == tp;
                }
                if (found) continue;
                this.addPropertyPanel(tp);
            }
            this.redraw();
        } else if (this.orderChanged()) {
            oldsize = this.panels.size();
            for (int j = 0; j < oldsize; ++j) {
                this.remove((JPanel)this.panels.elementAt(j));
            }
            this.panels.removeAllElements();
            Vector tier_properties = this.properties.getAllTiers();
            for (int i = 0; i < tier_properties.size(); ++i) {
                TierProperty tp = (TierProperty)tier_properties.elementAt(i);
                this.addPropertyPanel(tp);
            }
            this.redraw();
        }
        return true;
    }

    protected void redraw() {
        this.sp.invalidate();
        this.sp.validate();
        Point viewportPosition = new Point(0, 0);
        this.sp.getViewport().setViewPosition(viewportPosition);
    }

    private boolean orderChanged() {
        if (this.properties.size() != this.panels.size()) {
            System.err.println("WARNING: types.size != panels.size in orderChanged");
            return false;
        }
        Vector tier_properties = this.properties.getAllTiers();
        for (int i = 0; i < tier_properties.size(); ++i) {
            PropertyPanel pp;
            TierProperty tp = (TierProperty)tier_properties.elementAt(i);
            if (tp == (pp = (PropertyPanel)this.panels.elementAt(i)).getProperty()) continue;
            return true;
        }
        return false;
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
        if (evt.getFeature() != null && this.getFrame().isVisible()) {
            int propHeight = ((JPanel)this.panels.elementAt((int)0)).getSize().height;
            int ind = this.properties.getTierInd(evt.getFeature().getTopLevelType());
            Point viewportPosition = this.sp.getViewport().getViewPosition();
            Dimension extentSize = this.sp.getViewport().getExtentSize();
            Dimension viewSize = this.sp.getViewport().getViewSize();
            viewportPosition.y = Math.min((propHeight + 4) * ind, viewSize.height - extentSize.height);
            this.sp.getViewport().setViewPosition(viewportPosition);
            if (ind < this.panels.size() && ind >= 0) {
                ((PropertyPanel)this.panels.elementAt(ind)).flash();
            }
        }
        return true;
    }

    private void jbInit() {
        this.doneInit = true;
        GridLayout layout = new GridLayout(0, 1, 1, 4);
        this.setLayout(layout);
        Vector tier_properties = this.properties.getAllTiers();
        for (int i = 0; i < tier_properties.size(); ++i) {
            this.addPropertyPanel((TierProperty)tier_properties.elementAt(i));
        }
        this.sp = new JScrollPane(this, 20, 31);
        this.sp.setPreferredSize(new Dimension(200, 300));
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.autoBox) {
            this.setAutoRaise(this.autoBox.isSelected());
        }
    }

    private void setAutoRaise(boolean state) {
        this.autoRaise = state;
    }

    private void addPropertyPanel(TierProperty fp) {
        PropertyPanel pp = new PropertyPanel(this.ap, fp);
        pp.setPreferredSize(new Dimension(0, pp.getPreferredSize().height));
        this.add(pp);
        this.panels.addElement(pp);
    }

    public JScrollPane getScrollPane() {
        return this.sp;
    }

    public boolean handleDataLoadEvent(DataLoadEvent e) {
        String newStyleFileName = Config.getStyle().getFileName();
        if (newStyleFileName.equals(this.styleFileName)) {
            return true;
        }
        this.clear();
        this.init(this.getController(), Config.getPropertyScheme());
        return true;
    }

    private void clear() {
        this.controller.removeListener(this);
        this.removeAll();
        this.properties = null;
        this.panels.clear();
        this.setVisible(false);
        this.getFrame().hide();
        this.getFrame().dispose();
        TiersMenu.types.setState(false);
    }
}

