/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.datamodel.RangeI;
import java.awt.Point;
import java.awt.Rectangle;

public class Transformer {
    public static final int UP = -1;
    public static final int DOWN = 1;
    public static final int LEFT = 1;
    public static final int RIGHT = -1;
    private Rectangle pixelBounds;
    private int[] xRange = new int[2];
    private int[] yRange = new int[2];
    private int xCentre;
    private int yCentre;
    private double xCoordsPerPixel;
    private double yCoordsPerPixel;
    private double xPixelsPerCoord;
    private double yPixelsPerCoord;
    private double xZoomFactor;
    private double yZoomFactor;
    private int xOrientation;
    private int yOrientation;
    private long xOffset;
    private int yOffset;
    private int[] xVisibleRange = new int[2];
    private int[] yVisibleRange = new int[2];

    public Transformer(Rectangle bounds) {
        this(bounds, new Rectangle(-10, -10, 10, 10));
    }

    public Transformer(Rectangle pixelBounds, Rectangle userBounds) {
        this.pixelBounds = new Rectangle(pixelBounds);
        this.xOrientation = 1;
        this.yOrientation = 1;
        this.xRange[0] = userBounds.x;
        this.yRange[0] = userBounds.y;
        this.xRange[1] = userBounds.x + userBounds.width;
        this.yRange[1] = userBounds.y + userBounds.height;
        this.reset();
    }

    public void reset() {
        this.xZoomFactor = 1.0;
        this.yZoomFactor = 1.0;
        this.xCentre = (this.xRange[1] + this.xRange[0]) / 2;
        this.yCentre = (this.yRange[1] + this.yRange[0]) / 2;
        this.calcConversions();
    }

    public void setPixelBounds(Rectangle rect) {
        this.pixelBounds = new Rectangle(rect);
        this.calcConversions();
    }

    public Rectangle getPixelBounds() {
        return this.pixelBounds;
    }

    public void setYOrientation(int orientation) {
        this.yOrientation = orientation;
        this.calcConversions();
    }

    public void setXOrientation(int orientation) {
        this.xOrientation = orientation;
        this.calcConversions();
    }

    public void setXZoomFactor(double factor) {
        this.xZoomFactor = factor;
        this.calcConversions();
    }

    public void setYZoomFactor(double factor) {
        this.yZoomFactor = factor;
        this.calcConversions();
    }

    public void setXRange(int[] limits) {
        this.xRange[0] = limits[0];
        this.xRange[1] = limits[1];
        this.calcConversions();
    }

    public void setYRange(int[] limits) {
        this.yRange[0] = limits[0];
        this.yRange[1] = limits[1];
        this.yCentre = (this.yRange[1] + this.yRange[0]) / 2;
        this.calcConversions();
    }

    public void setXMinimum(int min) {
        this.xRange[0] = min;
        this.calcConversions();
    }

    public void setYMinimum(int min) {
        this.yRange[0] = min;
        this.calcConversions();
    }

    public void setXMaximum(int max) {
        this.xRange[1] = max;
        this.calcConversions();
    }

    public void setYMaximum(int max) {
        this.yRange[1] = max;
        this.calcConversions();
    }

    public void setXCentre(int centre) {
        this.xCentre = centre;
        this.calcConversions();
    }

    public void setYCentre(int centre) {
        this.yCentre = centre;
        this.calcConversions();
    }

    public int[] getXRange() {
        return this._copyRange(this.xRange);
    }

    public int[] getYRange() {
        return this._copyRange(this.yRange);
    }

    private int[] _copyRange(int[] fromRange) {
        int[] retRange = new int[]{fromRange[0], fromRange[1]};
        return retRange;
    }

    public int getXMaximum() {
        return this.xRange[1];
    }

    public int getYMaximum() {
        return this.yRange[1];
    }

    public int getXMinimum() {
        return this.xRange[0];
    }

    public int getYMinimum() {
        return this.yRange[0];
    }

    public int getXCentre() {
        return this.xCentre;
    }

    public int getYCentre() {
        return this.yCentre;
    }

    public int[] getXVisibleRange() {
        return this._copyRange(this.xVisibleRange);
    }

    public int[] getYVisibleRange() {
        return this._copyRange(this.yVisibleRange);
    }

    private void calcConversions() {
        this.xCoordsPerPixel = (double)(this.xRange[1] - this.xRange[0] + 1) / (this.xZoomFactor * (double)this.pixelBounds.width);
        this.yCoordsPerPixel = (double)(this.yRange[1] - this.yRange[0] + 1) / (this.yZoomFactor * (double)this.pixelBounds.height);
        this.xVisibleRange[0] = (int)((double)this.xCentre - this.xCoordsPerPixel * (double)this.pixelBounds.width / 2.0);
        this.yVisibleRange[0] = (int)((double)this.yCentre - this.yCoordsPerPixel * (double)this.pixelBounds.height / 2.0);
        this.xVisibleRange[1] = (int)((double)this.xCentre + this.xCoordsPerPixel * (double)this.pixelBounds.width / 2.0) + 1;
        this.yVisibleRange[1] = (int)((double)this.yCentre + this.yCoordsPerPixel * (double)this.pixelBounds.height / 2.0) + 1;
        this.xOffset = this.xOrientation > 0 ? (long)((double)(this.xVisibleRange[0] - this.xRange[0]) / this.xCoordsPerPixel) - (long)this.pixelBounds.x : (long)((double)(this.xVisibleRange[0] - this.xRange[0]) / this.xCoordsPerPixel) + (long)this.pixelBounds.x + (long)this.pixelBounds.width - 1L;
        this.yOffset = this.yOrientation > 0 ? (int)((double)(this.yVisibleRange[0] - this.yRange[0]) / this.yCoordsPerPixel) - this.pixelBounds.y : (int)((double)(this.yVisibleRange[0] - this.yRange[0]) / this.yCoordsPerPixel) + this.pixelBounds.y + this.pixelBounds.height - 1;
        this.xPixelsPerCoord = 1.0 / this.xCoordsPerPixel;
        this.yPixelsPerCoord = 1.0 / this.yCoordsPerPixel;
    }

    public void setYVisibleMinimum(int min) {
        this.yCentre = (int)((double)min + (double)this.pixelBounds.height / 2.0 * this.yCoordsPerPixel);
        this.calcConversions();
    }

    public void setXVisibleMinimum(int min) {
        this.xCentre = (int)((double)min + (double)this.pixelBounds.width / 2.0 * this.xCoordsPerPixel);
        this.calcConversions();
    }

    public void writeFactors() {
        System.out.println("Conversion factors:-");
        System.out.println("  xOffset:         " + this.xOffset);
        System.out.println("  yOffset:         " + this.yOffset);
        System.out.println("  xCoordsPerPixel: " + this.xCoordsPerPixel);
        System.out.println("  yCoordsPerPixel: " + this.yCoordsPerPixel);
        System.out.println("  xVisibleRange:   (" + this.xVisibleRange[0] + "," + this.xVisibleRange[1] + ")");
        System.out.println("  yVisibleRange:   (" + this.yVisibleRange[0] + "," + this.yVisibleRange[1] + ")");
        System.out.println("  xZoomFactor: " + this.xZoomFactor);
        System.out.println("  yZoomFactor: " + this.yZoomFactor);
        System.out.println("Settings:-");
        System.out.println("  xRange:          (" + this.xRange[0] + "," + this.xRange[1] + ")");
        System.out.println("  yRange:          (" + this.yRange[0] + "," + this.yRange[1] + ")");
        System.out.println("  pixelBounds:     " + this.pixelBounds);
        System.out.println("  xCentre:         " + this.xCentre);
        System.out.println("  yCentre:         " + this.yCentre);
        System.out.println("  xOrientation:    " + this.xOrientation);
        System.out.println("  yOrientation:    " + this.yOrientation);
    }

    public int toPixelX(int userX) {
        return (int)((long)this.xOrientation * (-this.xOffset + (long)((double)(userX - this.xRange[0]) * this.xPixelsPerCoord)));
    }

    public PixelRange basepairRangeToPixelRange(RangeI range) {
        PixelRange pixRng = new PixelRange();
        if (this.getXOrientation() == 1) {
            pixRng.low = this.toPixelX(range.getLow() - 1);
            pixRng.hi = this.toPixelX(range.getHigh());
        } else if (this.getXOrientation() == -1) {
            pixRng.low = this.toPixelX(range.getHigh());
            pixRng.hi = this.toPixelX(range.getLow() - 1);
        }
        return pixRng;
    }

    public int toPixelY(int userY) {
        return this.yOrientation * (-this.yOffset + (int)((double)(userY - this.yRange[0]) * this.yPixelsPerCoord));
    }

    public Point toPixel(Point user) {
        return new Point(this.toPixelX(user.x), this.toPixelY(user.y));
    }

    public Point toPixel(int x, int y) {
        return this.toPixel(new Point(x, y));
    }

    public Point fromPixel(Point pixel) {
        return this.toUser(pixel);
    }

    public Point toUser(int x, int y) {
        return this.toUser(new Point(x, y));
    }

    public Point toUser(Point pixel) {
        int x = this.xOrientation == 1 ? (int)((double)(pixel.x - this.pixelBounds.x) * this.xCoordsPerPixel + (double)this.xVisibleRange[0]) : (int)((double)(this.pixelBounds.x + this.pixelBounds.width - pixel.x) * this.xCoordsPerPixel + (double)this.xVisibleRange[0]);
        int y = this.yOrientation == 1 ? (int)((double)(pixel.y - this.pixelBounds.y) * this.yCoordsPerPixel + (double)this.yVisibleRange[0]) : (int)((double)(this.pixelBounds.y + this.pixelBounds.height - pixel.y) * this.yCoordsPerPixel + (double)this.yVisibleRange[0]);
        return new Point(x, y);
    }

    public Point fromUser(Point user) {
        return this.toPixel(user);
    }

    public int minXUserCoordAtPixel(int pixel) {
        return -1;
    }

    public int maxXUserCoordAtPixel(int pixel) {
        return -1;
    }

    public int minXPixelAtUserCoord(int user) {
        return this.toPixelX(user - 1);
    }

    public int maxXPixelAtUserCoord(int user) {
        return this.toPixelX(user);
    }

    public double getYCoordsPerPixel() {
        return this.yCoordsPerPixel;
    }

    public double getXCoordsPerPixel() {
        return this.xCoordsPerPixel;
    }

    public double getYPixelsPerCoord() {
        return this.yPixelsPerCoord;
    }

    public double getXPixelsPerCoord() {
        return this.xPixelsPerCoord;
    }

    public int getYOrientation() {
        return this.yOrientation;
    }

    public int getXOrientation() {
        return this.xOrientation;
    }

    public static void main(String[] argv) {
        Transformer trans = new Transformer(new Rectangle(0, 0, 100, 100), new Rectangle(1, 1, 10, 10));
        trans.writeFactors();
        System.out.println("toPixelX for 1 = " + trans.toPixelX(1));
        System.out.println("toPixelX for 0 = " + trans.toPixelX(0));
    }

    public Object clone() throws CloneNotSupportedException {
        Transformer clone = new Transformer(this.pixelBounds, new Rectangle(this.xRange[0], this.yRange[0], this.xRange[1] - this.xRange[0], this.yRange[1] - this.yRange[0]));
        clone.setXOrientation(this.xOrientation);
        clone.setYOrientation(this.yOrientation);
        clone.setXZoomFactor(this.xZoomFactor);
        clone.setYZoomFactor(this.yZoomFactor);
        clone.setXCentre(this.xCentre);
        clone.setYCentre(this.yCentre);
        return clone;
    }

    public class PixelRange {
        public int low;
        public int hi;

        public int getWidth() {
            return this.hi - this.low + 1;
        }

        public void ensureMinimumWidth(int min) {
            if (this.getWidth() >= min) {
                return;
            }
            if (Transformer.this.getXOrientation() == 1) {
                this.hi = this.low + min - 1;
            } else if (Transformer.this.getXOrientation() == -1) {
                this.low = this.hi - min + 1;
            }
        }
    }
}

