/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

public abstract class Tier {
    int textEnd = -1;
    public static final int MINHEIGHT = 3;
    int charSpace = 0;
    int drawSpace = 10;
    int gapSpace = 1;
    int charLow;
    int charHigh;
    int drawLow;
    int drawCentre;
    int drawHigh;

    public int getTextEnd() {
        return this.textEnd;
    }

    public void setTextEnd(int newEnd) {
        this.textEnd = newEnd;
    }

    public abstract String getTierLabel();

    public void setup(int sizeChange, int charHeight) {
        this.drawSpace += sizeChange;
        int n = this.drawSpace = this.drawSpace < 3 ? 3 : this.drawSpace;
        if (this.isLabeled()) {
            this.setCharHeight(charHeight);
        } else {
            this.setCharHeight(0);
        }
    }

    protected abstract boolean isLabeled();

    public void updateUserCoordBoundaries(int lowBound) {
        this.drawLow = lowBound;
        this.drawHigh = this.drawLow + (int)((long)this.drawSpace * 10L);
        this.drawCentre = (this.drawHigh - this.drawLow + 1) / 2 + this.drawLow;
        this.charLow = this.drawHigh;
        this.charHigh = this.charLow + (int)((long)this.drawSpace * 10L);
    }

    public void setCharHeight(int height) {
        this.charSpace = height;
    }

    public int getTotalSpace() {
        return this.charSpace + this.drawSpace + this.gapSpace;
    }

    public int getDrawSpace() {
        return this.drawSpace;
    }

    public void setDrawSpace(int newSize) {
        this.drawSpace = newSize;
    }

    public int getDrawLow() {
        return this.drawLow;
    }

    public int getDrawHigh() {
        return this.drawHigh;
    }

    public int getDrawCentre() {
        return this.drawCentre;
    }

    public int getCharLow() {
        return this.charLow;
    }

    public int getCharHigh() {
        return this.charHigh;
    }
}

