/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.config.Config;
import apollo.gui.StatusPane;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class StatusBar
extends JPanel {
    private StatusPane actionPane = new StatusPane("Action", "");
    private StatusPane featurePane = new StatusPane("Feature", "");
    private StatusPane positionPane = new StatusPane("Position", "");

    public StatusBar() {
        this.setLayout(new FlowLayout(0, 10, 3));
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.add(this.positionPane);
        this.add(this.featurePane);
        if (Config.isEditingEnabled()) {
            this.add(this.actionPane);
        }
        this.setFont(new Font("Serif", 0, 16));
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.actionPane != null) {
            this.actionPane.setFont(font);
        }
        if (this.featurePane != null) {
            this.featurePane.setFont(font);
        }
        if (this.positionPane != null) {
            this.positionPane.setFont(font);
        }
    }

    public void setActionPane(String text) {
        this.actionPane.setText(text);
    }

    public void setFeaturePane(String text) {
        this.featurePane.setText(text);
    }

    public void setPositionPane(String text) {
        this.positionPane.setText(text);
    }
}

