/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.util.GuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderWindow
extends JPanel
implements ChangeListener {
    protected JSlider slider;
    protected JTextField field;
    protected String labelStr;
    protected String title;
    BoundedRangeModel model;
    protected JFrame frame;
    boolean isAdjusting = false;

    public SliderWindow(String title, String label, BoundedRangeModel model, Point location) {
        this.labelStr = label;
        this.title = title;
        this.model = model;
        this.buildGUI();
        this.frame = new JFrame(title);
        this.frame.setLocation(location);
        this.setPreferredSize(new Dimension(300, 100));
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.setSize(new Dimension(300, 100));
        this.frame.setVisible(true);
    }

    public SliderWindow(BoundedRangeModel model) {
        this.model = model;
        this.buildGUI();
    }

    protected void buildGUI() {
        FieldActionListener numberChange = new FieldActionListener();
        JPanel enclosure = new JPanel();
        enclosure.setLayout(new GridBagLayout());
        this.add((Component)enclosure, "Center");
        JLabel l = new JLabel(this.labelStr);
        this.slider = new JSlider(this.model);
        this.slider.setOrientation(0);
        this.slider.setMajorTickSpacing((this.model.getMaximum() - this.model.getMinimum()) / 4);
        this.slider.setMinorTickSpacing((this.model.getMaximum() - this.model.getMinimum()) / 10);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        enclosure.add((Component)this.slider, GuiUtil.makeConstraintAt(0, 0, 0, true));
        this.field = new JTextField();
        this.field.setPreferredSize(new Dimension(40, 40));
        l.setLabelFor(this.slider);
        JPanel fieldHolder = new JPanel(new BorderLayout());
        this.field.addActionListener(numberChange);
        this.field.setText("" + this.model.getValue());
        fieldHolder.add((Component)this.field, "Center");
        enclosure.add((Component)fieldHolder, GuiUtil.makeConstraintAt(1, 0, 0, true));
        this.slider.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JSlider) {
            int currentValue = this.slider.getValue();
            this.field.setText(String.valueOf(currentValue));
        }
    }

    class FieldActionListener
    implements ActionListener {
        FieldActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int currentValue = Integer.parseInt(SliderWindow.this.field.getText());
            SliderWindow.this.model.setValue(currentValue);
        }
    }
}

