/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.SelectionManager;
import apollo.gui.SequenceSelector;
import apollo.gui.StatusPane;
import apollo.gui.SwingWorker;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Pattern;

public class SeqSelectorTable {
    Perl5Compiler p5Compiler;
    Perl5Pattern pattern;
    private SeqFeatureI sf;
    private String searchSeqString;
    private boolean revComp;
    private Vector columns = new Vector(2);
    private Vector features = new Vector();
    private JTable resultTable;
    private StrandedZoomableApolloPanel szap;
    private SelectionManager selectionManager;
    private StatusPane statusPane;
    private boolean useRegExp;

    public SeqSelectorTable(SeqFeatureI sf, String searchSeqString, boolean revComp, StrandedZoomableApolloPanel szap, StatusPane statusPane) {
        this(sf, searchSeqString, revComp, szap, statusPane, false);
    }

    public SeqSelectorTable(SeqFeatureI sf, String searchSeqString, boolean revComp, StrandedZoomableApolloPanel szap, StatusPane statusPane, boolean useRegExp) {
        this.sf = sf;
        this.searchSeqString = searchSeqString.toUpperCase();
        this.revComp = revComp;
        this.szap = szap;
        this.useRegExp = useRegExp;
        this.selectionManager = szap.getSelectionManager();
        this.statusPane = statusPane;
        this.initTable();
        SeqSelSwingWorker w = new SeqSelSwingWorker();
        w.start();
        this.selectionManager.select(this.features, (Object)this);
        this.p5Compiler = new Perl5Compiler();
        try {
            this.pattern = (Perl5Pattern)this.p5Compiler.compile("([0-9]+)", 1);
        }
        catch (MalformedPatternException ex) {
            System.out.println("couldn't make Perl5 pattern");
        }
    }

    public JTable getTable() {
        return this.resultTable;
    }

    private void initTable() {
        this.columns.addElement("Position");
        this.columns.addElement("Sequence");
        this.resultTable = new JTable(new Vector(), this.columns);
        this.resultTable.setSelectionMode(0);
        this.resultTable.getSelectionModel().addListSelectionListener(new TableSelector());
    }

    private void fireBaseFocusEvent(String posString) {
        int pos = Integer.parseInt(posString);
        BaseFocusEvent evt = new BaseFocusEvent(this, pos, new SeqFeature());
        this.selectionManager.getController().handleBaseFocusEvent(evt);
    }

    protected class SequenceMatchModel
    extends AbstractTableModel {
        private Vector data;
        private Vector columns;

        protected SequenceMatchModel() {
        }

        protected void setData(Vector data) {
            this.data = data;
        }

        protected void setColumns(Vector columns) {
            this.columns = columns;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public String getColumnName(int column) {
            return (String)this.columns.elementAt(column);
        }

        public Object getValueAt(int row, int column) {
            SeqFeatureI match = (SeqFeatureI)this.data.elementAt(row);
            if (column == 0) {
                return match.getLow() + "-" + match.getHigh();
            }
            return match.getResidues();
        }
    }

    private class TableSelector
    implements ListSelectionListener {
        private TableSelector() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Perl5Matcher matcher = new Perl5Matcher();
            PatternMatcherInput pmInput = null;
            int row = SeqSelectorTable.this.resultTable.getSelectedRow();
            if (row >= 0 && !e.getValueIsAdjusting()) {
                Object position = SeqSelectorTable.this.resultTable.getValueAt(row, 0);
                pmInput = new PatternMatcherInput(position.toString());
                matcher.contains(pmInput, (Pattern)SeqSelectorTable.this.pattern);
                SeqSelectorTable.this.fireBaseFocusEvent(matcher.getMatch().toString());
                SeqFeature feat = (SeqFeature)SeqSelectorTable.this.features.elementAt(row);
                SeqSelectorTable.this.selectionManager.select(feat, (Object)this);
                SeqSelectorTable.this.szap.zoomToSelectionWithWindow(feat.length() * 2 - 2);
            }
        }
    }

    private class SeqSelSwingWorker
    extends SwingWorker {
        private SeqSelSwingWorker() {
        }

        public Object construct() {
            SequenceSelector sel = new SequenceSelector(SeqSelectorTable.this.sf, SeqSelectorTable.this.searchSeqString, SeqSelectorTable.this.revComp, SeqSelectorTable.this.useRegExp);
            return sel;
        }

        public void finished() {
            SequenceSelector sel = (SequenceSelector)this.get();
            SeqSelectorTable.this.features = sel.getMatches();
            SequenceMatchModel model = new SequenceMatchModel();
            model.setData(SeqSelectorTable.this.features);
            model.setColumns(SeqSelectorTable.this.columns);
            SeqSelectorTable.this.resultTable.setModel(model);
            if (SeqSelectorTable.this.statusPane != null) {
                SeqSelectorTable.this.statusPane.setText("Found sequence " + SeqSelectorTable.this.features.size() + " times");
            }
        }
    }
}

