/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.datamodel.FeatureSetI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.ControlledObjectI;
import apollo.gui.ControlledPanel;
import apollo.gui.Controller;
import apollo.gui.DisabledEditor;
import apollo.gui.Selection;
import apollo.gui.SelectionItem;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.bdgp.util.DNAUtils;

public class SeqMatchPanel
extends ControlledPanel
implements ControlledObjectI {
    StrandedZoomableApolloPanel szap;
    boolean reverseComplement = false;
    Controller controller;
    JTable table;
    DefaultTableModel model;
    String seqString = "";
    String refSeqString = "";
    String searchString = "";
    JPanel slp;
    Vector tableData;
    static /* synthetic */ Class class$apollo$datamodel$Sequence;
    static /* synthetic */ Class class$java$lang$Object;

    public SeqMatchPanel(StrandedZoomableApolloPanel szap, String searchString, String seqString, Controller c) {
        this.setController(c);
        this.szap = szap;
        if (szap.getAnnotations().getRefSequence() != null && szap.getAnnotations().getRefSequence().getResidues() != null) {
            this.refSeqString = szap.getAnnotations().getRefSequence().getResidues();
            if (szap.isReverseComplement()) {
                this.refSeqString = DNAUtils.reverseComplement((String)this.refSeqString);
                this.reverseComplement = true;
            }
        }
        this.searchString = searchString;
        this.tableData = this.findSeqMatches();
        this.componentInit();
    }

    public void setController(Controller c) {
        this.controller = c;
    }

    public Controller getController() {
        return this.controller;
    }

    public void componentInit() {
        this.setPreferredSize(new Dimension(100, 300));
        this.setLayout(new BorderLayout());
        this.model = new SeqMatchModel();
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(class$apollo$datamodel$Sequence == null ? (class$apollo$datamodel$Sequence = SeqMatchPanel.class$("apollo.datamodel.Sequence")) : class$apollo$datamodel$Sequence, new SequenceRenderer());
        this.table.setDefaultEditor(class$apollo$datamodel$Sequence == null ? (class$apollo$datamodel$Sequence = SeqMatchPanel.class$("apollo.datamodel.Sequence")) : class$apollo$datamodel$Sequence, new DisabledEditor());
        this.table.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = SeqMatchPanel.class$("java.lang.Object")) : class$java$lang$Object, new DisabledEditor());
        this.model.addColumn("Position");
        this.model.addColumn("Sequence");
        this.model.addColumn("Features");
        ListSelectionModel rsm = this.table.getSelectionModel();
        SeqMatchTableListener stl = new SeqMatchTableListener(rsm);
        rsm.addListSelectionListener(stl);
        this.table.addMouseListener(stl);
        JScrollPane sp = new JScrollPane(this.table);
        this.slp = new JPanel();
        JSplitPane split = new JSplitPane(0, false, sp, this.slp);
        split.setDividerLocation(150);
        this.add((Component)split, "Center");
        this.setMinimumSize(new Dimension(100, 150));
        this.populateTable();
    }

    protected Vector findSeqMatches() {
        Vector<SeqFeature> matches = new Vector<SeqFeature>();
        int length = this.searchString.length();
        int seqPosition = 0;
        while ((seqPosition = this.refSeqString.indexOf(this.searchString, seqPosition + 1)) != -1) {
            SeqFeature match = new SeqFeature(seqPosition, seqPosition + length, "match" + seqPosition);
            matches.addElement(match);
        }
        return matches;
    }

    protected void populateTable() {
        this.model.setNumRows(0);
        this.tableData = this.sortFeatures(this.tableData);
        for (int i = 0; i < this.tableData.size(); ++i) {
            SeqFeatureI sf = (SeqFeatureI)this.tableData.elementAt(i);
            this.model.addRow(new Object[]{Long.toString(sf.getStart()), sf, sf});
        }
        if (this.tableData.size() > 0) {
            // empty if block
        }
        this.repaint();
    }

    protected Vector sortFeatures(Vector unsorted) {
        return unsorted;
    }

    public void fireBaseFocusEvent(String pos) {
        int position = Integer.parseInt(pos);
        this.fireBaseFocusEvent(position);
    }

    public void fireBaseFocusEvent(int pos) {
        BaseFocusEvent evt = new BaseFocusEvent(this, pos, new SeqFeature());
        this.controller.handleBaseFocusEvent(evt);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SequenceRenderer
    extends JLabel
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            System.out.println("Rendering sequence component");
            if (value == null) {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
                this.setText("NO SEQ!!!!!");
                return this;
            }
            if (value instanceof SeqFeatureI) {
                String seqStr = ((SeqFeatureI)value).getResidues();
                if (seqStr != null) {
                    this.setText(seqStr);
                } else {
                    this.setText("NO SEQ!!!!");
                }
            }
            return this;
        }
    }

    class SeqMatchTableListener
    extends MouseAdapter
    implements ListSelectionListener,
    MouseListener {
        ListSelectionModel lsm;

        public SeqMatchTableListener(ListSelectionModel lsm) {
            this.lsm = lsm;
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() > 1) {
                // empty if block
            }
        }

        public void valueChanged(ListSelectionEvent lse) {
            if (!lse.getValueIsAdjusting()) {
                // empty if block
            }
        }

        protected Selection getSelected(int[] selIndices, boolean expand) {
            Selection selection = new Selection();
            for (int i = 0; i < selIndices.length; ++i) {
                RangeI sf = null;
                if (sf instanceof DrawableSeqFeature) {
                    selection.add(new SelectionItem(this, ((DrawableSeqFeature)((Object)sf)).getFeature()));
                    continue;
                }
                if (sf.canHaveChildren() && expand) {
                    FeatureSetI fs = (FeatureSetI)sf;
                    for (int j = 0; j < fs.size(); ++j) {
                        selection.add(new SelectionItem(this, fs.getFeatureAt(j)));
                    }
                    continue;
                }
                selection.add(new SelectionItem(this, (SeqFeatureI)sf));
            }
            return selection;
        }

        protected int[] getSelectedIndices(int start, int stop) {
            if (start == -1 || stop == -1) {
                return new int[0];
            }
            int[] guesses = new int[stop - start + 1];
            int index = 0;
            for (int i = start; i <= stop; ++i) {
                if (!this.lsm.isSelectedIndex(i)) continue;
                guesses[index++] = i;
            }
            int[] realthing = new int[index];
            System.arraycopy(guesses, 0, realthing, 0, index);
            return realthing;
        }
    }

    class SeqMatchModel
    extends DefaultTableModel {
        SeqMatchModel() {
        }

        public Class getColumnClass(int c) {
            if (c == 1) {
                return class$apollo$datamodel$Sequence == null ? (class$apollo$datamodel$Sequence = SeqMatchPanel.class$("apollo.datamodel.Sequence")) : class$apollo$datamodel$Sequence;
            }
            return super.getColumnClass(c);
        }
    }
}

